/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.chromattic.api.query.Ordering;
import org.chromattic.api.query.Query;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryResult;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.activity.filter.ActivityCounter;
import org.exoplatform.social.core.activity.filter.ActivityFilter;
import org.exoplatform.social.core.activity.filter.ActivityIterator;
import org.exoplatform.social.core.activity.filter.ActivityUpdateFilter;
import org.exoplatform.social.core.activity.model.ActivityStreamImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.chromattic.entity.ActivityDayEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityListEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityParameters;
import org.exoplatform.social.core.chromattic.entity.HidableEntity;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.entity.LockableEntity;
import org.exoplatform.social.core.chromattic.filter.JCRFilterLiteral;
import org.exoplatform.social.core.chromattic.utils.ActivityList;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.RelationshipStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.storage.exception.NodeNotFoundException;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.ActivityBuilderWhere;
import org.exoplatform.social.core.storage.query.WhereExpression;

public class ActivityStorageImpl
extends AbstractStorage
implements ActivityStorage {
    private static final Log LOG = ExoLogger.getLogger(ActivityStorageImpl.class);
    private static final Pattern MENTION_PATTERN = Pattern.compile("@([^\\s]+)|@([^\\s]+)$");
    public static final Pattern USER_NAME_VALIDATOR_REGEX = Pattern.compile("^[\\p{L}][\\p{L}._\\-\\d]+$");
    private ActivityStorage activityStorage;
    private final SortedSet<ActivityProcessor> activityProcessors;
    private final RelationshipStorage relationshipStorage;
    private final IdentityStorage identityStorage;
    private final SpaceStorage spaceStorage;

    public ActivityStorageImpl(RelationshipStorage relationshipStorage, IdentityStorage identityStorage, SpaceStorage spaceStorage) {
        this.relationshipStorage = relationshipStorage;
        this.identityStorage = identityStorage;
        this.spaceStorage = spaceStorage;
        this.activityProcessors = new TreeSet<ActivityProcessor>(ActivityStorageImpl.processorComparator());
    }

    protected void _createActivity(Identity owner, ExoSocialActivity activity) throws NodeNotFoundException {
        IdentityEntity identityEntity = this._findById(IdentityEntity.class, owner.getId());
        IdentityEntity posterIdentityEntity = activity.getUserId() != null ? this._findById(IdentityEntity.class, activity.getUserId()) : identityEntity;
        ActivityListEntity activityListEntity = identityEntity.getActivityList();
        ActivityList entities = new ActivityList(activityListEntity);
        long currentMillis = System.currentTimeMillis();
        long activityMillis = activity.getPostedTime() != null ? activity.getPostedTime() : currentMillis;
        ActivityEntity activityEntity = activityListEntity.createActivity(String.valueOf(activityMillis));
        entities.add(activityEntity);
        activityEntity.setIdentity(identityEntity);
        activityEntity.setComment(Boolean.FALSE);
        activityEntity.setPostedTime(activityMillis);
        activityEntity.setLastUpdated(activityMillis);
        activityEntity.setPosterIdentity(posterIdentityEntity);
        activity.setId(activityEntity.getId());
        activity.setStreamOwner(identityEntity.getRemoteId());
        activity.setPostedTime(activityMillis);
        activity.setReplyToId(new String[0]);
        activity.setUpdated(activityMillis);
        activity.setMentionedIds(this.processMentions(activity.getMentionedIds(), activity.getTitle(), true));
        this.fillActivityEntityFromActivity(activity, activityEntity);
    }

    protected void _saveActivity(ExoSocialActivity activity) throws NodeNotFoundException {
        ActivityEntity activityEntity = this._findById(ActivityEntity.class, activity.getId());
        this.fillActivityEntityFromActivity(activity, activityEntity);
    }

    private void fillActivityEntityFromActivity(ExoSocialActivity activity, ActivityEntity activityEntity) {
        activityEntity.setTitle(activity.getTitle());
        activityEntity.setTitleId(activity.getTitleId());
        activityEntity.setBody(activity.getBody());
        activityEntity.setBodyId(activity.getBodyId());
        activityEntity.setLikes(activity.getLikeIdentityIds());
        activityEntity.setType(activity.getType());
        activityEntity.setAppId(activity.getAppId());
        activityEntity.setExternalId(activity.getExternalId());
        activityEntity.setUrl(activity.getUrl());
        activityEntity.setPriority(activity.getPriority());
        activityEntity.setLastUpdated(activity.getUpdated().getTime());
        HidableEntity hidable = this._getMixin(activityEntity, HidableEntity.class, true);
        hidable.setHidden(activity.isHidden());
        LockableEntity lockable = this._getMixin(activityEntity, LockableEntity.class, true);
        lockable.setLocked(activity.isLocked());
        activityEntity.setMentioners(activity.getMentionedIds());
        activityEntity.setCommenters(activity.getCommentedIds());
        Map params = activity.getTemplateParams();
        if (params != null) {
            activityEntity.putParams(params);
        }
        this.fillStream(activityEntity, activity);
    }

    private void fillActivityFromEntity(ActivityEntity activityEntity, ExoSocialActivity activity) {
        HidableEntity hidable;
        ActivityParameters params;
        String[] commenters;
        String[] mentioners;
        activity.setId(activityEntity.getId());
        activity.setTitle(activityEntity.getTitle());
        activity.setTitleId(activityEntity.getTitleId());
        activity.setBody(activityEntity.getBody());
        activity.setBodyId(activityEntity.getBodyId());
        activity.setUserId(activityEntity.getPosterIdentity().getId());
        activity.setPostedTime(activityEntity.getPostedTime());
        activity.setUpdated(activityEntity.getLastUpdated());
        activity.setType(activityEntity.getType());
        activity.setAppId(activityEntity.getAppId());
        activity.setExternalId(activityEntity.getExternalId());
        activity.setUrl(activityEntity.getUrl());
        activity.setPriority(activityEntity.getPriority());
        activity.isComment(activityEntity.isComment());
        ArrayList<String> computeCommentid = new ArrayList<String>();
        for (ActivityEntity commentEntity : activityEntity.getComments()) {
            computeCommentid.add(commentEntity.getId());
        }
        activity.setReplyToId(computeCommentid.toArray(new String[0]));
        String[] likes = activityEntity.getLikes();
        if (likes != null) {
            activity.setLikeIdentityIds(activityEntity.getLikes());
        }
        if ((mentioners = activityEntity.getMentioners()) != null) {
            activity.setMentionedIds(activityEntity.getMentioners());
        }
        if ((commenters = activityEntity.getCommenters()) != null) {
            activity.setCommentedIds(activityEntity.getCommenters());
        }
        if ((params = activityEntity.getParams()) != null) {
            activity.setTemplateParams(new LinkedHashMap<String, String>(params.getParams()));
        } else {
            activity.setTemplateParams(new HashMap());
        }
        LockableEntity lockable = this._getMixin(activityEntity, LockableEntity.class, false);
        if (lockable != null) {
            activity.isLocked(lockable.getLocked());
        }
        if ((hidable = this._getMixin(activityEntity, HidableEntity.class, false)) != null) {
            activity.isHidden(hidable.getHidden());
        }
        this.fillStream(activityEntity, activity);
    }

    private void fillStream(ActivityEntity activityEntity, ExoSocialActivity activity) {
        ActivityStreamImpl stream = new ActivityStreamImpl();
        IdentityEntity identityEntity = null;
        try {
            IdentityEntity streamOwnerEntity;
            Identity streamOwnerIdentity = this.identityStorage.findIdentity("space", activity.getStreamOwner());
            identityEntity = streamOwnerEntity = this._findById(IdentityEntity.class, streamOwnerIdentity.getId());
            activityEntity.setIdentity(streamOwnerEntity);
        }
        catch (Exception e) {
            identityEntity = activityEntity.getIdentity();
        }
        stream.setId(identityEntity.getId());
        stream.setPrettyId(identityEntity.getRemoteId());
        stream.setType(identityEntity.getProviderId());
        if (identityEntity != null && "space".equals(identityEntity.getProviderId())) {
            Space space = this.spaceStorage.getSpaceByPrettyName(identityEntity.getRemoteId());
            if (space != null) {
                String groupId = space.getGroupId().split("/")[2];
                stream.setPermaLink(LinkProvider.getActivityUriForSpace(identityEntity.getRemoteId(), groupId));
            }
        } else {
            stream.setPermaLink(LinkProvider.getActivityUri(identityEntity.getProviderId(), identityEntity.getRemoteId()));
        }
        activity.setActivityStream(stream);
        activity.setStreamId(stream.getId());
        activity.setStreamOwner(stream.getPrettyId());
    }

    private List<Identity> getSpacesId(Identity ownerIdentity) {
        ArrayList<Identity> identitiesId = new ArrayList<Identity>();
        long offset = 0L;
        long limit = 30L;
        int loaded = this.loadIdRange(ownerIdentity, offset, offset + limit, identitiesId);
        while ((long)loaded == limit) {
            loaded = this.loadIdRange(ownerIdentity, offset, offset + limit, identitiesId);
            offset += limit;
        }
        return identitiesId;
    }

    private int loadIdRange(Identity ownerIdentity, long offset, long limit, List<Identity> result) {
        List<Space> spaces = this.spaceStorage.getAccessibleSpaces(ownerIdentity.getRemoteId(), offset, limit);
        Identity identity = null;
        for (Space space : spaces) {
            identity = this.identityStorage.findIdentity("space", space.getPrettyName());
            if (identity == null) continue;
            result.add(identity);
        }
        return spaces.size();
    }

    private Map<String, Identity> getSpacesIdOfIdentity(Identity identity) {
        HashMap<String, Identity> identitiesId = new HashMap<String, Identity>();
        List<Space> spaces = this.spaceStorage.getAccessibleSpaces(identity.getRemoteId());
        for (Space space : spaces) {
            identitiesId.put(space.getPrettyName(), this.identityStorage.findIdentity("space", space.getPrettyName()));
        }
        return identitiesId;
    }

    private static Comparator<ActivityProcessor> processorComparator() {
        return new Comparator<ActivityProcessor>(){

            @Override
            public int compare(ActivityProcessor p1, ActivityProcessor p2) {
                if (p1 == null || p2 == null) {
                    throw new IllegalArgumentException("Cannot compare null ActivityProcessor");
                }
                return p1.getPriority() - p2.getPriority();
            }
        };
    }

    private void processActivity(ExoSocialActivity existingActivity) {
        Iterator it = this.activityProcessors.iterator();
        while (it.hasNext()) {
            try {
                ((ActivityProcessor)it.next()).processActivity(existingActivity);
            }
            catch (Exception e) {
                LOG.warn((Object)("activity processing failed " + e.getMessage()));
            }
        }
    }

    private ActivityStorage getStorage() {
        return this.activityStorage != null ? this.activityStorage : this;
    }

    @Override
    public ExoSocialActivity getActivity(String activityId) throws ActivityStorageException {
        try {
            ActivityEntity activityEntity = this._findById(ActivityEntity.class, activityId);
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setId(activityEntity.getId());
            this.fillActivityFromEntity(activityEntity, activity);
            this.processActivity(activity);
            return activity;
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    @Override
    public List<ExoSocialActivity> getUserActivities(Identity owner) throws ActivityStorageException {
        return this.getUserActivities(owner, 0L, this.getNumberOfUserActivities(owner));
    }

    @Override
    public List<ExoSocialActivity> getUserActivities(Identity owner, long offset, long limit) throws ActivityStorageException {
        if (owner == null) {
            return Collections.emptyList();
        }
        ActivityFilter filter = new ActivityFilter(){};
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.simple().poster(owner).mentioner(owner).commenter(owner).liker(owner).owners(owner), filter, offset, limit);
    }

    @Override
    public void saveComment(ExoSocialActivity activity, ExoSocialActivity comment) throws ActivityStorageException {
        try {
            String[] ids;
            long currentMillis = System.currentTimeMillis();
            long commentMillis = comment.getPostedTime() != null ? comment.getPostedTime() : currentMillis;
            ActivityEntity activityEntity = this._findById(ActivityEntity.class, activity.getId());
            ActivityEntity commentEntity = activityEntity.createComment(String.valueOf(commentMillis));
            activityEntity.setMentioners(this.processMentions(activity.getMentionedIds(), comment.getTitle(), true));
            activityEntity.setCommenters(this.processCommenters(activity.getCommentedIds(), comment.getUserId(), true));
            activityEntity.getComments().add(commentEntity);
            activityEntity.setLastUpdated(currentMillis);
            commentEntity.setTitle(comment.getTitle());
            commentEntity.setType(comment.getType());
            commentEntity.setTitleId(comment.getTitleId());
            commentEntity.setBody(comment.getBody());
            commentEntity.setIdentity(activityEntity.getIdentity());
            commentEntity.setPosterIdentity(this._findById(IdentityEntity.class, comment.getUserId()));
            commentEntity.setComment(Boolean.TRUE);
            commentEntity.setPostedTime(commentMillis);
            commentEntity.setLastUpdated(commentMillis);
            HidableEntity hidable = this._getMixin(commentEntity, HidableEntity.class, true);
            hidable.setHidden(comment.isHidden());
            comment.setId(commentEntity.getId());
            Map params = comment.getTemplateParams();
            if (params != null) {
                commentEntity.putParams(params);
            }
            ArrayList<Object> listIds = (ids = activity.getReplyToId()) != null ? new ArrayList<String>(Arrays.asList(ids)) : new ArrayList<String>();
            listIds.add(commentEntity.getId());
            activity.setReplyToId(listIds.toArray(new String[0]));
        }
        catch (NodeNotFoundException e) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_SAVE_COMMENT, e.getMessage(), e);
        }
        this.getSession().save();
        LOG.debug((Object)String.format("Comment %s by %s (%s) created", comment.getTitle(), comment.getUserId(), comment.getId()));
    }

    @Override
    public ExoSocialActivity saveActivity(Identity owner, ExoSocialActivity activity) throws ActivityStorageException {
        try {
            Validate.notNull((Object)owner, (String)"owner must not be null.");
            Validate.notNull((Object)activity, (String)"activity must not be null.");
            Validate.notNull((Object)activity.getUpdated(), (String)"Activity.getUpdated() must not be null.");
            Validate.notNull((Object)activity.getPostedTime(), (String)"Activity.getPostedTime() must not be null.");
            Validate.notNull((Object)activity.getTitle(), (String)"Activity.getTitle() must not be null.");
        }
        catch (IllegalArgumentException e) {
            throw new ActivityStorageException(ActivityStorageException.Type.ILLEGAL_ARGUMENTS, e.getMessage(), e);
        }
        try {
            if (activity.getId() == null) {
                this._createActivity(owner, activity);
            } else {
                this._saveActivity(activity);
            }
            this.getSession().save();
            LOG.debug((Object)String.format("Activity %s by %s (%s) saved", activity.getTitle(), activity.getUserId(), activity.getId()));
            return activity;
        }
        catch (NodeNotFoundException e) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_SAVE_ACTIVITY, e.getMessage(), e);
        }
    }

    @Override
    public ExoSocialActivity getParentActivity(ExoSocialActivity comment) throws ActivityStorageException {
        try {
            ActivityEntity commentEntity = this._findById(ActivityEntity.class, comment.getId());
            ActivityEntity parentActivityEntity = commentEntity.getParentActivity();
            return this.getStorage().getActivity(parentActivityEntity.getId());
        }
        catch (NodeNotFoundException e) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_GET_ACTIVITY, e.getMessage(), e);
        }
    }

    @Override
    public void deleteActivity(String activityId) throws ActivityStorageException {
        try {
            ActivityEntity activityEntity = this._findById(ActivityEntity.class, activityId);
            ActivityDayEntity dayEntity = activityEntity.getDay();
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle(activityEntity.getTitle());
            activity.setUserId(activityEntity.getIdentity().getId());
            activity.setId(activityEntity.getId());
            if (activityEntity.isComment().booleanValue()) {
                ActivityEntity activityEntityOfComment = activityEntity.getParentActivity();
                activityEntityOfComment.setMentioners(this.processMentions(activityEntityOfComment.getMentioners(), activityEntity.getTitle(), false));
                activityEntityOfComment.setCommenters(this.processCommenters(activityEntityOfComment.getCommenters(), activityEntity.getPosterIdentity().getId(), false));
            } else {
                activityEntity.setMentioners(this.processMentions(activityEntity.getMentioners(), activityEntity.getTitle(), false));
            }
            this._removeById(ActivityEntity.class, activityId);
            if (dayEntity != null) {
                dayEntity.desc();
            }
            this.getSession().save();
            LOG.debug((Object)String.format("Activity or comment %s by %s (%s) removed", activity.getTitle(), activity.getUserId(), activity.getId()));
        }
        catch (NodeNotFoundException e) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_DELETE_ACTIVITY, e.getMessage(), e);
        }
    }

    @Override
    public void deleteComment(String activityId, String commentId) throws ActivityStorageException {
        this.deleteActivity(commentId);
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfIdentities(List<Identity> connectionList, long offset, long limit) throws ActivityStorageException {
        return this.getActivitiesOfIdentities(connectionList, null, offset, limit);
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfIdentities(List<Identity> connectionList, ActivityStorage.TimestampType type, long offset, long limit) throws ActivityStorageException {
        if (connectionList.size() == 0) {
            return Collections.emptyList();
        }
        QueryResult results = this.getActivitiesOfIdentitiesQuery(connectionList, type).objects(Long.valueOf(offset), Long.valueOf(limit));
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        while (results.hasNext()) {
            activities.add(this.getStorage().getActivity(((ActivityEntity)results.next()).getId()));
        }
        return activities;
    }

    private Query<ActivityEntity> getActivitiesOfIdentitiesQuery(List<Identity> connectionList, ActivityStorage.TimestampType type) throws ActivityStorageException {
        QueryBuilder builder = this.getSession().createQueryBuilder(ActivityEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        boolean first = true;
        whereExpression.startGroup();
        for (Identity currentIdentity : connectionList) {
            if (first) {
                first = false;
            } else {
                whereExpression.or();
            }
            whereExpression.equals(ActivityEntity.identity, currentIdentity.getId());
        }
        whereExpression.endGroup();
        whereExpression.and().equals(ActivityEntity.isComment, Boolean.FALSE);
        if (type != null) {
            switch (type) {
                case NEWER: {
                    whereExpression.and().greater(ActivityEntity.postedTime, type.get());
                    break;
                }
                case OLDER: {
                    whereExpression.and().lesser(ActivityEntity.postedTime, type.get());
                }
            }
        }
        builder.where(whereExpression.toString());
        if (ActivityStorage.TimestampType.UPDATED.equals((Object)type)) {
            builder.orderBy(ActivityEntity.lastUpdated.getName(), Ordering.DESC).orderBy(ActivityEntity.postedTime.getName(), Ordering.DESC);
        } else {
            builder.orderBy(ActivityEntity.postedTime.getName(), Ordering.DESC);
        }
        return builder.get();
    }

    @Override
    public int getNumberOfUserActivities(Identity owner) throws ActivityStorageException {
        if (owner == null) {
            return 0;
        }
        ActivityFilter filter = new ActivityFilter(){};
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.simple().mentioner(owner).owners(owner), filter, 0L, 0L).size();
    }

    @Override
    public int getNumberOfNewerOnUserActivities(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        if (ownerIdentity == null) {
            return 0;
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_OLDER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(baseActivity.getPostedTime()));
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.simple().owners(ownerIdentity), filter).objects().size();
    }

    @Override
    public List<ExoSocialActivity> getNewerOnUserActivities(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        if (ownerIdentity == null) {
            return Collections.emptyList();
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_NEWER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.simple().mentioner(ownerIdentity).owners(ownerIdentity), filter, 0L, (long)limit);
    }

    @Override
    public int getNumberOfOlderOnUserActivities(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        if (ownerIdentity == null) {
            return 0;
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_OLDER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.OLDER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.simple().mentioner(ownerIdentity).owners(ownerIdentity), filter).objects().size();
    }

    @Override
    public List<ExoSocialActivity> getOlderOnUserActivities(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        if (ownerIdentity == null) {
            return Collections.emptyList();
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_OLDER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.OLDER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.simple().mentioner(ownerIdentity).owners(ownerIdentity), filter, 0L, (long)limit);
    }

    @Override
    public List<ExoSocialActivity> getActivityFeed(Identity ownerIdentity, int offset, int limit) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.addAll(this.relationshipStorage.getConnections(ownerIdentity));
        identities.addAll(this.getSpacesId(ownerIdentity));
        identities.add(ownerIdentity);
        ActivityFilter filter = new ActivityFilter(){};
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.simple().mentioner(ownerIdentity).owners(identities), filter, (long)offset, (long)limit);
    }

    @Override
    public int getNumberOfActivitesOnActivityFeed(Identity ownerIdentity) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.addAll(this.relationshipStorage.getConnections(ownerIdentity));
        identities.addAll(this.getSpacesId(ownerIdentity));
        identities.add(ownerIdentity);
        ActivityFilter filter = new ActivityFilter(){};
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.simple().mentioner(ownerIdentity).owners(identities), filter).objects().size();
    }

    @Override
    public int getNumberOfNewerOnActivityFeed(Identity ownerIdentity, Long sinceTime) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.addAll(this.relationshipStorage.getConnections(ownerIdentity));
        identities.addAll(this.getSpacesId(ownerIdentity));
        identities.add(ownerIdentity);
        ActivityFilter filter = ActivityFilter.ACTIVITY_NEWER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(sinceTime));
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.simple().mentioner(ownerIdentity).owners(identities), filter).objects().size();
    }

    @Override
    public int getNumberOfNewerOnUserActivities(Identity ownerIdentity, Long sinceTime) {
        if (ownerIdentity == null) {
            return 0;
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_NEWER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(sinceTime));
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.simple().mentioner(ownerIdentity).owners(ownerIdentity), filter).objects().size();
    }

    @Override
    public int getNumberOfNewerOnActivitiesOfConnections(Identity ownerIdentity, Long sinceTime) {
        List<Identity> connectionList = this.relationshipStorage.getConnections(ownerIdentity);
        connectionList.add(ownerIdentity);
        ActivityFilter filter = ActivityFilter.ACTIVITY_NEWER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(sinceTime));
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.simple().owners(connectionList), filter).objects().size();
    }

    @Override
    public int getNumberOfNewerOnUserSpacesActivities(Identity ownerIdentity, Long sinceTime) {
        List<Identity> spaceList = this.getSpacesId(ownerIdentity);
        if (spaceList.size() == 0) {
            return 0;
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_SPACE_NEWER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(sinceTime));
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.space().owners(spaceList), filter).objects().size();
    }

    @Override
    public int getNumberOfNewerOnActivityFeed(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.addAll(this.relationshipStorage.getConnections(ownerIdentity));
        identities.addAll(this.getSpacesId(ownerIdentity));
        identities.add(ownerIdentity);
        ActivityFilter filter = ActivityFilter.ACTIVITY_NEWER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.simple().mentioner(ownerIdentity).owners(identities), filter).objects().size();
    }

    @Override
    public List<ExoSocialActivity> getNewerOnActivityFeed(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.addAll(this.relationshipStorage.getConnections(ownerIdentity));
        identities.addAll(this.getSpacesId(ownerIdentity));
        identities.add(ownerIdentity);
        ActivityFilter filter = ActivityFilter.ACTIVITY_NEWER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.simple().mentioner(ownerIdentity).owners(identities), filter, 0L, (long)limit);
    }

    @Override
    public int getNumberOfOlderOnActivityFeed(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.addAll(this.relationshipStorage.getConnections(ownerIdentity));
        identities.addAll(this.getSpacesId(ownerIdentity));
        identities.add(ownerIdentity);
        ActivityFilter filter = ActivityFilter.ACTIVITY_OLDER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.OLDER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.simple().mentioner(ownerIdentity).owners(identities), filter).objects().size();
    }

    @Override
    public List<ExoSocialActivity> getOlderOnActivityFeed(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.addAll(this.relationshipStorage.getConnections(ownerIdentity));
        identities.addAll(this.getSpacesId(ownerIdentity));
        identities.add(ownerIdentity);
        ActivityFilter filter = ActivityFilter.ACTIVITY_OLDER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.OLDER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.simple().mentioner(ownerIdentity).owners(identities), filter, 0L, (long)limit);
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfConnections(Identity ownerIdentity, int offset, int limit) {
        List<Identity> connections = this.relationshipStorage.getConnections(ownerIdentity);
        if (connections.size() <= 0) {
            return Collections.emptyList();
        }
        ActivityFilter filter = new ActivityFilter(){};
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.simple().owners(connections), filter, (long)offset, (long)limit);
    }

    @Override
    public int getNumberOfActivitiesOfConnections(Identity ownerIdentity) {
        List<Identity> connectionList = this.relationshipStorage.getConnections(ownerIdentity);
        if (connectionList.size() <= 0) {
            return 0;
        }
        ActivityFilter filter = new ActivityFilter(){};
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.simple().owners(connectionList), filter).objects().size();
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfIdentity(Identity ownerIdentity, long offset, long limit) throws ActivityStorageException {
        return this.getUserActivities(ownerIdentity, offset, limit);
    }

    @Override
    public int getNumberOfNewerOnActivitiesOfConnections(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        List<Identity> connectionList = this.relationshipStorage.getConnections(ownerIdentity);
        connectionList.add(ownerIdentity);
        ActivityFilter filter = ActivityFilter.ACTIVITY_NEWER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.simple().owners(connectionList), filter).objects().size();
    }

    @Override
    public List<ExoSocialActivity> getNewerOnActivitiesOfConnections(Identity ownerIdentity, ExoSocialActivity baseActivity, long limit) {
        List<Identity> connectionList = this.relationshipStorage.getConnections(ownerIdentity);
        connectionList.add(ownerIdentity);
        ActivityFilter filter = ActivityFilter.ACTIVITY_NEWER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.simple().owners(connectionList), filter, 0L, limit);
    }

    @Override
    public int getNumberOfOlderOnActivitiesOfConnections(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        List<Identity> connectionList = this.relationshipStorage.getConnections(ownerIdentity);
        connectionList.add(ownerIdentity);
        ActivityFilter filter = ActivityFilter.ACTIVITY_OLDER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.OLDER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.simple().owners(connectionList), filter).objects().size();
    }

    @Override
    public List<ExoSocialActivity> getOlderOnActivitiesOfConnections(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        List<Identity> connectionList = this.relationshipStorage.getConnections(ownerIdentity);
        connectionList.add(ownerIdentity);
        ActivityFilter filter = ActivityFilter.ACTIVITY_OLDER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.OLDER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.simple().owners(connectionList), filter, 0L, (long)limit);
    }

    @Override
    public List<ExoSocialActivity> getUserSpacesActivities(Identity ownerIdentity, int offset, int limit) {
        List<Identity> spaceList = this.getSpacesId(ownerIdentity);
        if (spaceList.size() == 0) {
            return Collections.emptyList();
        }
        ActivityFilter filter = new ActivityFilter(){};
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.simple().owners(spaceList), filter, 0L, (long)limit);
    }

    @Override
    public int getNumberOfUserSpacesActivities(Identity ownerIdentity) {
        List<Identity> spaceList = this.getSpacesId(ownerIdentity);
        if (spaceList.size() == 0) {
            return 0;
        }
        ActivityFilter filter = new ActivityFilter(){};
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.simple().owners(spaceList), filter).objects().size();
    }

    @Override
    public int getNumberOfNewerOnUserSpacesActivities(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        List<Identity> spaceList = this.getSpacesId(ownerIdentity);
        if (spaceList.size() == 0) {
            return 0;
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_NEWER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.simple().owners(spaceList), filter).objects().size();
    }

    @Override
    public List<ExoSocialActivity> getNewerOnUserSpacesActivities(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        List<Identity> spaceList = this.getSpacesId(ownerIdentity);
        if (spaceList.size() == 0) {
            return Collections.emptyList();
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_NEWER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.simple().owners(spaceList), filter, 0L, (long)limit);
    }

    @Override
    public int getNumberOfOlderOnUserSpacesActivities(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        List<Identity> spaceList = this.getSpacesId(ownerIdentity);
        if (spaceList.size() == 0) {
            return 0;
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_OLDER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.OLDER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.simple().owners(spaceList), filter).objects().size();
    }

    @Override
    public List<ExoSocialActivity> getOlderOnUserSpacesActivities(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        List<Identity> spaceList = this.getSpacesId(ownerIdentity);
        if (spaceList.size() == 0) {
            return Collections.emptyList();
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_OLDER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.OLDER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.simple().owners(spaceList), filter, 0L, (long)limit);
    }

    @Override
    public List<ExoSocialActivity> getComments(ExoSocialActivity existingActivity, int offset, int limit) {
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        List<String> commentIds = Arrays.asList(this.getStorage().getActivity(existingActivity.getId()).getReplyToId());
        limit = limit > commentIds.size() ? commentIds.size() : limit;
        int maxIndex = limit + offset > commentIds.size() ? commentIds.size() : limit + offset;
        for (String commentId : commentIds.subList(offset, maxIndex)) {
            ExoSocialActivity comment = this.getActivity(commentId);
            if (comment.isHidden()) continue;
            activities.add(this.getStorage().getActivity(commentId));
        }
        return activities;
    }

    @Override
    public int getNumberOfComments(ExoSocialActivity existingActivity) {
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        List<String> commentIds = Arrays.asList(this.getStorage().getActivity(existingActivity.getId()).getReplyToId());
        for (String commentId : commentIds) {
            ExoSocialActivity comment = this.getActivity(commentId);
            if (comment.isHidden()) continue;
            activities.add(this.getStorage().getActivity(commentId));
        }
        return activities.size();
    }

    @Override
    public int getNumberOfNewerComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment) {
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        List<String> commentIds = Arrays.asList(this.getStorage().getActivity(existingActivity.getId()).getReplyToId());
        int baseIndex = commentIds.indexOf(baseComment.getId());
        if (baseIndex > commentIds.size()) {
            baseIndex = commentIds.size();
        }
        for (String commentId : commentIds.subList(0, baseIndex)) {
            ExoSocialActivity comment = this.getActivity(commentId);
            if (comment.isHidden()) continue;
            activities.add(this.getStorage().getActivity(commentId));
        }
        return activities.size();
    }

    @Override
    public List<ExoSocialActivity> getNewerComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment, int limit) {
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        List<String> commentIds = Arrays.asList(this.getStorage().getActivity(existingActivity.getId()).getReplyToId());
        int baseIndex = commentIds.indexOf(baseComment.getId());
        if (baseIndex > limit) {
            baseIndex = limit;
        }
        for (String commentId : commentIds.subList(0, baseIndex)) {
            ExoSocialActivity comment = this.getActivity(commentId);
            if (comment.isHidden()) continue;
            activities.add(this.getStorage().getActivity(commentId));
        }
        return activities;
    }

    @Override
    public int getNumberOfOlderComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment) {
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        List<String> commentIds = Arrays.asList(this.getStorage().getActivity(existingActivity.getId()).getReplyToId());
        int baseIndex = commentIds.indexOf(baseComment.getId());
        for (String commentId : commentIds.subList(baseIndex + 1, commentIds.size())) {
            ExoSocialActivity comment = this.getActivity(commentId);
            if (comment.isHidden()) continue;
            activities.add(this.getStorage().getActivity(commentId));
        }
        return activities.size();
    }

    @Override
    public List<ExoSocialActivity> getOlderComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment, int limit) {
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        List<String> commentIds = Arrays.asList(this.getStorage().getActivity(existingActivity.getId()).getReplyToId());
        int baseIndex = commentIds.indexOf(baseComment.getId());
        for (String commentId : commentIds.subList(baseIndex + 1, limit)) {
            ExoSocialActivity comment = this.getActivity(commentId);
            if (comment.isHidden()) continue;
            activities.add(this.getStorage().getActivity(commentId));
        }
        return activities;
    }

    @Override
    public SortedSet<ActivityProcessor> getActivityProcessors() {
        return this.activityProcessors;
    }

    @Override
    public void updateActivity(ExoSocialActivity changedActivity) throws ActivityStorageException {
        try {
            ActivityEntity activityEntity = this._findById(ActivityEntity.class, changedActivity.getId());
            if (changedActivity.getTitle() == null) {
                changedActivity.setTitle(activityEntity.getTitle());
            }
            if (changedActivity.getBody() == null) {
                changedActivity.setBody(activityEntity.getBody());
            }
            this._saveActivity(changedActivity);
            this.getSession().save();
        }
        catch (NodeNotFoundException e) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_SAVE_ACTIVITY, e.getMessage());
        }
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfIdentities(ActivityBuilderWhere where, ActivityFilter filter, long offset, long limit) throws ActivityStorageException {
        QueryResult results = this.getActivitiesOfIdentitiesQuery(where, filter).objects(Long.valueOf(offset), Long.valueOf(limit));
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        while (results.hasNext()) {
            activities.add(this.getStorage().getActivity(((ActivityEntity)results.next()).getId()));
        }
        return activities;
    }

    private Query<ActivityEntity> getActivitiesOfIdentitiesQuery(ActivityBuilderWhere whereBuilder, JCRFilterLiteral filter) throws ActivityStorageException {
        QueryBuilder builder = this.getSession().createQueryBuilder(ActivityEntity.class);
        builder.where(whereBuilder.build(filter));
        whereBuilder.orderBy((QueryBuilder<ActivityEntity>)builder, filter);
        return builder.get();
    }

    public void setStorage(ActivityStorage storage) {
        this.activityStorage = storage;
    }

    private String[] processMentions(String[] mentionerIds, String title, boolean isAdded) {
        if (title == null || title.length() == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Matcher matcher = MENTION_PATTERN.matcher(title);
        while (matcher.find()) {
            Identity identity;
            String remoteId = matcher.group().substring(1);
            if (!USER_NAME_VALIDATOR_REGEX.matcher(remoteId).matches() || (identity = this.identityStorage.findIdentity("organization", remoteId)) == null) continue;
            String mentionStr = identity.getId() + "@";
            mentionerIds = isAdded ? this.add(mentionerIds, mentionStr) : this.remove(mentionerIds, mentionStr);
        }
        return mentionerIds;
    }

    private String[] processCommenters(String[] commenters, String commenter, boolean isAdded) {
        if (commenter == null || commenter.length() == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        commenter = commenter + "@";
        commenters = isAdded ? this.add(commenters, commenter) : this.remove(commenters, commenter);
        return commenters;
    }

    private String[] add(String[] mentionerIds, String mentionStr) {
        if (ArrayUtils.toString((Object)mentionerIds).indexOf(mentionStr) == -1) {
            return (String[])ArrayUtils.add((Object[])mentionerIds, (Object)(mentionStr + 1));
        }
        String storedId = null;
        for (String mentionerId : mentionerIds) {
            if (mentionerId.indexOf(mentionStr) == -1) continue;
            mentionerIds = (String[])ArrayUtils.removeElement((Object[])mentionerIds, (Object)mentionerId);
            storedId = mentionStr + (Integer.parseInt(mentionerId.split("@")[1]) + 1);
            break;
        }
        mentionerIds = (String[])ArrayUtils.add((Object[])mentionerIds, storedId);
        return mentionerIds;
    }

    private String[] remove(String[] mentionerIds, String mentionStr) {
        for (String mentionerId : mentionerIds) {
            if (mentionerId.indexOf(mentionStr) == -1) continue;
            int numStored = Integer.parseInt(mentionerId.split("@")[1]) - 1;
            if (numStored == 0) {
                return (String[])ArrayUtils.removeElement((Object[])mentionerIds, (Object)mentionerId);
            }
            mentionerIds = (String[])ArrayUtils.removeElement((Object[])mentionerIds, (Object)mentionerId);
            mentionerIds = (String[])ArrayUtils.add((Object[])mentionerIds, (Object)(mentionStr + numStored));
            break;
        }
        return mentionerIds;
    }

    @Override
    public int getNumberOfSpaceActivities(Identity spaceIdentity) {
        if (spaceIdentity == null) {
            return 0;
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_SPACE_FILTER;
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.space().owners(spaceIdentity), filter).objects().size();
    }

    @Override
    public List<ExoSocialActivity> getSpaceActivities(Identity spaceIdentity, int index, int limit) {
        if (spaceIdentity == null) {
            return Collections.emptyList();
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_SPACE_FILTER;
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.space().owners(spaceIdentity), filter, 0L, (long)limit);
    }

    @Override
    public List<ExoSocialActivity> getNewerOnSpaceActivities(Identity spaceIdentity, ExoSocialActivity baseActivity, int limit) {
        if (spaceIdentity == null) {
            return Collections.emptyList();
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_SPACE_NEWER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.space().owners(spaceIdentity), filter, 0L, (long)limit);
    }

    @Override
    public int getNumberOfNewerOnSpaceActivities(Identity spaceIdentity, ExoSocialActivity baseActivity) {
        if (spaceIdentity == null) {
            return 0;
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_SPACE_NEWER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.space().owners(spaceIdentity), filter).objects().size();
    }

    @Override
    public List<ExoSocialActivity> getOlderOnSpaceActivities(Identity spaceIdentity, ExoSocialActivity baseActivity, int limit) {
        List<Identity> spaceList = this.getSpacesId(spaceIdentity);
        if (spaceList.size() == 0) {
            return Collections.emptyList();
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_SPACE_OLDER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.OLDER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.space().owners(spaceList), filter, 0L, (long)limit);
    }

    @Override
    public int getNumberOfOlderOnSpaceActivities(Identity spaceIdentity, ExoSocialActivity baseActivity) {
        if (spaceIdentity == null) {
            return 0;
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_SPACE_OLDER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.OLDER.from(baseActivity.getUpdated().getTime()));
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.space().owners(spaceIdentity), filter).objects().size();
    }

    @Override
    public int getNumberOfNewerOnSpaceActivities(Identity spaceIdentity, Long sinceTime) {
        if (spaceIdentity == null) {
            return 0;
        }
        ActivityFilter filter = ActivityFilter.ACTIVITY_SPACE_NEWER_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(sinceTime));
        return this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.space().owners(spaceIdentity), filter).objects().size();
    }

    @Override
    public int getNumberOfMultiUpdated(Identity owner, Map<String, Long> sinceTimes) {
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        ArrayList<String> activityIds = new ArrayList<String>();
        if (sinceTimes.get("CONNECTIONS") != null) {
            List<ExoSocialActivity> connectionsActivities = this.getActivitiesOfConnections(owner, sinceTimes.get("CONNECTIONS"));
            activities.addAll(connectionsActivities);
            for (ExoSocialActivity connectionsActivity : connectionsActivities) {
                activityIds.add(connectionsActivity.getId());
            }
        }
        if (sinceTimes.get("MY_SPACE") != null) {
            List<ExoSocialActivity> mySpaceActivities = this.getUserSpacesActivities(owner, sinceTimes.get("MY_SPACE"));
            for (ExoSocialActivity mySpaceActivity : mySpaceActivities) {
                if (activityIds.contains(mySpaceActivity.getId())) continue;
                activities.add(mySpaceActivity);
                activityIds.add(mySpaceActivity.getId());
            }
        }
        if (sinceTimes.get("MY_ACTIVITIES") != null) {
            List<ExoSocialActivity> myActivities = this.getUserActivities(owner, sinceTimes.get("MY_ACTIVITIES"));
            for (ExoSocialActivity myActivity : myActivities) {
                if (activityIds.contains(myActivity.getId())) continue;
                activities.add(myActivity);
                activityIds.add(myActivity.getId());
            }
        }
        return activities.size();
    }

    @Override
    public List<ExoSocialActivity> getFeedActivities(Identity owner, Long sinceTime) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.addAll(this.relationshipStorage.getConnections(owner));
        identities.addAll(this.getSpacesId(owner));
        if (identities.size() == 0) {
            return Collections.emptyList();
        }
        JCRFilterLiteral filter = ActivityFilter.ACTIVITY_NEW_UPDATED_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(sinceTime));
        return this.getActivitiesFromQueryResults((QueryResult<ActivityEntity>)this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.updated().owners(identities), filter).objects());
    }

    @Override
    public List<ExoSocialActivity> getUserActivities(Identity owner, Long sinceTime) {
        JCRFilterLiteral filter = ActivityFilter.ACTIVITY_NEW_UPDATED_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(sinceTime));
        return this.getActivitiesFromQueryResults((QueryResult<ActivityEntity>)this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.updated().mentioner(owner), filter).objects(Long.valueOf(0L), Long.valueOf(100L)));
    }

    @Override
    public List<ExoSocialActivity> getUserSpacesActivities(Identity owner, Long sinceTime) {
        List<Identity> spaceList = this.getSpacesId(owner);
        if (spaceList.size() == 0) {
            return new ArrayList<ExoSocialActivity>();
        }
        JCRFilterLiteral filter = ActivityFilter.ACTIVITY_NEW_UPDATED_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(sinceTime));
        return this.getActivitiesFromQueryResults((QueryResult<ActivityEntity>)this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.updated().owners(spaceList), filter).objects(Long.valueOf(0L), Long.valueOf(100L)));
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfConnections(Identity owner, Long sinceTime) {
        List<Identity> connectionList = this.relationshipStorage.getConnections(owner);
        if (connectionList.size() == 0) {
            return new ArrayList<ExoSocialActivity>();
        }
        JCRFilterLiteral filter = ActivityFilter.ACTIVITY_NEW_UPDATED_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(sinceTime));
        return this.getActivitiesFromQueryResults((QueryResult<ActivityEntity>)this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.updated().owners(connectionList), filter).objects(Long.valueOf(0L), Long.valueOf(100L)));
    }

    @Override
    public List<ExoSocialActivity> getSpaceActivities(Identity owner, Long sinceTime) {
        JCRFilterLiteral filter = ActivityFilter.ACTIVITY_NEW_UPDATED_FILTER;
        filter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(sinceTime));
        return this.getActivitiesFromQueryResults((QueryResult<ActivityEntity>)this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.updated().owners(owner), filter).objects());
    }

    private List<ExoSocialActivity> getActivitiesFromQueryResults(QueryResult<ActivityEntity> results) {
        ArrayList<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>();
        while (results.hasNext()) {
            activities.add(this.getStorage().getActivity(((ActivityEntity)results.next()).getId()));
        }
        return activities;
    }

    @Override
    public int getNumberOfUpdatedOnActivityFeed(Identity owner, ActivityUpdateFilter filter) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        List<Identity> relationships = this.relationshipStorage.getConnections(owner);
        identities.addAll(relationships);
        identities.addAll(this.getSpacesId(owner));
        if (identities.size() == 0) {
            return 0;
        }
        String[] excludedSpaceActivities = this.getNumberOfViewedOfActivities(owner, filter.spaceActivitiesType());
        filter.addExcludedActivities(excludedSpaceActivities);
        String[] excludedUserSpaceActivities = this.getNumberOfViewedOfActivities(owner, filter.userSpaceActivitiesType());
        filter.addExcludedActivities(excludedUserSpaceActivities);
        String[] excludedConnections = this.getNumberOfViewedOfActivities(owner, filter.connectionType());
        filter.addExcludedActivities(excludedConnections);
        String[] excludedUserActivities = this.getNumberOfViewedOfActivities(owner, filter.userActivitiesType());
        filter.addExcludedActivities(excludedUserActivities);
        long compareTime = filter.activityFeedType().toSinceTime();
        JCRFilterLiteral jcrfilter = ActivityFilter.ACTIVITY_NEW_UPDATED_FILTER;
        jcrfilter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(compareTime));
        Query<ActivityEntity> query = this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.updated().owners(identities).mentioner(owner).posters(relationships).excludedActivities(filter.excludedActivities()), jcrfilter);
        int gotNumber = this.counter(query);
        if (filter.isRefreshTab() && (long)gotNumber == filter.activityFeedType().lastNumberOfUpdated()) {
            gotNumber = 0;
        }
        return gotNumber;
    }

    private int counter(Query<ActivityEntity> query) {
        QueryResult results = query.objects();
        ActivityEntity entity = null;
        ActivityCounter counter = new ActivityCounter();
        while (results.hasNext()) {
            entity = (ActivityEntity)results.next();
            if (entity.isComment().booleanValue()) {
                entity = entity.getParentActivity();
            }
            counter.add(this.getStorage().getActivity(entity.getId()));
        }
        return counter.size();
    }

    @Override
    public int getNumberOfUpdatedOnUserActivities(Identity owner, ActivityUpdateFilter filter) {
        List<Identity> relationships = this.relationshipStorage.getConnections(owner);
        String[] excludedSpaceActivities = this.getNumberOfViewedOfActivities(owner, filter.spaceActivitiesType());
        filter.addExcludedActivities(excludedSpaceActivities);
        String[] excludedUserSpaceActivities = this.getNumberOfViewedOfActivities(owner, filter.userSpaceActivitiesType());
        filter.addExcludedActivities(excludedUserSpaceActivities);
        String[] excludedConnections = this.getNumberOfViewedOfActivities(owner, filter.connectionType());
        filter.addExcludedActivities(excludedConnections);
        long compareTime = filter.userActivitiesType().toSinceTime();
        JCRFilterLiteral jcrfilter = ActivityFilter.ACTIVITY_NEW_UPDATED_FILTER;
        jcrfilter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(compareTime));
        Query<ActivityEntity> query = this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.updated().mentioner(owner).posters(relationships).excludedActivities(filter.excludedActivities()), jcrfilter);
        int gotNumber = this.counter(query);
        if (filter.isRefreshTab() && (long)gotNumber == filter.userActivitiesType().lastNumberOfUpdated()) {
            gotNumber = 0;
        }
        return gotNumber;
    }

    @Override
    public int getNumberOfUpdatedOnUserSpacesActivities(Identity owner, ActivityUpdateFilter filter) {
        List<Identity> spaceList = this.getSpacesId(owner);
        if (spaceList.size() == 0) {
            return 0;
        }
        String[] excludedSpaceActivities = this.getNumberOfViewedOfActivities(owner, filter.spaceActivitiesType());
        filter.addExcludedActivities(excludedSpaceActivities);
        String[] excludedUserActivities = this.getNumberOfViewedOfActivities(owner, filter.userActivitiesType());
        filter.addExcludedActivities(excludedUserActivities);
        String[] excludedConnections = this.getNumberOfViewedOfActivities(owner, filter.connectionType());
        filter.addExcludedActivities(excludedConnections);
        long compareTime = filter.userSpaceActivitiesType().toSinceTime();
        JCRFilterLiteral jcrfilter = ActivityFilter.ACTIVITY_NEW_UPDATED_FILTER;
        jcrfilter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(compareTime));
        int gotNumber = this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.updated().owners(spaceList).excludedActivities(filter.excludedActivities()), jcrfilter).objects().size();
        if (filter.isRefreshTab() && (long)gotNumber == filter.userSpaceActivitiesType().lastNumberOfUpdated()) {
            gotNumber = 0;
        }
        return gotNumber;
    }

    @Override
    public int getNumberOfUpdatedOnActivitiesOfConnections(Identity owner, ActivityUpdateFilter filter) {
        List<Identity> relationships = this.relationshipStorage.getConnections(owner);
        if (relationships.size() == 0) {
            return 0;
        }
        String[] excludedSpaceActivities = this.getNumberOfViewedOfActivities(owner, filter.spaceActivitiesType());
        filter.addExcludedActivities(excludedSpaceActivities);
        String[] excludedUserActivities = this.getNumberOfViewedOfActivities(owner, filter.userActivitiesType());
        filter.addExcludedActivities(excludedUserActivities);
        String[] excludedUserSpaceActivities = this.getNumberOfViewedOfActivities(owner, filter.userSpaceActivitiesType());
        filter.addExcludedActivities(excludedUserSpaceActivities);
        long compareTime = filter.connectionType().toSinceTime();
        JCRFilterLiteral jcrfilter = ActivityFilter.ACTIVITY_NEW_UPDATED_FILTER;
        jcrfilter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(compareTime));
        Query<ActivityEntity> query = this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.updated().owners(relationships).posters(relationships).excludedActivities(filter.excludedActivities()), jcrfilter);
        int gotNumber = this.counter(query);
        if (filter.isRefreshTab() && (long)gotNumber == filter.connectionType().lastNumberOfUpdated()) {
            gotNumber = 0;
        }
        return gotNumber;
    }

    @Override
    public int getNumberOfUpdatedOnSpaceActivities(Identity owner, ActivityUpdateFilter filter) {
        String[] excludedConnections = this.getNumberOfViewedOfActivities(owner, filter.connectionType());
        filter.addExcludedActivities(excludedConnections);
        String[] excludedUserActivities = this.getNumberOfViewedOfActivities(owner, filter.userActivitiesType());
        filter.addExcludedActivities(excludedUserActivities);
        String[] excludedUserSpaceActivities = this.getNumberOfViewedOfActivities(owner, filter.userSpaceActivitiesType());
        filter.addExcludedActivities(excludedUserSpaceActivities);
        long compareTime = filter.spaceActivitiesType().toSinceTime();
        JCRFilterLiteral jcrfilter = ActivityFilter.ACTIVITY_NEW_UPDATED_FILTER;
        jcrfilter.with(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(compareTime));
        int gotNumber = this.getActivitiesOfIdentitiesQuery(ActivityBuilderWhere.updated().owners(owner).excludedActivities(filter.excludedActivities()), jcrfilter).objects().size();
        if (filter.isRefreshTab() && (long)gotNumber == filter.spaceActivitiesType().lastNumberOfUpdated()) {
            gotNumber = 0;
        }
        return gotNumber;
    }

    private String[] getNumberOfViewedOfActivities(Identity owner, ActivityUpdateFilter.ActivityFilterType type) {
        if (type.fromSinceTime() == type.toSinceTime()) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<Identity> identities = new ArrayList<Identity>();
        identities.add(owner);
        ActivityBuilderWhere where = ActivityBuilderWhere.viewedRange();
        switch (type) {
            case CONNECTIONS_ACTIVITIES: {
                identities.addAll(this.relationshipStorage.getConnections(owner));
                break;
            }
            case USER_ACTIVITIES: {
                where.mentioner(owner);
                break;
            }
            case USER_SPACE_ACTIVITIES: {
                identities.addAll(this.getSpacesId(owner));
                break;
            }
        }
        JCRFilterLiteral jcrfilter = ActivityFilter.ACTIVITY_VIEWED_RANGE_FILTER;
        jcrfilter.with(ActivityFilter.ACTIVITY_FROM_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.NEWER.from(type.oldFromSinceTime()));
        jcrfilter.with(ActivityFilter.ACTIVITY_TO_UPDATED_POINT_FIELD).value((Object)ActivityStorage.TimestampType.OLDER.from(type.toSinceTime()));
        QueryResult result = this.getActivitiesOfIdentitiesQuery(where.owners(identities), jcrfilter).objects();
        Object[] excludedActivities = new String[]{};
        while (result.hasNext()) {
            excludedActivities = (String[])ArrayUtils.add((Object[])excludedActivities, (Object)((ActivityEntity)result.next()).getId());
        }
        return excludedActivities;
    }

    @Override
    public List<ExoSocialActivity> getActivities(Identity owner, Identity viewer, long offset, long limit) throws ActivityStorageException {
        ArrayList<Identity> queryIdentities = new ArrayList<Identity>();
        queryIdentities.add(owner);
        if (viewer != null && !owner.getId().equals(viewer.getId())) {
            Relationship rel = this.relationshipStorage.getRelationship(owner, viewer);
            boolean hasRelationship = false;
            if (rel != null && rel.getStatus() == Relationship.Type.CONFIRMED) {
                hasRelationship = true;
            }
            if (hasRelationship) {
                queryIdentities.add(viewer);
            }
        }
        List<Identity> spaceIdentityOfOwner = this.getSpacesId(owner);
        Map<String, Identity> spaceIdentityOfViewer = this.getSpacesIdOfIdentity(viewer);
        for (Identity identity : spaceIdentityOfOwner) {
            if (!spaceIdentityOfViewer.containsKey(identity.getRemoteId())) continue;
            queryIdentities.add(identity);
        }
        ActivityFilter filter = new ActivityFilter(){};
        return this.getOwnerActivitiesOfIdentities(ActivityBuilderWhere.owner().owners(queryIdentities).mentioner(owner).poster(owner), filter, offset, limit);
    }

    public List<ExoSocialActivity> getOwnerActivitiesOfIdentities(ActivityBuilderWhere where, ActivityFilter filter, long offset, long limit) throws ActivityStorageException {
        Query<ActivityEntity> query = this.getActivitiesOfIdentitiesQuery(where, filter);
        QueryResult results = query.objects();
        ActivityEntity entity = null;
        long totalSize = results.size();
        ActivityIterator activityIt = new ActivityIterator(offset, limit, totalSize);
        while (results.hasNext()) {
            entity = (ActivityEntity)results.next();
            if (entity.isComment().booleanValue()) {
                entity = entity.getParentActivity();
            }
            activityIt.add(this.getStorage().getActivity(entity.getId()));
            if (activityIt.addMore()) continue;
            break;
        }
        return activityIt.result();
    }
}

