/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.listener.post;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;

public class PostCreateContentEventListener
extends Listener<CmsService, Node> {
    private static final Log LOG = ExoLogger.getLogger((String)PostCreateContentEventListener.class.getName());
    public static final String POST_INIT_STATE_EVENT = "PublicationService.event.postInitState";
    private WCMPublicationService publicationService;
    private WCMConfigurationService configurationService;
    private WebContentSchemaHandler webContentSchemaHandler;
    private ListenerService listenerService = null;
    private ActivityCommonService activityService;

    public PostCreateContentEventListener(WCMPublicationService publicationService, WCMConfigurationService configurationService, WebSchemaConfigService schemaConfigService) {
        this.publicationService = publicationService;
        this.configurationService = configurationService;
        this.webContentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
        this.activityService = (ActivityCommonService)WCMCoreUtils.getService(ActivityCommonService.class);
    }

    public void onEvent(Event<CmsService, Node> event) throws Exception {
        String remoteUser;
        String siteName;
        Node currentNode;
        block16: {
            if (this.listenerService == null) {
                this.listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
            }
            if ((currentNode = (Node)event.getData()).canAddMixin("exo:rss-enable")) {
                currentNode.addMixin("exo:rss-enable");
            }
            if (currentNode.isNodeType("exo:rss-enable") && !currentNode.hasProperty("exo:title") || currentNode.hasProperty("exo:title") && StringUtils.isEmpty((String)currentNode.getProperty("exo:title").getString())) {
                currentNode.setProperty("exo:title", Text.unescapeIllegalJcrChars((String)currentNode.getName()));
            }
            if (currentNode.isNodeType("exo:cssFile") || currentNode.isNodeType("exo:jsFile") || currentNode.getParent().isNodeType("exo:actionStorage")) {
                if (currentNode.isNodeType("exo:cssFile") || currentNode.isNodeType("exo:jsFile")) {
                    CmsService cmsService = (CmsService)WCMCoreUtils.getService(CmsService.class);
                    this.listenerService.broadcast(POST_INIT_STATE_EVENT, (Object)cmsService, (Object)currentNode);
                }
                return;
            }
            Session session = currentNode.getSession();
            String nodePath = currentNode.getPath();
            currentNode.getSession().save();
            currentNode = (Node)session.getItem(nodePath);
            if (currentNode instanceof NodeImpl && !((NodeImpl)currentNode).isValid()) {
                currentNode = (Node)session.getItem(nodePath);
                LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
                if (linkManager.isLink((Item)currentNode)) {
                    try {
                        currentNode = linkManager.getTarget(currentNode, false);
                    }
                    catch (Exception ex) {
                        currentNode = linkManager.getTarget(currentNode, true);
                    }
                }
            }
            siteName = null;
            remoteUser = null;
            try {
                siteName = Util.getPortalRequestContext().getPortalOwner();
                remoteUser = Util.getPortalRequestContext().getRemoteUser();
            }
            catch (NullPointerException npe) {
                if (!LOG.isDebugEnabled()) break block16;
                LOG.debug((Object)"No portal context available");
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(currentNode.getPath() + "::" + siteName + "::" + remoteUser));
        }
        if (remoteUser != null) {
            this.publicationService.updateLifecyleOnChangeContent(currentNode, siteName, remoteUser);
            if (this.activityService.isAcceptedNode(currentNode)) {
                this.listenerService.broadcast(ActivityCommonService.NODE_CREATED_ACTIVITY, null, (Object)currentNode);
            } else if (currentNode.getPrimaryNodeType().getName().equals("nt:file")) {
                this.listenerService.broadcast(ActivityCommonService.FILE_CREATED_ACTIVITY, null, (Object)currentNode);
            }
        }
    }
}

