/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.operations;

import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.management.operations.Utils;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.exceptions.OperationException;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.api.operation.OperationHandler;
import org.gatein.management.api.operation.ResultHandler;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;

public abstract class AbstractMopOperationHandler
implements OperationHandler {
    public final void execute(OperationContext operationContext, ResultHandler resultHandler) throws ResourceNotFoundException, OperationException {
        String operationName = operationContext.getOperationName();
        PathAddress address = operationContext.getAddress();
        String siteType = address.resolvePathTemplate("site-type");
        if (siteType == null) {
            throw new OperationException(operationName, "Site type was not specified.");
        }
        ObjectType<Site> objectType = Utils.getObjectType(Utils.getSiteType(siteType));
        if (objectType == null) {
            throw new ResourceNotFoundException("No site type found for " + siteType);
        }
        POMSessionManager mgr = (POMSessionManager)operationContext.getRuntimeContext().getRuntimeComponent(POMSessionManager.class);
        POMSession session = mgr.getSession();
        if (session == null) {
            throw new OperationException(operationName, "MOP session was null");
        }
        Workspace workspace = session.getWorkspace();
        if (workspace == null) {
            throw new OperationException(operationName, "MOP workspace was null");
        }
        this.execute(operationContext, resultHandler, workspace, objectType);
    }

    protected abstract void execute(OperationContext var1, ResultHandler var2, Workspace var3, ObjectType<Site> var4) throws ResourceNotFoundException, OperationException;

    protected SiteType getSiteType(ObjectType<? extends Site> objectType) {
        return Utils.getSiteType(objectType);
    }

    protected SiteKey getSiteKey(ObjectType<? extends Site> objectType, String name) {
        return Utils.siteKey(Utils.getSiteType(objectType), name);
    }

    protected SiteKey getSiteKey(Site site) {
        return this.getSiteKey((ObjectType<? extends Site>)site.getObjectType(), site.getName());
    }
}

