/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.web.redirect;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.application.PortalRequestHandler;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.url.PortalURLContext;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.URLFactoryService;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.web.redirect.RedirectCookieService;
import org.gatein.web.redirect.api.RedirectKey;
import org.gatein.web.redirect.api.RedirectType;
import org.gatein.web.redirect.api.SiteRedirectService;
import org.picocontainer.Startable;

public class RedirectRequestHandler
extends WebRequestHandler
implements Startable {
    protected static Logger log = LoggerFactory.getLogger(RedirectRequestHandler.class);
    public static final String HANDLER_NAME = "siteRedirect";
    protected String browserDetectionPath;
    protected SiteRedirectService deviceRedirectionService;
    protected URLFactoryService urlFactory;
    public static final String DEVICE_DETECTION_ATTEMPTED = "gtn.device.detectionAttempted";
    public static final String INITIAL_URI = "gtn.redirect.initialURI";
    public static final String REDIRECT_FLAG = "gtn_redirect";

    public RedirectRequestHandler(InitParams params, SiteRedirectService service, URLFactoryService urlFactory) {
        this.deviceRedirectionService = service;
        this.urlFactory = urlFactory;
        ValueParam browserDectionectUrl = params.getValueParam("browser.detection.path");
        if (browserDectionectUrl != null) {
            this.browserDetectionPath = browserDectionectUrl.getValue();
        }
    }

    public String getHandlerName() {
        return HANDLER_NAME;
    }

    public boolean execute(ControllerContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        String originRequestPath = context.getParameter(PortalRequestHandler.REQUEST_PATH);
        SiteKey originSite = this.getOriginSiteKey(context);
        if (originRequestPath != null && originRequestPath.equalsIgnoreCase("null")) {
            originRequestPath = null;
        }
        log.debug((Object)("Site Redirect being checked on [" + originSite.getName() + "], with type [" + originSite.getTypeName() + "], and request path [" + originRequestPath + "]"));
        String redirectFlagValue = request.getParameter(REDIRECT_FLAG);
        if (redirectFlagValue != null && !redirectFlagValue.isEmpty()) {
            SiteKey redirectSiteKey = new SiteKey(originSite.getType(), redirectFlagValue);
            RedirectKey redirectKey = RedirectKey.redirect(redirectSiteKey.getName());
            return this.performRedirect(originSite, redirectKey, originRequestPath, context, true);
        }
        String referer = request.getHeader("Referer");
        String siteURL = request.getRequestURL().substring(0, request.getRequestURL().length() - request.getServletPath().length());
        if (referer != null && referer.startsWith(siteURL) && context.getRequest().getSession(true).getAttribute(DEVICE_DETECTION_ATTEMPTED) == null) {
            return false;
        }
        RedirectKey redirectSite = this.getRedirect(originSite, request, context);
        if (redirectSite != null) {
            return this.performRedirect(originSite, redirectSite, originRequestPath, context, false);
        }
        Map<String, String> deviceProperties = null;
        String userAgentString = request.getHeader("User-Agent");
        log.debug((Object)("Found user-agent string : " + userAgentString));
        Object attemptedDeviceDetection = context.getRequest().getSession(true).getAttribute(DEVICE_DETECTION_ATTEMPTED);
        if (attemptedDeviceDetection != null) {
            deviceProperties = this.getDeviceProperties(request);
            context.getRequest().getSession().removeAttribute(DEVICE_DETECTION_ATTEMPTED);
            log.debug((Object)("Found device properties : " + deviceProperties));
        }
        if ((redirectSite = this.deviceRedirectionService.getRedirectSite(originSite.getName(), userAgentString, deviceProperties)) == null || redirectSite.getType() == RedirectType.NOREDIRECT) {
            log.debug((Object)"Redirect returned is null or NO_REDIRECT_DETECTED. Setting NO_REDIRECT for this user");
            this.setRedirect(originSite, RedirectKey.noRedirect(), request, response, context);
            return false;
        }
        if (redirectSite.getType() == RedirectType.NEEDDEVICEINFO) {
            if (attemptedDeviceDetection == null) {
                log.debug((Object)("Need browser properties detection. Redirecting to BrowserDetectionPage : " + this.browserDetectionPath));
                request.getSession().setAttribute(DEVICE_DETECTION_ATTEMPTED, (Object)true);
                this.performRedirectToDeviceDetector(request, response);
                return true;
            }
            log.warn((Object)"DeviceDetectionService retruned NEED_BROWSER_DETECTION but the browser has already attempted dection. Setting no redirect.");
            this.setRedirect(originSite, RedirectKey.noRedirect(), request, response, context);
            return false;
        }
        log.debug((Object)("Redirect for origin site " + originSite.getName() + " is being set to : " + redirectSite));
        return this.performRedirect(originSite, redirectSite, originRequestPath, context, false);
    }

    protected RedirectKey getRedirect(SiteKey origin, HttpServletRequest request, ControllerContext context) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RedirectCookieService redirectCookieService = (RedirectCookieService)container.getComponentInstanceOfType(RedirectCookieService.class);
        return redirectCookieService.getRedirect(origin, request);
    }

    protected void setRedirect(SiteKey origin, RedirectKey redirect, HttpServletRequest request, HttpServletResponse response, ControllerContext context) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RedirectCookieService redirectCookieService = (RedirectCookieService)container.getComponentInstanceOfType(RedirectCookieService.class);
        PortalURLContext urlContext = new PortalURLContext(context, SiteKey.portal((String)origin.getName()));
        NodeURL url = (NodeURL)this.urlFactory.newURL(NodeURL.TYPE, (URLContext)urlContext);
        String path = url.setResource(new NavigationResource(SiteType.PORTAL, origin.getName(), "")).toString();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        Cookie redirectCookie = redirectCookieService.createCookie(origin.getName(), redirect, path);
        response.addCookie(redirectCookie);
        if (redirect.getType() != RedirectType.NOREDIRECT && redirect.getRedirect() != null) {
            String redirectPath = url.setResource(new NavigationResource(SiteType.PORTAL, redirect.getRedirect(), "")).toString();
            if (redirectPath.endsWith("/")) {
                redirectPath = redirectPath.substring(0, redirectPath.length() - 1);
            }
            Cookie removeRedirectCookie = redirectCookieService.createCookie(redirect.getRedirect(), RedirectKey.noRedirect(), redirectPath);
            response.addCookie(removeRedirectCookie);
        }
    }

    protected Map<String, String> getDeviceProperties(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        if (parameterMap != null) {
            HashMap<String, String> deviceProperties = new HashMap<String, String>();
            for (String key : parameterMap.keySet()) {
                if (!key.startsWith("gtn.device.")) continue;
                deviceProperties.put(key.substring("gtn.device.".length()), request.getParameter(key));
            }
            return deviceProperties;
        }
        return null;
    }

    protected boolean performRedirect(SiteKey origin, RedirectKey redirect, String requestPath, ControllerContext context, boolean forceRedirect) throws IOException {
        if (redirect.getType() == RedirectType.NOREDIRECT) {
            log.debug((Object)("Using NoRedirect for site " + redirect + " with request path :" + requestPath));
            return false;
        }
        log.debug((Object)("Attempting redirect to site " + redirect + " with request path :" + requestPath));
        String redirectLocation = this.deviceRedirectionService.getRedirectPath(origin.getName(), redirect.getRedirect(), requestPath);
        if (forceRedirect && redirectLocation == null) {
            redirectLocation = requestPath;
        }
        if (redirectLocation != null) {
            log.debug((Object)("RedirectPath set to : " + redirectLocation));
            this.setRedirect(origin, redirect, context.getRequest(), context.getResponse(), context);
            SiteKey siteKey = new SiteKey(SiteType.PORTAL, redirect.getRedirect());
            PortalURLContext urlContext = new PortalURLContext(context, siteKey);
            NodeURL url = (NodeURL)this.urlFactory.newURL(NodeURL.TYPE, (URLContext)urlContext);
            String s = url.setResource(new NavigationResource(SiteType.PORTAL, redirect.getRedirect(), redirectLocation)).toString();
            HttpServletResponse response = context.getResponse();
            HttpServletRequest request = context.getRequest();
            String queryString = request.getQueryString();
            if (request.getQueryString() != null) {
                if (queryString.contains("gtn_redirect=")) {
                    queryString = queryString.substring(0, queryString.lastIndexOf(REDIRECT_FLAG));
                }
                if (s.endsWith("/")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (queryString != null && !queryString.isEmpty()) {
                    s = s + "?" + queryString;
                }
            }
            response.sendRedirect(response.encodeRedirectURL(s));
            return true;
        }
        log.debug((Object)("Did not get a node match for redirecting to site [" + redirect + "] with requestPath [" + requestPath + "]. Cannot perform redirect."));
        return false;
    }

    protected void performRedirectToDeviceDetector(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String initialURI = request.getRequestURI();
        if (request.getQueryString() != null) {
            if (initialURI.endsWith("/")) {
                initialURI = initialURI.substring(0, initialURI.length() - 1);
            }
            initialURI = initialURI + "?" + request.getQueryString();
        }
        request.getSession().setAttribute(INITIAL_URI, (Object)initialURI);
        request.setAttribute(INITIAL_URI, (Object)initialURI);
        request.getRequestDispatcher(this.browserDetectionPath).forward((ServletRequest)request, (ServletResponse)response);
    }

    protected SiteKey getOriginSiteKey(ControllerContext context) {
        String originSiteName = context.getParameter(PortalRequestHandler.REQUEST_SITE_NAME);
        String originSiteTypeString = context.getParameter(PortalRequestHandler.REQUEST_SITE_TYPE);
        SiteType originSiteType = originSiteTypeString.equals(SiteType.GROUP.getName()) ? SiteType.GROUP : (originSiteTypeString.equals(SiteType.USER.getName()) ? SiteType.USER : SiteType.PORTAL);
        return new SiteKey(originSiteType, originSiteName);
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    public void start() {
    }

    public void stop() {
    }
}

