/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.GadgetSpec;

public class ContentRewriterFeature {
    protected static final String INCLUDE_URLS = "include-urls";
    protected static final String EXCLUDE_URLS = "exclude-urls";
    protected static final String INCLUDE_URL = "include-url";
    protected static final String EXCLUDE_URL = "exclude-url";
    protected static final String INCLUDE_TAGS = "include-tags";
    protected static final String EXPIRES = "expires";
    public static final Integer EXPIRES_DEFAULT = -1;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Config {
        private final MatchBundle includes;
        private final MatchBundle excludes;
        private final Set<String> includeTags;
        private final Integer expires;
        private final boolean onlyAllowExcludes;
        private final boolean enableSplitJs;
        private Integer fingerprint;
        private static final Pattern COMMA_WHITESPACE_PATTERN = Pattern.compile("\\s*,\\s*");

        Config(String defaultInclude, String defaultExclude, String defaultExpires, String defaultTags, boolean onlyAllowExcludes, boolean enableSplitJs) {
            this.includes = this.getMatchBundle(this.paramTrim(defaultInclude), Collections.<String>emptyList());
            this.excludes = this.getMatchBundle(this.paramTrim(defaultExclude), Collections.<String>emptyList());
            ImmutableSet.Builder includeTagsBuilder = ImmutableSet.builder();
            for (String s : COMMA_WHITESPACE_PATTERN.split(this.paramTrim(defaultTags).toLowerCase())) {
                if (s == null || s.length() <= 0) continue;
                includeTagsBuilder.add((Object)s);
            }
            this.includeTags = includeTagsBuilder.build();
            int expiresVal = EXPIRES_DEFAULT;
            try {
                expiresVal = Integer.parseInt(this.paramTrim(defaultExpires));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.expires = expiresVal;
            this.onlyAllowExcludes = onlyAllowExcludes;
            this.enableSplitJs = enableSplitJs;
        }

        Config(GadgetSpec spec, Config defaultConfig) {
            int expiresVal;
            block13: {
                this.onlyAllowExcludes = defaultConfig.onlyAllowExcludes;
                Feature f = spec.getModulePrefs().getFeatures().get("content-rewrite");
                String includeRegex = defaultConfig.includes.param;
                ArrayList includeUrls = Lists.newArrayList();
                if (f != null && !this.onlyAllowExcludes) {
                    if (f.getParams().containsKey((Object)ContentRewriterFeature.INCLUDE_URLS)) {
                        includeRegex = f.getParam(ContentRewriterFeature.INCLUDE_URLS);
                    }
                    Collection<String> paramUrls = f.getParamCollection(ContentRewriterFeature.INCLUDE_URL);
                    for (String url : paramUrls) {
                        includeUrls.add(url.trim().toLowerCase());
                    }
                }
                this.includes = this.getMatchBundle(includeRegex, includeUrls);
                String excludeRegex = defaultConfig.excludes.param;
                ArrayList excludeUrls = Lists.newArrayList();
                if (f != null) {
                    if (f.getParams().containsKey((Object)ContentRewriterFeature.EXCLUDE_URLS)) {
                        excludeRegex = f.getParam(ContentRewriterFeature.EXCLUDE_URLS);
                    }
                    Collection<String> eParamUrls = f.getParamCollection(ContentRewriterFeature.EXCLUDE_URL);
                    for (String url : eParamUrls) {
                        excludeUrls.add(url.trim().toLowerCase());
                    }
                }
                this.excludes = this.getMatchBundle(excludeRegex, excludeUrls);
                Object tagsVal = null;
                if (f != null && f.getParams().containsKey((Object)ContentRewriterFeature.INCLUDE_TAGS)) {
                    tagsVal = Sets.newTreeSet();
                    for (String tag : StringUtils.split((String)f.getParam(ContentRewriterFeature.INCLUDE_TAGS), (char)',')) {
                        if (StringUtils.isEmpty((String)tag)) continue;
                        tagsVal.add(tag.trim().toLowerCase());
                    }
                    if (this.onlyAllowExcludes) {
                        tagsVal.retainAll(defaultConfig.includeTags);
                    }
                } else {
                    tagsVal = ImmutableSortedSet.copyOf(defaultConfig.includeTags);
                }
                this.includeTags = tagsVal;
                expiresVal = defaultConfig.expires;
                if (f != null && f.getParams().containsKey((Object)ContentRewriterFeature.EXPIRES)) {
                    try {
                        int overrideVal = Integer.parseInt(f.getParam(ContentRewriterFeature.EXPIRES));
                        expiresVal = Math.min(overrideVal, expiresVal);
                    }
                    catch (NumberFormatException e) {
                        if (!"HTTP".equalsIgnoreCase(f.getParam(ContentRewriterFeature.EXPIRES).trim())) break block13;
                        expiresVal = EXPIRES_DEFAULT;
                    }
                }
            }
            this.expires = expiresVal;
            this.enableSplitJs = defaultConfig.enableSplitJs;
        }

        private String paramTrim(String param) {
            if (param == null) {
                return param;
            }
            return param.trim();
        }

        private MatchBundle getMatchBundle(String regex, Collection<String> matches) {
            MatchBundle bundle = new MatchBundle();
            bundle.param = regex;
            bundle.matches = matches;
            if (bundle.matches.isEmpty() && StringUtils.isEmpty((String)bundle.param)) {
                bundle.options = PatternOptions.NONE;
            } else if (bundle.matches.size() == 1) {
                String firstVal = (String)bundle.matches.iterator().next();
                if ("*".equals(firstVal)) {
                    bundle.options = PatternOptions.ALL;
                } else if ("".equals(firstVal)) {
                    bundle.options = PatternOptions.NONE;
                } else {
                    bundle.options = PatternOptions.STRINGS;
                }
            } else if (bundle.matches.size() > 1) {
                bundle.options = PatternOptions.STRINGS;
            } else {
                if (".*".equals(bundle.param)) {
                    bundle.options = PatternOptions.ALL;
                } else {
                    bundle.options = PatternOptions.REGEX;
                }
                bundle.pattern = Pattern.compile(bundle.param);
            }
            return bundle;
        }

        protected boolean shouldInclude(String url) {
            return Config.matcherMatches(url, this.includes);
        }

        protected boolean shouldExclude(String url) {
            return Config.matcherMatches(url, this.excludes);
        }

        private static boolean matcherMatches(String url, MatchBundle bundle) {
            switch (bundle.options) {
                case NONE: {
                    return false;
                }
                case ALL: {
                    return true;
                }
                case REGEX: {
                    return bundle.pattern.matcher(url).find();
                }
                case STRINGS: {
                    String urllc = url.toLowerCase();
                    for (String substr : bundle.matches) {
                        if (!urllc.contains(substr)) continue;
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        public boolean isRewriteEnabled() {
            return this.includes.options != PatternOptions.NONE && this.excludes.options != PatternOptions.ALL;
        }

        public boolean shouldRewriteURL(String url) {
            return this.shouldInclude(url) && !this.shouldExclude(url);
        }

        public boolean shouldRewriteTag(String tag) {
            if (tag != null) {
                return this.includeTags.contains(tag.toLowerCase());
            }
            return false;
        }

        public Set<String> getIncludedTags() {
            return this.includeTags;
        }

        public Integer getExpires() {
            return this.expires;
        }

        public boolean isSplitJsEnabled() {
            return this.enableSplitJs;
        }

        public int getFingerprint() {
            if (this.fingerprint == null) {
                int result = this.includes.pattern != null ? this.includes.pattern.pattern().hashCode() : 0;
                for (String s : this.includes.matches) {
                    result = 31 * result + s.hashCode();
                }
                result = 31 * result + (this.excludes.pattern != null ? this.excludes.pattern.pattern().hashCode() : 0);
                for (String s : this.excludes.matches) {
                    result = 31 * result + s.hashCode();
                }
                for (String s : this.includeTags) {
                    result = 31 * result + s.hashCode();
                }
                this.fingerprint = result;
            }
            return this.fingerprint;
        }

        private static class MatchBundle {
            private String param;
            private PatternOptions options;
            private Pattern pattern;
            private Collection<String> matches;

            private MatchBundle() {
            }
        }
    }

    @Singleton
    public static class DefaultConfig
    extends Config {
        @Inject
        public DefaultConfig(@Named(value="shindig.content-rewrite.include-urls") String includeUrls, @Named(value="shindig.content-rewrite.exclude-urls") String excludeUrls, @Named(value="shindig.content-rewrite.expires") String expires, @Named(value="shindig.content-rewrite.include-tags") String includeTags, @Named(value="shindig.content-rewrite.only-allow-excludes") boolean onlyAllowExcludes, @Named(value="shindig.content-rewrite.enable-split-js-concat") boolean enableSplitJsConcat) {
            super(includeUrls, excludeUrls, expires, includeTags, onlyAllowExcludes, enableSplitJsConcat);
        }
    }

    @Singleton
    public static class Factory {
        private final GadgetSpecFactory specFactory;
        private final Config defaultConfig;

        @Inject
        public Factory(GadgetSpecFactory specFactory, DefaultConfig defaultConfig) {
            this.specFactory = specFactory;
            this.defaultConfig = defaultConfig;
        }

        public Config getDefault() {
            return this.defaultConfig;
        }

        public Config get(HttpRequest request) {
            return this.get(request.getGadget());
        }

        public Config get(final Uri gadgetUri) {
            if (gadgetUri != null) {
                try {
                    GadgetContext context = new GadgetContext(){

                        public Uri getUrl() {
                            return gadgetUri;
                        }
                    };
                    GadgetSpec spec = this.specFactory.getGadgetSpec(context);
                    if (spec != null) {
                        return this.get(spec);
                    }
                }
                catch (GadgetException gadgetException) {
                    // empty catch block
                }
            }
            return this.defaultConfig;
        }

        public Config get(GadgetSpec spec) {
            Config rewriterFeature = (Config)spec.getAttribute("content-rewriter");
            if (rewriterFeature != null) {
                return rewriterFeature;
            }
            rewriterFeature = new Config(spec, this.defaultConfig);
            spec.setAttribute("content-rewriter", rewriterFeature);
            return rewriterFeature;
        }

        public Config createRewriteAllFeature(int ttl) {
            return new Config(".*", "", ttl == -1 ? "HTTP" : Integer.toString(ttl), "", false, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PatternOptions {
        ALL,
        NONE,
        REGEX,
        STRINGS;

    }
}

