/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.cluster;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.RPCManager;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.remote.ReplicateCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.factories.annotations.Stop;

public class ReplicationQueue {
    private static final Log log = LogFactory.getLog(ReplicationQueue.class);
    private long max_elements = 500L;
    final List<ReplicableCommand> elements = new LinkedList<ReplicableCommand>();
    private ScheduledExecutorService scheduledExecutor = null;
    private RPCManager rpcManager;
    private Configuration configuration;
    private boolean enabled;
    private CommandsFactory commandsFactory;
    private static final AtomicInteger counter = new AtomicInteger(0);

    public boolean isEnabled() {
        return this.enabled;
    }

    @Inject
    void injectDependencies(RPCManager rpcManager, Configuration configuration, CommandsFactory commandsFactory) {
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.commandsFactory = commandsFactory;
        this.enabled = configuration.isUseReplQueue() && (configuration.getBuddyReplicationConfig() == null || !configuration.getBuddyReplicationConfig().isEnabled());
    }

    @Start
    public synchronized void start() {
        long interval = this.configuration.getReplQueueInterval();
        this.max_elements = this.configuration.getReplQueueMaxElements();
        boolean bl = this.enabled = this.configuration.isUseReplQueue() && (this.configuration.getBuddyReplicationConfig() == null || !this.configuration.getBuddyReplicationConfig().isEnabled());
        if (this.enabled && interval > 0L && this.scheduledExecutor == null) {
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    return new Thread(r, "ReplicationQueue-periodicProcessor-" + counter.getAndIncrement());
                }
            });
            this.scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

                public void run() {
                    ReplicationQueue.this.flush();
                }
            }, 500L, interval, TimeUnit.MILLISECONDS);
        }
    }

    @Stop
    public synchronized void stop() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
        this.scheduledExecutor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ReplicateCommand job) {
        if (job == null) {
            throw new NullPointerException("job is null");
        }
        List<ReplicableCommand> list = this.elements;
        synchronized (list) {
            this.elements.add(job);
            if ((long)this.elements.size() >= this.max_elements) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ArrayList<ReplicableCommand> toReplicate;
        List<ReplicableCommand> list = this.elements;
        synchronized (list) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("flush(): flushing repl queue (num elements=" + this.elements.size() + ")"));
            }
            toReplicate = new ArrayList<ReplicableCommand>(this.elements);
            this.elements.clear();
        }
        if (toReplicate.size() > 0) {
            try {
                ReplicateCommand replicateCommand = this.commandsFactory.buildReplicateCommand(toReplicate);
                this.rpcManager.callRemoteMethods(null, (ReplicableCommand)replicateCommand, false, this.configuration.getSyncReplTimeout(), false);
            }
            catch (Throwable t) {
                log.error((Object)("failed replicating " + toReplicate.size() + " elements in replication queue"), t);
            }
        }
    }
}

