/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.webcontent;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.deployment.DeploymentDescriptor;
import org.exoplatform.services.deployment.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.portal.artifacts.CreatePortalPlugin;

public class InitialWebContentPlugin
extends CreatePortalPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)InitialWebContentPlugin.class.getName());
    private InitParams initParams;
    private ConfigurationManager configurationManager;
    private RepositoryService repositoryService;
    private ExoCache<String, String> artifactsCache;
    private LivePortalManagerService livePortalManagerService;

    public InitialWebContentPlugin(InitParams initParams, ConfigurationManager configurationManager, RepositoryService repositoryService, CacheService cacheService, LivePortalManagerService livePortalManagerService) throws Exception {
        super(initParams, configurationManager, repositoryService);
        this.initParams = initParams;
        this.configurationManager = configurationManager;
        this.repositoryService = repositoryService;
        this.artifactsCache = cacheService.getCacheInstance(((Object)((Object)this)).getClass().getName());
        this.livePortalManagerService = livePortalManagerService;
    }

    @Override
    public void deployToPortal(SessionProvider sessionProvider, String portalName) throws Exception {
        Iterator iterator = this.initParams.getObjectParamIterator();
        DeploymentDescriptor deploymentDescriptor = null;
        try {
            while (iterator.hasNext()) {
                ObjectParameter objectParameter = (ObjectParameter)iterator.next();
                deploymentDescriptor = (DeploymentDescriptor)objectParameter.getObject();
                Boolean cleanupPublication = deploymentDescriptor.getCleanupPublication();
                String sourcePath = deploymentDescriptor.getSourcePath();
                String versionHistoryPath = deploymentDescriptor.getVersionHistoryPath();
                String xmlData = (String)this.artifactsCache.get((Serializable)((Object)sourcePath));
                if (xmlData == null) {
                    InputStream stream = this.configurationManager.getInputStream(sourcePath);
                    xmlData = IOUtil.getStreamContentAsString((InputStream)stream);
                    this.artifactsCache.put((Serializable)((Object)sourcePath), (Object)xmlData);
                }
                ManageableRepository repository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(deploymentDescriptor.getTarget().getWorkspace(), repository);
                String targetPath = deploymentDescriptor.getTarget().getNodePath();
                String realTargetFolder = StringUtils.replace((String)targetPath, (String)"{portalName}", (String)portalName);
                InputStream inputStream = this.configurationManager.getInputStream(sourcePath);
                session.importXML(realTargetFolder, inputStream, 0);
                if (cleanupPublication.booleanValue()) {
                    QueryManager manager = session.getWorkspace().getQueryManager();
                    String statement = "select * from nt:base where jcr:path LIKE '" + realTargetFolder + "/%'";
                    Query query = manager.createQuery(statement.toString(), "sql");
                    NodeIterator iter = query.execute().getNodes();
                    while (iter.hasNext()) {
                        Node node = iter.nextNode();
                        if (!node.hasProperty("publication:liveRevision") || !node.hasProperty("publication:currentState")) continue;
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("\"" + node.getName() + "\" publication lifecycle has been cleaned up"));
                        }
                        node.setProperty("publication:liveRevision", "");
                        node.setProperty("publication:currentState", "published");
                    }
                }
                if (versionHistoryPath != null && versionHistoryPath.length() > 0) {
                    Node currentNode = (Node)session.getItem(deploymentDescriptor.getTarget().getNodePath());
                    Map mapHistoryValue = Utils.getMapImportHistory((InputStream)this.configurationManager.getInputStream(versionHistoryPath));
                    Utils.processImportHistory((Node)currentNode, (InputStream)this.configurationManager.getInputStream(versionHistoryPath), (Map)mapHistoryValue);
                }
                session.save();
            }
            Node portalNode = this.livePortalManagerService.getLivePortal(sessionProvider, portalName);
            this.configure(portalNode, portalName);
            portalNode.getSession().save();
        }
        catch (Exception ex) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("deploy the portal " + portalName + " from " + deploymentDescriptor.getSourcePath() + " into " + StringUtils.replace((String)deploymentDescriptor.getTarget().getNodePath(), (String)"{portalName}", (String)portalName) + " is FAILURE at " + new Date().toString() + "\n"), (Throwable)ex);
            }
            throw ex;
        }
    }

    private void configure(Node targetNode, String portalName) throws Exception {
        String statement = "select * from nt:resource where jcr:path like '" + targetNode.getPath() + "/%' order by jcr:dateModified ASC";
        QueryManager queryManager = targetNode.getSession().getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(statement, "sql");
        NodeIterator iterator = query.execute().getNodes();
        while (iterator.hasNext()) {
            String jcrData;
            Node ntResource = iterator.nextNode();
            String mimeType = ntResource.getProperty("jcr:mimeType").getString();
            if (!mimeType.startsWith("text") || !(jcrData = ntResource.getProperty("jcr:data").getString()).contains("{portalName}")) continue;
            String realData = StringUtils.replace((String)jcrData, (String)"{portalName}", (String)portalName);
            ntResource.setProperty("jcr:data", realData);
        }
    }
}

