/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.webcontent;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.exoplatform.services.deployment.WCMContentInitializerService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class WebcontentChildUpgradeService
implements Startable {
    private RepositoryService repoService_;
    private static final Log LOG = ExoLogger.getLogger((String)WebcontentChildUpgradeService.class.getName());

    public WebcontentChildUpgradeService(RepositoryService repoService, WCMContentInitializerService initService) {
        this.repoService_ = repoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Start " + this.getClass().getName() + "............."));
        }
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            for (WorkspaceEntry wsEntry : WCMCoreUtils.getRepository().getConfiguration().getWorkspaceEntries()) {
                Session session = sessionProvider.getSession(wsEntry.getName(), this.repoService_.getCurrentRepository());
                String statement = "SELECT * FROM exo:webContent order by exo:name";
                Query query = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                NodeIterator iter = query.execute().getNodes();
                while (iter.hasNext()) {
                    Node wc = null;
                    try {
                        wc = iter.nextNode();
                        if (wc.hasNode("default.html/jcr:content") && wc.getNode("default.html/jcr:content").canAddMixin("exo:webContentChild")) {
                            wc.getNode("default.html/jcr:content").addMixin("exo:webContentChild");
                        }
                        if (wc.hasNode("js/default.js/jcr:content") && wc.getNode("js/default.js/jcr:content").canAddMixin("exo:webContentChild")) {
                            wc.getNode("js/default.js/jcr:content").addMixin("exo:webContentChild");
                        }
                        if (wc.hasNode("css/default.css/jcr:content") && wc.getNode("css/default.css/jcr:content").canAddMixin("exo:webContentChild")) {
                            wc.getNode("css/default.css/jcr:content").addMixin("exo:webContentChild");
                        }
                        wc.save();
                        LOG.info((Object)("Added mixin exo:webContentChild for node " + wc.getPath()));
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)("An unexpected error occurs when add mixin exo:webContentChild for node " + wc.getPath()));
                    }
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Add mixin 'exo:webContentChild' for all webcontent child  successfully!");
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An unexpected error occurs when add mixin exo:webContentChild", (Throwable)e);
            }
        }
        finally {
            sessionProvider.close();
        }
    }

    public void stop() {
    }
}

