/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.updater;

import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.lifecycle.SocialChromatticLifeCycle;

public class ModelOverriderUpdaterPlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(ModelOverriderUpdaterPlugin.class);

    public ModelOverriderUpdaterPlugin(InitParams initParams) {
        super(initParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        PortalContainer portalContainer = PortalContainer.getInstance();
        ChromatticManager manager = (ChromatticManager)portalContainer.getComponentInstanceOfType(ChromatticManager.class);
        manager.startRequest((ExoContainer)portalContainer);
        SocialChromatticLifeCycle lifeCycle = (SocialChromatticLifeCycle)manager.getLifeCycle("soc");
        Session session = lifeCycle.getSession().getJCRSession();
        try {
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)session.getWorkspace().getNodeTypeManager();
            nodeTypeManager.registerNodeTypes(this.getModelIS(), 4, "text/xml");
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
            session.logout();
        }
        finally {
            manager.endRequest((ExoContainer)portalContainer);
        }
    }

    public InputStream getModelIS() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/portal/chromattic-nodetypes.xml");
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

