/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.tomcat.dbcp.dbcp.AbandonedConfig;
import org.apache.tomcat.dbcp.dbcp.DelegatingConnection;
import org.apache.tomcat.dbcp.pool.ObjectPool;

public class PoolableConnection
extends DelegatingConnection {
    protected ObjectPool _pool = null;

    public PoolableConnection(Connection conn, ObjectPool pool) {
        super(conn);
        this._pool = pool;
    }

    public PoolableConnection(Connection conn, ObjectPool pool, AbandonedConfig config) {
        super(conn, config);
        this._pool = pool;
    }

    @Override
    public synchronized void close() throws SQLException {
        boolean isUnderlyingConectionClosed;
        if (this._closed) {
            return;
        }
        try {
            isUnderlyingConectionClosed = this._conn.isClosed();
        }
        catch (SQLException e) {
            try {
                this._pool.invalidateObject(this);
            }
            catch (IllegalStateException ise) {
                this.passivate();
                this.getInnermostDelegate().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw (SQLException)new SQLException("Cannot close connection (isClosed check failed)").initCause(e);
        }
        if (!isUnderlyingConectionClosed) {
            try {
                this._pool.returnObject(this);
            }
            catch (IllegalStateException e) {
                this.passivate();
                this.getInnermostDelegate().close();
            }
            catch (SQLException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw (SQLException)new SQLException("Cannot close connection (return to pool failed)").initCause(e);
            }
        } else {
            try {
                this._pool.invalidateObject(this);
            }
            catch (IllegalStateException e) {
                this.passivate();
                this.getInnermostDelegate().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SQLException("Already closed.");
        }
    }

    public void reallyClose() throws SQLException {
        super.close();
    }
}

