/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import juzu.impl.common.Tools;
import juzu.impl.plugin.application.ApplicationLifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetServer {
    HashSet<ApplicationLifeCycle<?, ?>> runtimes = new HashSet();

    public void register(ApplicationLifeCycle<?, ?> assetManager) {
        this.runtimes.add(assetManager);
    }

    public void unregister(ApplicationLifeCycle<?, ?> assetManager) {
        this.runtimes.remove(assetManager);
    }

    public boolean doGet(String path, ServletContext ctx, HttpServletResponse resp) throws ServletException, IOException {
        if (path != null && path.length() > 0) {
            for (ApplicationLifeCycle<?, ?> runtime : this.runtimes) {
                InputStream in;
                String contentType;
                URL url = runtime.getScriptManager().resolveAsset(path);
                if (url != null) {
                    contentType = "text/javascript";
                    in = url.openStream();
                } else {
                    contentType = null;
                    in = null;
                }
                if (in == null && (url = runtime.getStylesheetManager().resolveAsset(path)) != null) {
                    contentType = "text/css";
                    in = runtime.getApplication().getClassLoader().getResourceAsStream(path.substring(1));
                }
                if (in == null) {
                    in = ctx.getResourceAsStream(path);
                    if (in != null) {
                        int pos = path.lastIndexOf(47);
                        String name = pos == -1 ? path : path.substring(pos + 1);
                        contentType = ctx.getMimeType(name);
                    } else {
                        contentType = null;
                        in = null;
                    }
                }
                if (in == null) continue;
                if (contentType != null) {
                    resp.setContentType(contentType);
                }
                Tools.copy(in, (OutputStream)resp.getOutputStream());
                return true;
            }
        }
        return false;
    }
}

