/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.skin;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.skin.WCMSkinResourceResolver;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class XSkinService
implements Startable {
    public static final String SKIN_PATH_REGEXP = "/(.*)/css/jcr/(.*)/(.*)/(.*).css";
    private static final String SKIN_PATH_PATTERN = "/{docBase}/css/jcr/(.*)/(.*)/Stylesheet.css";
    private static final Log LOG = ExoLogger.getLogger((String)XSkinService.class.getName());
    private WCMConfigurationService configurationService;
    private SkinService skinService = WCMCoreUtils.getService(SkinService.class);
    private ServletContext servletContext;

    public XSkinService(LivePortalManagerService livePortalService) throws Exception {
        this.skinService.addResourceResolver((ResourceResolver)new WCMSkinResourceResolver(this.skinService, livePortalService));
        this.configurationService = WCMCoreUtils.getService(WCMConfigurationService.class);
        this.servletContext = WCMCoreUtils.getService(ServletContext.class);
    }

    public String getActiveStylesheet(Node webcontent) throws Exception {
        return WCMCoreUtils.getActiveStylesheet(webcontent);
    }

    public void updatePortalSkinOnModify(Node portal, Node cssFile) throws Exception {
        String sharedPortalName = this.configurationService.getSharedPortalName();
        if (sharedPortalName.equals(portal.getName())) {
            this.addSharedPortalSkin(portal);
        } else {
            this.addPortalSkin(portal);
        }
    }

    public void updatePortalSkinOnRemove(Node portal, Node cssFile) throws Exception {
        this.updatePortalSkinOnModify(portal, cssFile);
    }

    private void addPortalSkin(Node portalNode) throws Exception {
        String skinPath = StringUtils.replaceOnce((String)SKIN_PATH_PATTERN, (String)"(.*)", (String)portalNode.getName()).replaceFirst("\\{docBase\\}", this.servletContext.getServletContextName());
        Iterator iterator = this.skinService.getAvailableSkinNames().iterator();
        if (!iterator.hasNext()) {
            skinPath = StringUtils.replaceOnce((String)skinPath, (String)"(.*)", (String)"Default");
            this.skinService.invalidateCachedSkin(skinPath);
            this.skinService.addSkin(portalNode.getName(), "Default", skinPath);
        } else {
            while (iterator.hasNext()) {
                String skinName = (String)iterator.next();
                skinPath = StringUtils.replaceOnce((String)skinPath, (String)"(.*)", (String)skinName);
                this.skinService.invalidateCachedSkin(skinPath);
                this.skinService.addSkin(portalNode.getName(), skinName, skinPath);
            }
        }
    }

    private void addSharedPortalSkin(Node portalNode) throws Exception {
        String skinPath = StringUtils.replaceOnce((String)SKIN_PATH_PATTERN, (String)"(.*)", (String)portalNode.getName()).replaceFirst("\\{docBase\\}", this.servletContext.getServletContextName());
        for (String skinName : this.skinService.getAvailableSkinNames()) {
            skinPath = StringUtils.replaceOnce((String)skinPath, (String)"(.*)", (String)skinName);
            this.skinService.invalidateCachedSkin(skinPath);
            this.skinService.addPortalSkin(portalNode.getName(), skinName, skinPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
            List<Node> livePortals = livePortalManagerService.getLivePortals(sessionProvider);
            for (Node portal : livePortals) {
                this.addPortalSkin(portal);
            }
            Node sharedPortal = livePortalManagerService.getLiveSharedPortal(sessionProvider);
            this.addSharedPortalSkin(sharedPortal);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Exception when start XSkinService", (Throwable)e);
            }
        }
        finally {
            sessionProvider.close();
        }
    }

    public void stop() {
    }
}

