/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.symlink;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class PublicationUpdateStateListener
extends Listener<CmsService, Node> {
    private static final Log LOG = ExoLogger.getLogger((String)PublicationUpdateStateListener.class.getName());
    private RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<CmsService, Node> event) throws Exception {
        if ("WCMPublicationService.event.updateState".equals(event.getEventName())) {
            String[] wsNames;
            GregorianCalendar dateModified;
            Long index;
            String titlePublished;
            Calendar liveDate;
            Node liveNode;
            String title;
            Node targetNode;
            block53: {
                block52: {
                    block51: {
                        block50: {
                            block49: {
                                targetNode = (Node)event.getData();
                                if (targetNode.isNodeType("exo:taxonomyLink")) {
                                    return;
                                }
                                try {
                                    targetNode.getUUID();
                                }
                                catch (UnsupportedRepositoryOperationException e) {
                                    return;
                                }
                                title = null;
                                liveNode = null;
                                liveDate = null;
                                titlePublished = null;
                                index = null;
                                dateModified = new GregorianCalendar();
                                targetNode.setProperty("exo:dateModified", (Calendar)dateModified);
                                if (targetNode.hasProperty("exo:title")) {
                                    try {
                                        title = targetNode.getProperty("exo:title").getString();
                                    }
                                    catch (PathNotFoundException e) {
                                        if (!LOG.isInfoEnabled()) break block49;
                                        LOG.info((Object)"No such of property exo:title for this node:");
                                    }
                                }
                            }
                            if (targetNode.hasProperty("publication:liveDate")) {
                                try {
                                    liveDate = targetNode.getProperty("publication:liveDate").getDate();
                                }
                                catch (PathNotFoundException e) {
                                    if (!LOG.isInfoEnabled()) break block50;
                                    LOG.info((Object)"No such of property publication:liveDate for this node:");
                                }
                            }
                        }
                        if (targetNode.hasProperty("publication:liveRevision")) {
                            try {
                                String nodeVersionUUID = targetNode.getProperty("publication:liveRevision").getString();
                                Node revNode = targetNode.getVersionHistory().getSession().getNodeByUUID(nodeVersionUUID);
                                if (revNode != null) {
                                    liveNode = revNode.getNode("jcr:frozenNode");
                                }
                            }
                            catch (Exception e) {
                                if (!LOG.isWarnEnabled()) break block51;
                                LOG.warn((Object)e.getMessage());
                            }
                        }
                    }
                    try {
                        if (!targetNode.isNodeType("exo:sortable") && targetNode.canAddMixin("exo:sortable")) {
                            targetNode.addMixin("exo:sortable");
                        }
                    }
                    catch (PathNotFoundException e) {
                        if (!LOG.isWarnEnabled()) break block52;
                        LOG.warn((Object)e.getMessage());
                    }
                }
                if (!targetNode.hasProperty("exo:index")) {
                    targetNode.setProperty("exo:index", new Long(1000L).longValue());
                }
                if (targetNode.hasProperty("exo:index")) {
                    try {
                        index = targetNode.getProperty("exo:index").getLong();
                    }
                    catch (PathNotFoundException e) {
                        if (!LOG.isInfoEnabled()) break block53;
                        LOG.info((Object)"No such of property exo:index for this node:");
                    }
                }
            }
            if (liveNode != null && liveNode.hasProperty("exo:title")) {
                titlePublished = targetNode.hasProperty("exo:titlePublished") ? targetNode.getProperty("exo:titlePublished").getString() : null;
                String liveTitle = liveNode.getProperty("exo:title").getString();
                if (liveTitle != null && !liveTitle.equals(titlePublished)) {
                    targetNode.setProperty("exo:titlePublished", liveTitle);
                    titlePublished = liveTitle;
                    targetNode.save();
                }
            }
            for (String workspace : wsNames = this.repositoryService.getCurrentRepository().getWorkspaceNames()) {
                Session session = this.repositoryService.getCurrentRepository().getSystemSession(workspace);
                try {
                    QueryManager queryManager = session.getWorkspace().getQueryManager();
                    Query query = queryManager.createQuery("SELECT * FROM exo:taxonomyLink WHERE exo:uuid='" + targetNode.getUUID() + "'", "sql");
                    NodeIterator iterator = query.execute().getNodes();
                    boolean needSessionSave = false;
                    while (iterator.hasNext()) {
                        Node linkNode;
                        block58: {
                            block57: {
                                block56: {
                                    block55: {
                                        block54: {
                                            linkNode = iterator.nextNode();
                                            if (!linkNode.isNodeType("exo:sortable")) {
                                                if (!linkNode.canAddMixin("exo:sortable")) break;
                                                linkNode.addMixin("exo:sortable");
                                            }
                                            try {
                                                String currentName;
                                                String string = currentName = linkNode.hasProperty("exo:name") ? linkNode.getProperty("exo:name").getString() : null;
                                                if (this.name != null && !this.name.equals(currentName)) {
                                                    linkNode.setProperty("exo:name", this.name);
                                                    needSessionSave = true;
                                                }
                                            }
                                            catch (PathNotFoundException e) {
                                                if (!LOG.isWarnEnabled()) break block54;
                                                LOG.warn((Object)e.getMessage());
                                            }
                                        }
                                        try {
                                            Long currentIndex;
                                            Long l = currentIndex = linkNode.hasProperty("exo:index") ? Long.valueOf(linkNode.getProperty("exo:index").getLong()) : null;
                                            if (index != null && !index.equals(currentIndex)) {
                                                linkNode.setProperty("exo:index", index.longValue());
                                                needSessionSave = true;
                                            }
                                        }
                                        catch (PathNotFoundException e) {
                                            if (!LOG.isWarnEnabled()) break block55;
                                            LOG.warn((Object)e.getMessage());
                                        }
                                    }
                                    try {
                                        String currentTitle;
                                        String string = currentTitle = linkNode.hasProperty("exo:title") ? linkNode.getProperty("exo:title").getString() : null;
                                        if (title != null && !title.equals(currentTitle)) {
                                            linkNode.setProperty("exo:title", title);
                                            needSessionSave = true;
                                        }
                                    }
                                    catch (PathNotFoundException e) {
                                        if (!LOG.isWarnEnabled()) break block56;
                                        LOG.warn((Object)e.getMessage());
                                    }
                                }
                                try {
                                    String currTitlePublished;
                                    String string = currTitlePublished = linkNode.hasProperty("exo:titlePublished") ? linkNode.getProperty("exo:titlePublished").getString() : null;
                                    if (titlePublished != null && !titlePublished.equals(currTitlePublished)) {
                                        linkNode.setProperty("exo:titlePublished", titlePublished);
                                        needSessionSave = true;
                                    }
                                }
                                catch (PathNotFoundException e) {
                                    if (!LOG.isWarnEnabled()) break block57;
                                    LOG.warn((Object)e.getMessage());
                                }
                            }
                            try {
                                Calendar currLiveDate;
                                Calendar calendar = currLiveDate = linkNode.hasProperty("publication:liveDate") ? linkNode.getProperty("publication:liveDate").getDate() : null;
                                if (liveDate != null && !liveDate.equals(currLiveDate)) {
                                    linkNode.setProperty("publication:liveDate", liveDate);
                                    needSessionSave = true;
                                }
                            }
                            catch (PathNotFoundException e) {
                                if (!LOG.isWarnEnabled()) break block58;
                                LOG.warn((Object)e.getMessage());
                            }
                        }
                        if (linkNode.hasProperty("exo:dateModified")) {
                            Calendar currentDateModified = linkNode.getProperty("exo:dateModified").getDate();
                            if (dateModified != null && !((Calendar)dateModified).equals(currentDateModified)) {
                                linkNode.setProperty("exo:dateModified", (Calendar)dateModified);
                                needSessionSave = true;
                            }
                        }
                        if (!LOG.isInfoEnabled()) continue;
                        String currentState = targetNode.hasProperty("publication:currentState") ? targetNode.getProperty("publication:currentState").getString() : "";
                        String currentName = linkNode.hasProperty("exo:name") ? linkNode.getProperty("exo:name").getString() : "";
                        String currentIndex = linkNode.hasProperty("exo:index") ? linkNode.getProperty("exo:index").getString() : "";
                        String currentTitle = linkNode.hasProperty("exo:title") ? linkNode.getProperty("exo:title").getString() : "";
                        String currentTitlePub = linkNode.hasProperty("exo:titlePublished") ? linkNode.getProperty("exo:titlePublished").getString() : "";
                        String currLiveDate = linkNode.hasProperty("publication:liveDate") ? linkNode.getProperty("publication:liveDate").getDate().getTime().toString() : "";
                        String currentDateModified = linkNode.hasProperty("exo:dateModified") ? linkNode.getProperty("exo:dateModified").getDate().getTime().toString() : "";
                        LOG.info((Object)("@@@@ " + needSessionSave + " @state@" + currentState + " @Name@" + currentName + " @Index@" + currentIndex + " @Title@" + currentTitle + " @TitlePub@" + currentTitlePub + " @DateLive@" + currLiveDate + " @DateMod@" + currentDateModified));
                    }
                    if (!needSessionSave) continue;
                    session.save();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)"Unexpected problem occur. Update state process is not completed", (Throwable)e);
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
        }
    }
}

