/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.chromattic.entity;

import java.util.List;
import java.util.Map;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.DefaultValue;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.ManyToOne;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.social.core.chromattic.entity.ActivityRefDayEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityRefYearEntity;
import org.exoplatform.social.core.chromattic.entity.IndexNumber;
import org.exoplatform.social.core.chromattic.entity.NamedEntity;

@PrimaryType(name="soc:activityrefmonth", orderable=true)
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@NamingPrefix(value="soc")
public abstract class ActivityRefMonthEntity
implements NamedEntity,
IndexNumber {
    @Path
    public abstract String getPath();

    @Override
    @Name
    public abstract String getName();

    @Override
    @Property(name="soc:number")
    @DefaultValue(value={"0"})
    public abstract Integer getNumber();

    public abstract void setNumber(Integer var1);

    @OneToMany
    public abstract Map<String, ActivityRefDayEntity> getDays();

    @OneToMany
    public abstract List<ActivityRefDayEntity> getDaysList();

    @ManyToOne
    public abstract ActivityRefYearEntity getYear();

    @Create
    public abstract ActivityRefDayEntity newDay();

    @Create
    public abstract ActivityRefDayEntity newDay(String var1);

    public void inc() {
        this.getYear().inc();
        this.setNumber(this.getNumber() + 1);
    }

    public void desc() {
        this.getYear().desc();
        this.setNumber(this.getNumber() - 1);
    }

    public ActivityRefDayEntity getDay(String day) {
        ActivityRefDayEntity dayEntity = this.getDays().get(day);
        if (dayEntity == null) {
            dayEntity = this.newDay();
            this.getDays().put(day, dayEntity);
            long longDay = Long.parseLong(day);
            for (int i = this.getDaysList().size() - 1; i >= 0; --i) {
                long longCurrent = Long.parseLong(this.getDaysList().get(i).getName());
                if (longCurrent >= longDay) continue;
                this.getDaysList().add(i, dayEntity);
            }
        }
        return dayEntity;
    }
}

