/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.tree;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.WikiHome;
import org.exoplatform.wiki.service.PermissionType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.tree.PageTreeNode;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.TreeNodeType;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.utils.Utils;

public class WikiHomeTreeNode
extends TreeNode {
    private WikiHome wikiHome;

    public WikiHomeTreeNode(WikiHome wikiHome) throws Exception {
        super(wikiHome.getTitle(), TreeNodeType.WIKIHOME);
        this.wikiHome = wikiHome;
        this.path = this.buildPath();
        this.hasChild = wikiHome.getChildPages().size() > 0;
    }

    @Override
    protected void addChildren(HashMap<String, Object> context) throws Exception {
        Collection<PageImpl> pages = this.wikiHome.getChildrenByRootPermission().values();
        Iterator<PageImpl> childPageIterator = pages.iterator();
        int size = this.getNumberOfChildren(context, pages.size());
        PageImpl currentPage = (PageImpl)context.get("selectedPage");
        for (int count = 0; childPageIterator.hasNext() && count < size; ++count) {
            PageImpl childPage = childPageIterator.next();
            if (!childPage.hasPermission(PermissionType.VIEWPAGE) && (currentPage == null || !Utils.isDescendantPage(currentPage, childPage))) continue;
            PageTreeNode child = new PageTreeNode(childPage);
            this.children.add(child);
        }
        super.addChildren(context);
    }

    public WikiHome getWikiHome() {
        return this.wikiHome;
    }

    public PageTreeNode getChildByName(String name) throws Exception {
        for (TreeNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return (PageTreeNode)child;
        }
        return null;
    }

    public PageTreeNode findDescendantNodeByName(List<TreeNode> listPageTreeNode, String name) throws Exception {
        for (TreeNode pageTreeNode : listPageTreeNode) {
            if (pageTreeNode.getName().equals(name)) {
                return (PageTreeNode)pageTreeNode;
            }
            List<TreeNode> listChildPageTreeNode = pageTreeNode.getChildren();
            if (listChildPageTreeNode.size() <= 0) continue;
            return this.findDescendantNodeByName(listChildPageTreeNode, name);
        }
        return null;
    }

    @Override
    public String buildPath() {
        Wiki wiki = this.wikiHome.getWiki();
        WikiPageParams params = new WikiPageParams(wiki.getType(), wiki.getOwner(), "WikiHome");
        return TreeUtils.getPathFromPageParams(params);
    }
}

