/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.naming;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.services.naming.SimpleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoContainerContextFactory
implements InitialContextFactory {
    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        return new ExoContainerCtx(environment);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExoContainerCtx
    extends SimpleContext {
        private static volatile Map<ExoContainer, AtomicReference<Map<String, Object>>> ALL_BINDINGS = new HashMap<ExoContainer, AtomicReference<Map<String, Object>>>();
        private final Hashtable env;
        private final ExoContainer container;
        private InitialContext ctx;
        private AtomicReference<Map<String, Object>> bindingsRef;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public ExoContainerCtx(Hashtable<?, ?> env) {
            this.env = env == null ? null : (Hashtable)env.clone();
            this.container = ExoContainerContext.getCurrentContainerIfPresent();
            if (this.container == null) return;
            AtomicReference<Map<String, Object>> ref = ALL_BINDINGS.get(this.container);
            if (ref == null) {
                Class<ExoContainerCtx> clazz = ExoContainerCtx.class;
                // MONITORENTER : org.exoplatform.services.naming.ExoContainerContextFactory$ExoContainerCtx.class
                if (ref == null) {
                    HashMap<ExoContainer, AtomicReference<Map<String, Object>>> tempAllBindings = new HashMap<ExoContainer, AtomicReference<Map<String, Object>>>(ALL_BINDINGS);
                    ref = new AtomicReference(new HashMap());
                    tempAllBindings.put(this.container, ref);
                    ALL_BINDINGS = tempAllBindings;
                }
                // MONITOREXIT : clazz
            }
            this.bindingsRef = ref;
        }

        @Override
        protected void bindRefValue(String name, Object value) throws NamingException {
            this.bind(name, value, false);
        }

        @Override
        protected Map<String, Object> getBindings() {
            return this.bindingsRef.get();
        }

        @Override
        protected void setBindings(Map<String, Object> bindings) {
            this.bindingsRef.set(bindings);
        }

        private InitialContext getContext() throws NamingException {
            if (this.ctx == null) {
                Hashtable<String, String> env = this.env == null ? new Hashtable<String, String>() : new Hashtable(this.env);
                env.put("java.naming.factory.initial", InitialContextInitializer.DEFAULT_INITIAL_CONTEXT_FACTORY);
                env.remove(InitialContextInitializer.class.getName());
                this.ctx = new InitialContext(env);
            }
            return this.ctx;
        }

        private boolean isInitialContextInitializerCall() {
            return this.container != null && this.env != null && this.env.containsKey(InitialContextInitializer.class.getName());
        }

        @Override
        public Object lookup(String name) throws NamingException {
            if (this.getBindings().containsKey(name) || this.isInitialContextInitializerCall()) {
                return super.lookup(name);
            }
            return this.getContext().lookup(name);
        }

        @Override
        public Object lookup(Name name) throws NamingException {
            String sName = this.nameToString(name);
            if (this.getBindings().containsKey(sName) || this.isInitialContextInitializerCall()) {
                return super.lookup(sName);
            }
            return this.getContext().lookup(name);
        }

        @Override
        public void bind(String name, Object value) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                super.bind(name, value);
                return;
            }
            this.getContext().bind(name, value);
        }

        @Override
        public void bind(Name name, Object value) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                super.bind(this.nameToString(name), value);
                return;
            }
            this.getContext().bind(name, value);
        }

        @Override
        public void rebind(String name, Object value) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                super.rebind(name, value);
                return;
            }
            this.getContext().rebind(name, value);
        }

        @Override
        public void rebind(Name name, Object value) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                super.rebind(this.nameToString(name), value);
                return;
            }
            this.getContext().rebind(name, value);
        }

        @Override
        public void unbind(String name) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                super.unbind(name);
                return;
            }
            this.getContext().unbind(name);
        }

        @Override
        public void unbind(Name name) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                super.unbind(this.nameToString(name));
                return;
            }
            this.getContext().unbind(name);
        }

        @Override
        public void rename(String name1, String name2) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                super.rename(name1, name2);
                return;
            }
            this.getContext().rename(name1, name2);
        }

        @Override
        public void rename(Name name1, Name name2) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                super.rename(this.nameToString(name1), this.nameToString(name2));
                return;
            }
            this.getContext().rename(name1, name2);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                return super.list(name);
            }
            return this.getContext().list(name);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                return super.list(name);
            }
            return this.getContext().list(name);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                return super.listBindings(name);
            }
            return this.getContext().listBindings(name);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                return super.listBindings(name);
            }
            return this.getContext().listBindings(name);
        }

        @Override
        public void destroySubcontext(Name name) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                super.destroySubcontext(name);
                return;
            }
            this.getContext().destroySubcontext(name);
        }

        @Override
        public void destroySubcontext(String name) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                super.destroySubcontext(name);
                return;
            }
            this.getContext().destroySubcontext(name);
        }

        @Override
        public Context createSubcontext(Name name) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                return super.createSubcontext(name);
            }
            return this.getContext().createSubcontext(name);
        }

        @Override
        public Context createSubcontext(String name) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                return super.createSubcontext(name);
            }
            return this.getContext().createSubcontext(name);
        }

        @Override
        public Object lookupLink(Name name) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                return super.lookupLink(name);
            }
            return this.getContext().lookupLink(name);
        }

        @Override
        public Object lookupLink(String name) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                return super.lookupLink(name);
            }
            return this.getContext().lookupLink(name);
        }

        @Override
        public NameParser getNameParser(Name name) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                return super.getNameParser(name);
            }
            return this.getContext().getNameParser(name);
        }

        @Override
        public NameParser getNameParser(String name) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                return super.getNameParser(name);
            }
            return this.getContext().getNameParser(name);
        }

        @Override
        public Name composeName(Name name, Name prefix) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                return super.composeName(name, prefix);
            }
            return this.getContext().composeName(name, prefix);
        }

        @Override
        public String composeName(String name, String prefix) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                return super.composeName(name, prefix);
            }
            return this.getContext().composeName(name, prefix);
        }

        @Override
        public Object addToEnvironment(String propName, Object propVal) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                return super.addToEnvironment(propName, propVal);
            }
            return this.getContext().addToEnvironment(propName, propVal);
        }

        @Override
        public Object removeFromEnvironment(String propName) throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                return super.removeFromEnvironment(propName);
            }
            return this.getContext().removeFromEnvironment(propName);
        }

        @Override
        public Hashtable<?, ?> getEnvironment() throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                if (this.env == null) {
                    return new Hashtable(3, 0.75f);
                }
                return (Hashtable)this.env.clone();
            }
            return this.getContext().getEnvironment();
        }

        @Override
        protected Hashtable<?, ?> getInternalEnv() {
            return this.env;
        }

        @Override
        protected Object getMutex() {
            return this.bindingsRef;
        }

        @Override
        public void close() throws NamingException {
            this.bindingsRef = null;
            if (this.env != null) {
                this.env.clear();
            }
            if (this.ctx != null) {
                this.ctx.close();
            }
        }

        @Override
        public String getNameInNamespace() throws NamingException {
            if (this.isInitialContextInitializerCall()) {
                return super.getNameInNamespace();
            }
            return this.getContext().getNameInNamespace();
        }
    }
}

