/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import org.exoplatform.forum.service.ForumService;
import org.exoplatform.job.MultiTenancyJob;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class UpdateDataJob
extends MultiTenancyJob {
    private static Log log_ = ExoLogger.getLogger(UpdateDataJob.class);

    public Class<? extends MultiTenancyJob.MultiTenancyTask> getTask() {
        return UpdateDataTask.class;
    }

    public class UpdateDataTask
    extends MultiTenancyJob.MultiTenancyTask {
        public UpdateDataTask(JobExecutionContext context, String repoName) {
            super((MultiTenancyJob)UpdateDataJob.this, context, repoName);
        }

        public void run() {
            super.run();
            try {
                ForumService forumService = (ForumService)this.container.getComponentInstanceOfType(ForumService.class);
                String name = this.context.getJobDetail().getKey().getName();
                JobDataMap jdatamap = this.context.getJobDetail().getJobDataMap();
                String path = jdatamap.getString("path");
                forumService.updateForum(path);
                JobSchedulerService schedulerService = (JobSchedulerService)this.container.getComponentInstanceOfType(JobSchedulerService.class);
                JobInfo info = new JobInfo(name, "KnowledgeSuite-forum", this.context.getJobDetail().getJobClass());
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)"\n\nForum statistic updated");
                }
                schedulerService.removeJob(info);
            }
            catch (Exception e) {
                log_.trace((Object)("\nStatistic Forum could not updated: \n" + e.getCause()));
            }
        }
    }
}

