/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.apache.catalina.ant.AbstractCatalinaCommandTask;
import org.apache.tools.ant.BuildException;

public class DeployTask
extends AbstractCatalinaCommandTask {
    protected String config = null;
    protected String localWar = null;
    protected String tag = null;
    protected boolean update = false;
    protected String war = null;

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getLocalWar() {
        return this.localWar;
    }

    public void setLocalWar(String localWar) {
        this.localWar = localWar;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean getUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public String getWar() {
        return this.war;
    }

    public void setWar(String war) {
        this.war = war;
    }

    @Override
    public void execute() throws BuildException {
        super.execute();
        if (this.path == null) {
            throw new BuildException("Must specify 'path' attribute");
        }
        if (this.war == null && this.localWar == null && this.config == null && this.tag == null) {
            throw new BuildException("Must specify either 'war', 'localWar', 'config', or 'tag' attribute");
        }
        BufferedInputStream stream = null;
        String contentType = null;
        int contentLength = -1;
        if (this.war != null) {
            if (this.war.startsWith("file:")) {
                try {
                    URL url = new URL(this.war);
                    URLConnection conn = url.openConnection();
                    contentLength = conn.getContentLength();
                    stream = new BufferedInputStream(conn.getInputStream(), 1024);
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e);
                }
            }
            try {
                FileInputStream fsInput = new FileInputStream(this.war);
                long size = fsInput.getChannel().size();
                if (size > Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("DeployTask does not support WAR files greater than 2 Gb");
                }
                contentLength = (int)size;
                stream = new BufferedInputStream(fsInput, 1024);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            contentType = "application/octet-stream";
        }
        StringBuilder sb = this.createQueryString("/deploy");
        try {
            if (this.war == null && this.config != null) {
                sb.append("&config=");
                sb.append(URLEncoder.encode(this.config, this.getCharset()));
            }
            if (this.war == null && this.localWar != null) {
                sb.append("&war=");
                sb.append(URLEncoder.encode(this.localWar, this.getCharset()));
            }
            if (this.update) {
                sb.append("&update=true");
            }
            if (this.tag != null) {
                sb.append("&tag=");
                sb.append(URLEncoder.encode(this.tag, this.getCharset()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new BuildException("Invalid 'charset' attribute: " + this.getCharset());
        }
        this.execute(sb.toString(), stream, contentType, contentLength);
    }
}

