/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.webui;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.webui.BaseUIForm;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/forum/common/UIPermissionGrid.gtmpl", events={@EventConfig(listeners={TogglePermissionActionListener.class}), @EventConfig(listeners={RemoveOwnerActionListener.class})})
public class UIPermissionGrid
extends UIContainer {
    private Set<String> permissions = new LinkedHashSet<String>();
    private Map<String, Set<String>> owners = new HashMap<String, Set<String>>();

    public UIPermissionGrid() {
        this.setId("UIPermissionGrid");
    }

    void setPermissions(String ... permissions) {
        this.permissions.addAll(Arrays.asList(permissions));
    }

    protected Set<String> getPermissions() {
        return this.permissions;
    }

    protected String getLabelPermission(String id) throws Exception {
        BaseUIForm uiForm = (BaseUIForm)this.getAncestorOfType(BaseUIForm.class);
        return uiForm.getLabel(id);
    }

    void setOwners(String ... values) {
        for (String value : values) {
            if (value.length() == 0 || this.owners.containsKey(value)) continue;
            this.owners.put(value, new HashSet<String>(this.permissions));
        }
    }

    Set<String> getOwners() {
        return this.owners.keySet();
    }

    void removeOwner(String owner) {
        this.owners.remove(owner);
    }

    boolean hasPermission(String owner, String permission) {
        if (this.owners.containsKey(owner)) {
            Set<String> permissions = this.owners.get(owner);
            return permissions.contains(permission);
        }
        return false;
    }

    boolean removePermission(String owner, String permission) {
        if (this.owners.containsKey(owner)) {
            Set<String> permissions = this.owners.get(owner);
            return permissions.remove(permission);
        }
        return true;
    }

    boolean addPermission(String owner, String permission) {
        if (this.owners.containsKey(owner)) {
            Set<String> permissions = this.owners.get(owner);
            return permissions.add(permission);
        }
        this.owners.put(owner, new HashSet<String>(Arrays.asList(permission)));
        return true;
    }

    String getOwnersByPermission(String permission) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Set<String>> entry : this.owners.entrySet()) {
            Set<String> permissions = entry.getValue();
            if (!permissions.contains(permission)) continue;
            sb.append(entry.getKey());
            sb.append(',');
        }
        return sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
    }

    String getDisplayNameOfOwner(String owner) throws Exception {
        if (CommonUtils.isEmpty(owner)) {
            return "";
        }
        OrganizationService service = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
        UserHandler userHandler = service.getUserHandler();
        GroupHandler groupHandler = service.getGroupHandler();
        if (owner.contains("/")) {
            if (owner.contains(":")) {
                String membership = owner.substring(0, owner.indexOf(":"));
                String groupId = owner.substring(membership.length() + 1);
                String groupName = groupHandler.findGroupById(groupId).getGroupName();
                return membership + " in " + groupName;
            }
            return groupHandler.findGroupById(owner).getGroupName();
        }
        User user = userHandler.findUserByName(owner);
        String displayName = user.getDisplayName();
        if (CommonUtils.isEmpty(displayName) || owner.equals(displayName)) {
            displayName = user.getFirstName() + " " + user.getLastName();
        }
        return displayName;
    }

    public static class TogglePermissionActionListener
    extends EventListener<UIPermissionGrid> {
        public void execute(Event<UIPermissionGrid> event) throws Exception {
            String permission;
            String owner;
            String requestParam = event.getRequestContext().getRequestParameter("objectId");
            UIPermissionGrid grid = (UIPermissionGrid)((Object)event.getSource());
            if (grid.hasPermission(owner = requestParam.substring(0, requestParam.indexOf(",")), permission = requestParam.substring(owner.length() + 1))) {
                grid.removePermission(owner, permission);
            } else {
                grid.addPermission(owner, permission);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)event.getSource());
        }
    }

    public static class RemoveOwnerActionListener
    extends EventListener<UIPermissionGrid> {
        public void execute(Event<UIPermissionGrid> event) throws Exception {
            String owner = event.getRequestContext().getRequestParameter("objectId");
            UIPermissionGrid source = (UIPermissionGrid)((Object)event.getSource());
            source.removeOwner(owner);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)source);
        }
    }
}

