/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.infinispan.util.ReversibleOrderedSet;

public class InfinispanCollections {
    private static final ReversibleOrderedSet<Object> EMPTY_ROS = new EmptyReversibleOrderedSet<Object>();

    public static <K, V, E> Map<K, V> transformMapValue(Map<K, E> input, Function<E, V> f) {
        if (input.isEmpty()) {
            return Collections.emptyMap();
        }
        if (input.size() == 1) {
            Map.Entry<K, E> single = input.entrySet().iterator().next();
            return Collections.singletonMap(single.getKey(), f.transform(single.getValue()));
        }
        HashMap<K, V> copy = new HashMap<K, V>(input.size());
        for (Map.Entry<K, E> entry : input.entrySet()) {
            copy.put(entry.getKey(), f.transform(entry.getValue()));
        }
        return Collections.unmodifiableMap(copy);
    }

    public static <K, V, E> Map<K, V> transformCollectionToMap(Collection<E> input, MapMakerFunction<K, V, E> f) {
        if (input.isEmpty()) {
            return Collections.emptyMap();
        }
        if (input.size() == 1) {
            E single = input.iterator().next();
            Map.Entry<K, V> entry = f.transform(single);
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        HashMap<K, V> map = new HashMap<K, V>(input.size());
        for (E e : input) {
            Map.Entry<K, V> entry = f.transform(e);
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public static interface MapMakerFunction<K, V, E> {
        public Map.Entry<K, V> transform(E var1);
    }

    public static interface Function<E, T> {
        public T transform(E var1);
    }

    private static final class EmptyReversibleOrderedSet<E>
    extends AbstractSet<E>
    implements ReversibleOrderedSet<E> {
        Iterator<E> it = new Iterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public E next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };

        private EmptyReversibleOrderedSet() {
        }

        @Override
        public Iterator<E> iterator() {
            return this.it;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<E> reverseIterator() {
            return this.it;
        }
    }
}

