/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.utils;

import java.security.PrivilegedExceptionAction;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DialectDetecter {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.database.DialectDetecter");

    public static String detect(final DatabaseMetaData metaData) throws SQLException {
        String databaseName = (String)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                return metaData.getDatabaseProductName();
            }
        });
        if ("HSQL Database Engine".equals(databaseName)) {
            return "HSQLDB";
        }
        if ("H2".equals(databaseName)) {
            return "H2";
        }
        if ("MySQL".equals(databaseName)) {
            return "MYSQL";
        }
        if ("PostgreSQL".equals(databaseName)) {
            int majorVersion = metaData.getDatabaseMajorVersion();
            int minorVersion = metaData.getDatabaseMinorVersion();
            return majorVersion > 9 || majorVersion == 9 && minorVersion >= 1 ? "PGSQL-SCS" : "PGSQL";
        }
        if ("EnterpriseDB".equals(databaseName)) {
            return "PGSQL-SCS";
        }
        if ("Apache Derby".equals(databaseName)) {
            return "DERBY";
        }
        if ("ingres".equalsIgnoreCase(databaseName)) {
            return "INGRES";
        }
        if (databaseName.startsWith("Microsoft SQL Server")) {
            return "MSSQL";
        }
        if ("Sybase SQL Server".equals(databaseName) || "Adaptive Server Enterprise".equals(databaseName)) {
            return "SYBASE";
        }
        if (databaseName.startsWith("Adaptive Server Anywhere")) {
            return "SYBASE";
        }
        if (databaseName.startsWith("DB2/")) {
            return DialectDetecter.detectDB2Dialect(metaData);
        }
        if ("Oracle".equals(databaseName)) {
            return "ORACLE";
        }
        return "GENERIC";
    }

    private static String detectDB2Dialect(DatabaseMetaData metaData) throws SQLException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DB Major version = " + metaData.getDatabaseMajorVersion() + ", DB Minor version = " + metaData.getDatabaseMinorVersion() + ", DB Product version = " + metaData.getDatabaseProductVersion()));
        }
        int majorVersion = metaData.getDatabaseMajorVersion();
        int minorVersion = metaData.getDatabaseMinorVersion();
        if (majorVersion < 9) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The dialect DB2V8 will be used as the major version is lower than 9.");
            }
            return "DB2V8";
        }
        if (majorVersion > 9) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The dialect DB2-MYS will be used as the major version is greater than 9.");
            }
            return "DB2-MYS";
        }
        if (majorVersion == 9 && minorVersion > 7) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The dialect DB2-MYS will be used as the major version is 9 and the minor version is greater than 7.");
            }
            return "DB2-MYS";
        }
        if (majorVersion == 9 && minorVersion == 7) {
            try {
                int maintenanceVersion = DialectDetecter.getDB2MaintenanceVersion(metaData);
                if (maintenanceVersion >= 2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("The dialect DB2-MYS will be used as the major version is 9, the minor version is 7 and the maintenance version is greater or equals to 2, knowing that the extracted value is " + maintenanceVersion + "."));
                    }
                    return "DB2-MYS";
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The dialect DB2 will be used as the major version is 9, the minor version is 7 and the maintenance version is lower than 2, knowing that the extracted value is " + maintenanceVersion + "."));
                }
                return "DB2";
            }
            catch (SQLException e) {
                LOG.error((Object)"Error checking product version.", (Throwable)e);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The dialect DB2 will be used as the major version is 9, the minor version is 7 and determination the maintenance version failed");
                }
                return "DB2";
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"The dialect DB2 will be used as the major version is 9 and the minor version is lower than 7");
        }
        return "DB2";
    }

    private static int getDB2MaintenanceVersion(DatabaseMetaData metaData) throws SQLException {
        String query = "SELECT service_level FROM TABLE (sysproc.env_get_inst_info())";
        int maintenanceVersionPosition = 2;
        Statement st = metaData.getConnection().createStatement();
        try {
            ResultSet result = st.executeQuery("SELECT service_level FROM TABLE (sysproc.env_get_inst_info())");
            try {
                if (result.next()) {
                    String fullVersion = result.getString(1);
                    String[] splittedVersions = fullVersion.split("\\.");
                    if (splittedVersions.length == 4 && splittedVersions[2].length() >= 1) {
                        int n = Integer.parseInt(splittedVersions[2].substring(0, 1));
                        return n;
                    }
                    throw new SQLException("Wrong format of DB2 version '" + fullVersion + "' in system table ");
                }
                throw new SQLException("There is no data about DB2 version in system table or query is wrong");
            }
            finally {
                result.close();
            }
        }
        finally {
            st.close();
        }
    }
}

