/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.connector;

import java.net.URLEncoder;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.connector.BaseContentSearchServiceConnector;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class FileSearchServiceConnector
extends BaseContentSearchServiceConnector {
    public FileSearchServiceConnector(InitParams initParams) throws Exception {
        super(initParams);
    }

    @Override
    protected String[] getSearchedDocTypes() {
        return new String[]{"nt:file"};
    }

    @Override
    protected ResultNode filterNode(ResultNode node) throws RepositoryException {
        return node.isNodeType("nt:file") ? node : null;
    }

    @Override
    protected String getPath(DriveData driveData, ResultNode node, SearchContext context) throws Exception {
        String siteName = ((PortalContainerInfo)WCMCoreUtils.getService(PortalContainerInfo.class)).getContainerName();
        String restContextName = ((PortalContainerConfig)WCMCoreUtils.getService(PortalContainerConfig.class)).getRestContextName(siteName);
        StringBuffer ret = new StringBuffer();
        ret.append('/').append(siteName).append('/').append(restContextName).append("/jcr/").append(WCMCoreUtils.getRepository().getConfiguration().getName()).append('/').append(node.getSession().getWorkspace().getName()).append(node.getPath());
        return ret.toString();
    }

    @Override
    protected String getImageUrl(Node node) {
        try {
            String path = node.getPath().replaceAll("'", "\\\\'");
            String encodedPath = URLEncoder.encode(path, "utf-8");
            encodedPath = encodedPath.replaceAll("%2F", "/");
            String portalName = WCMCoreUtils.getPortalName();
            String restContextName = WCMCoreUtils.getRestContextName();
            String preferenceWS = node.getSession().getWorkspace().getName();
            String thumbnailImage = "/" + restContextName + "/thumbnailImage/medium/" + WCMCoreUtils.getRepository().getConfiguration().getName() + "/" + preferenceWS + encodedPath;
            return thumbnailImage;
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Can not get image link", (Throwable)e);
            }
            return super.getImageUrl(node);
        }
    }
}

