/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.continuation;

import org.mortbay.cometd.ClientImpl;
import org.mortbay.cometd.continuation.ContinuationBayeux;
import org.mortbay.thread.Timeout;
import org.mortbay.util.ajax.Continuation;

public class ContinuationClient
extends ClientImpl {
    private long _accessed;
    public transient Timeout.Task _timeout;
    private ContinuationBayeux _bayeux;
    private transient Continuation _continuation;

    protected ContinuationClient(ContinuationBayeux bayeux) {
        super(bayeux);
        this._bayeux = bayeux;
        if (!this.isLocal()) {
            this._timeout = new Timeout.Task(){

                public void expired() {
                    ContinuationClient.this.remove(true);
                }

                public String toString() {
                    return "T-" + ContinuationClient.this.toString();
                }
            };
            this._bayeux.startTimeout(this._timeout, this.getTimeout());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContinuation(Continuation continuation) {
        Timeout.Task task = null;
        if (continuation == null) {
            ContinuationClient continuationClient = this;
            synchronized (continuationClient) {
                if (this._continuation != null && this._continuation.isPending()) {
                    this._continuation.resume();
                }
                this._continuation = null;
                task = this._timeout;
            }
            if (task != null) {
                this._bayeux.startTimeout(task, this.getTimeout());
            }
        } else {
            ContinuationClient continuationClient = this;
            synchronized (continuationClient) {
                if (this._continuation != null && this._continuation.isPending()) {
                    this._continuation.resume();
                }
                this._continuation = continuation;
                task = this._timeout;
            }
            if (task != null) {
                this._bayeux.cancelTimeout(task);
            }
        }
    }

    public Continuation getContinuation() {
        return this._continuation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Timeout.Task task = null;
        ContinuationClient continuationClient = this;
        synchronized (continuationClient) {
            if (this._continuation != null) {
                this._continuation.resume();
                task = this._timeout;
            }
            this._continuation = null;
        }
        if (task != null) {
            this._bayeux.startTimeout(task, this.getTimeout());
        }
    }

    public boolean isLocal() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access() {
        Timeout.Task task = null;
        ContinuationClient continuationClient = this;
        synchronized (continuationClient) {
            this._accessed = this._bayeux.getNow();
            if (this._timeout != null && this._timeout.isScheduled()) {
                task = this._timeout;
            }
        }
        if (task != null) {
            this._bayeux.startTimeout(task, this.getTimeout());
        }
    }

    public synchronized long lastAccessed() {
        return this._accessed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(boolean wasTimeout) {
        Timeout.Task task = null;
        ContinuationClient continuationClient = this;
        synchronized (continuationClient) {
            if (!wasTimeout) {
                task = this._timeout;
            }
            this._timeout = null;
            super.remove(wasTimeout);
        }
        if (task != null) {
            this._bayeux.cancelTimeout(task);
        }
    }
}

