/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.Map;

class VariableVisibilityAnalysis
implements CompilerPass {
    private AbstractCompiler compiler;
    private Map<Node, VariableVisibility> visibilityByDeclaringNameNode;

    public VariableVisibilityAnalysis(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.visibilityByDeclaringNameNode = Maps.newHashMap();
    }

    public VariableVisibility getVariableVisibility(Node declaringNameNode) {
        Node parent = declaringNameNode.getParent();
        Preconditions.checkArgument((parent.isVar() || parent.isFunction() || parent.isParamList() ? 1 : 0) != 0);
        return this.visibilityByDeclaringNameNode.get(declaringNameNode);
    }

    @Override
    public void process(Node externs, Node root) {
        ReferenceCollectingCallback callback = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR);
        NodeTraversal.traverse(this.compiler, root, callback);
        for (Scope.Var variable : callback.getAllSymbols()) {
            VariableVisibility visibility;
            ReferenceCollectingCallback.ReferenceCollection referenceCollection = callback.getReferences(variable);
            if (VariableVisibilityAnalysis.variableIsParameter(variable)) {
                visibility = VariableVisibility.PARAMETER;
            } else if (variable.isLocal()) {
                visibility = referenceCollection.isEscaped() ? VariableVisibility.CAPTURED_LOCAL : VariableVisibility.LOCAL;
            } else if (variable.isGlobal()) {
                visibility = VariableVisibility.GLOBAL;
            } else {
                throw new IllegalStateException("Un-handled variable visibility for " + variable);
            }
            this.visibilityByDeclaringNameNode.put(variable.getNameNode(), visibility);
        }
    }

    private static boolean variableIsParameter(Scope.Var variable) {
        Node variableParent = variable.getParentNode();
        return variableParent != null && variableParent.isParamList();
    }

    static enum VariableVisibility {
        LOCAL,
        CAPTURED_LOCAL,
        PARAMETER,
        GLOBAL;

    }
}

