/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.queries.impl;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.queries.impl.QueryData;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

public class QueryPlugin
extends BaseComponentPlugin {
    private static String STATEMENT = "jcr:statement";
    private static String LANGUAGE = "jcr:language";
    private static String PERMISSIONS = "exo:accessPermissions";
    private static String CACHED_RESULT = "exo:cachedResult";
    private InitParams params_;
    private boolean autoCreateInNewRepository_ = false;
    private RepositoryService repositoryService_;
    private DMSConfiguration dmsConfiguration_;
    private Set<String> configuredQueries_;

    public QueryPlugin(RepositoryService repositoryService, InitParams params, DMSConfiguration dmsConfiguration) throws Exception {
        this.params_ = params;
        this.repositoryService_ = repositoryService;
        ValueParam autoInitParam = params.getValueParam("autoCreateInNewRepository");
        if (autoInitParam != null) {
            this.autoCreateInNewRepository_ = Boolean.parseBoolean(autoInitParam.getValue());
        }
        this.dmsConfiguration_ = dmsConfiguration;
    }

    public void init(String basedQueriesPath) throws Exception {
        this.configuredQueries_ = new HashSet<String>();
        Iterator it = this.params_.getObjectParamIterator();
        Session session = null;
        if (this.autoCreateInNewRepository_) {
            session = this.getSession();
            Node queryHomeNode = (Node)session.getItem(basedQueriesPath);
            while (it.hasNext()) {
                QueryData data = (QueryData)((ObjectParameter)it.next()).getObject();
                this.addQuery(queryHomeNode, data);
            }
            queryHomeNode.save();
            session.save();
            session.logout();
        } else {
            session = this.getSession();
            Node queryHomeNode = (Node)session.getItem(basedQueriesPath);
            while (it.hasNext()) {
                QueryData data = (QueryData)((ObjectParameter)it.next()).getObject();
                this.addQuery(queryHomeNode, data);
            }
            queryHomeNode.save();
            session.save();
            session.logout();
        }
    }

    private Session getSession() throws Exception {
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        return sessionProvider.getSession(dmsRepoConfig.getSystemWorkspace(), this.repositoryService_.getCurrentRepository());
    }

    private void addQuery(Node queryHome, QueryData data) throws Exception {
        this.configuredQueries_.add(data.getName());
        if (queryHome.hasNode(data.getName())) {
            return;
        }
        ValueFactory vt = queryHome.getSession().getValueFactory();
        Node queryNode = queryHome.addNode(data.getName(), "nt:query");
        if (!queryNode.isNodeType("exo:datetime")) {
            queryNode.addMixin("exo:datetime");
        }
        queryNode.setProperty("exo:dateCreated", (Calendar)new GregorianCalendar());
        queryNode.addMixin("mix:sharedQuery");
        queryNode.setProperty(STATEMENT, data.getStatement());
        queryNode.setProperty(LANGUAGE, data.getLanguage());
        List<String> queryPermissions = data.getPermissions();
        Value[] vls = new Value[queryPermissions.size()];
        int i = 0;
        for (String per : queryPermissions) {
            Value vl;
            vls[i] = vl = vt.createValue(per);
            ++i;
        }
        queryNode.setProperty(PERMISSIONS, vls);
        queryNode.setProperty(CACHED_RESULT, data.getCacheResult());
    }

    public Set<String> getAllConfiguredQueries() {
        return this.configuredQueries_;
    }
}

