/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.profile;

import org.exoplatform.social.common.lifecycle.AbstractLifeCycle;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListener;

public class ProfileLifeCycle
extends AbstractLifeCycle<ProfileListener, ProfileLifeCycleEvent> {
    protected void dispatchEvent(ProfileListener listener, ProfileLifeCycleEvent event) {
        switch (event.getType()) {
            case AVATAR_UPDATED: {
                listener.avatarUpdated(event);
                break;
            }
            case BASIC_UPDATED: {
                listener.basicInfoUpdated(event);
                break;
            }
            case CONTACT_UPDATED: {
                listener.contactSectionUpdated(event);
                break;
            }
            case EXPERIENCE_UPDATED: {
                listener.experienceSectionUpdated(event);
                break;
            }
            case HEADER_UPDATED: {
                listener.headerSectionUpdated(event);
                break;
            }
        }
    }

    public void avatarUpdated(String username, Profile profile) {
        this.broadcast(new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.AVATAR_UPDATED, username, profile));
    }

    public void basicUpdated(String username, Profile profile) {
        this.broadcast(new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.BASIC_UPDATED, username, profile));
    }

    public void contactUpdated(String username, Profile profile) {
        this.broadcast(new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.CONTACT_UPDATED, username, profile));
    }

    public void experienceUpdated(String username, Profile profile) {
        this.broadcast(new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.EXPERIENCE_UPDATED, username, profile));
    }

    public void headerUpdated(String username, Profile profile) {
        this.broadcast(new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.HEADER_UPDATED, username, profile));
    }
}

