/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.jcr.SearchValidator;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesArea;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIPreferencesForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentFormController;
import org.exoplatform.ecm.webui.component.explorer.search.UIContentNameSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UIECMSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UISavedQuery;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchResult;
import org.exoplatform.ecm.webui.component.explorer.search.UISimpleSearch;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/control/UIActionBar.gtmpl", events={@EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SimpleSearchActionListener.class}), @EventConfig(listeners={AdvanceSearchActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SavedQueriesActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={PreferencesActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={BackToActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowDrivesActionListener.class}, phase=Event.Phase.DECODE)})
public class UIActionBar
extends UIForm {
    private static final Log LOG = ExoLogger.getLogger((String)UIActionBar.class.getName());
    private NodeLocation view_;
    private String templateName_;
    private List<String> tabList_ = new ArrayList<String>();
    private List<String[]> tabs_ = new ArrayList<String[]>();
    private Map<String, String[]> actionInTabs_ = new HashMap<String, String[]>();
    private String selectedTabName_;
    private static final String FIELD_SIMPLE_SEARCH = "simpleSearch";
    private static final String FIELD_ADVANCE_SEARCH = "advanceSearch";
    private static final String FIELD_SEARCH_TYPE = "searchType";
    private static final String FIELD_SQL = "SQL";
    private static final String FIELD_XPATH = "xPath";
    private static final String ROOT_SQL_QUERY = "select * from nt:base where contains(*, '$1') order by exo:dateCreated DESC, jcr:primaryType DESC";
    private static final String SQL_QUERY = "select * from nt:base where jcr:path like '$0/%' and contains(*, '$1') order by jcr:path DESC, jcr:primaryType DESC";
    private String backLink;

    public UIActionBar() throws Exception {
        this.addChild((UIComponent)new UIFormStringInput(FIELD_SIMPLE_SEARCH, FIELD_SIMPLE_SEARCH, null).addValidator(SearchValidator.class, new Object[0]));
        ArrayList<SelectItemOption> typeOptions = new ArrayList<SelectItemOption>();
        typeOptions.add(new SelectItemOption(FIELD_SQL, (Object)"sql"));
        typeOptions.add(new SelectItemOption(FIELD_XPATH, (Object)"xpath"));
        this.addChild((UIComponent)new UIFormSelectBox(FIELD_SEARCH_TYPE, FIELD_SEARCH_TYPE, typeOptions));
        this.addChild((UIComponent)new UIFormStringInput(FIELD_ADVANCE_SEARCH, FIELD_ADVANCE_SEARCH, null));
    }

    public void setTabOptions(String viewName) throws Exception {
        this.tabList_ = new ArrayList<String>();
        Node viewNode = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getViewByName(viewName, WCMCoreUtils.getSystemSessionProvider());
        this.view_ = NodeLocation.getNodeLocationByNode((Node)viewNode);
        NodeIterator tabs = viewNode.getNodes();
        while (tabs.hasNext()) {
            Node tab = tabs.nextNode();
            if (!this.tabList_.contains(tab.getName())) {
                this.tabList_.add(tab.getName());
            }
            this.setListButton(tab.getName());
        }
        this.setSelectedTab(this.tabList_.get(0));
        String template = viewNode.getProperty("exo:template").getString();
        this.templateName_ = template.substring(template.lastIndexOf("/") + 1);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        uiExplorer.setRenderTemplate(template);
    }

    public boolean hasBackButton() {
        String newLink = ((UIJCRExplorerPortlet)this.getAncestorOfType(UIJCRExplorerPortlet.class)).getBacktoValue();
        if (newLink != null && newLink.length() > 0) {
            this.backLink = newLink;
        }
        return this.backLink != null;
    }

    public String getBackLink() {
        String newLink = ((UIJCRExplorerPortlet)this.getAncestorOfType(UIJCRExplorerPortlet.class)).getBacktoValue();
        if (newLink != null && newLink.length() > 0) {
            this.backLink = URLDecoder.decode(newLink);
        }
        return this.backLink;
    }

    public String getTemplateName() {
        return this.templateName_;
    }

    private void setListButton(String tabName) throws PathNotFoundException, RepositoryException {
        Node tabNode = NodeLocation.getNodeByLocation((NodeLocation)this.view_).getNode(tabName);
        if (tabNode.hasProperty("exo:buttons")) {
            String buttons = tabNode.getProperty("exo:buttons").getString();
            String[] buttonsInTab = StringUtils.split((String)buttons, (String)";");
            for (int j = 0; j < buttonsInTab.length; ++j) {
                String buttonName = buttonsInTab[j].trim();
                buttonsInTab[j] = buttonName = buttonName.substring(0, 1).toUpperCase() + buttonName.substring(1);
            }
            this.actionInTabs_.put(tabName, buttonsInTab);
            this.tabs_.add(buttonsInTab);
        }
    }

    public String[] getActionInTab(String tabName) {
        return this.actionInTabs_.get(tabName);
    }

    public void setSelectedTab(String tabName) {
        this.selectedTabName_ = tabName;
    }

    public boolean isDirectlyDrive() {
        PortletPreferences portletPref = ((UIJCRExplorerPortlet)this.getAncestorOfType(UIJCRExplorerPortlet.class)).getPortletPreferences();
        String usecase = portletPref.getValue("usecase", "").trim();
        return !"selection".equals(usecase);
    }

    public String getSelectedTab() throws Exception {
        if (this.selectedTabName_ == null || this.selectedTabName_.length() == 0) {
            this.setTabOptions(this.tabList_.get(0));
            return this.tabList_.get(0);
        }
        return this.selectedTabName_;
    }

    public List<String> getTabList() {
        return this.tabList_;
    }

    public List<Query> getSavedQueries() throws Exception {
        String userName = Util.getPortalRequestContext().getRemoteUser();
        return ((QueryService)this.getApplicationComponent(QueryService.class)).getQueries(userName, WCMCoreUtils.getSystemSessionProvider());
    }

    public synchronized UIComponent getUIAction(String action) {
        try {
            UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
            HashMap<String, UIJCRExplorer> context = new HashMap<String, UIJCRExplorer>();
            UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
            Node currentNode = uiExplorer.getCurrentNode();
            context.put(UIJCRExplorer.class.getName(), uiExplorer);
            context.put(Node.class.getName(), (UIJCRExplorer)currentNode);
            return manager.addUIExtension("org.exoplatform.ecm.dms.UIActionBar", action, context, (UIContainer)this);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An error occurs while checking the action", (Throwable)e);
            }
            return null;
        }
    }

    public boolean isActionAvailable(String tabName) {
        ArrayList<UIComponent> listActions = new ArrayList<UIComponent>();
        for (String action : this.getActionInTab(tabName)) {
            UIComponent uicomp = this.getUIAction(action);
            if (uicomp == null) continue;
            listActions.add(uicomp);
        }
        return listActions.size() > 0;
    }

    public String getDriveLabel() {
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        DriveData driveData = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getDriveData();
        String id = driveData.getName();
        try {
            return res.getString("Drives.label." + id.replace(".", "").replace(" ", ""));
        }
        catch (MissingResourceException ex) {
            try {
                RepositoryService repoService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
                NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
                String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
                Node groupNode = (Node)WCMCoreUtils.getSystemSessionProvider().getSession(repoService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), repoService.getCurrentRepository()).getItem(groupPath + driveData.getName().replace(".", "/"));
                return groupNode.getProperty("exo:driveLabel").getString();
            }
            catch (Exception e) {
                return id.replace(".", " / ");
            }
        }
    }

    public static class ShowDrivesActionListener
    extends EventListener<UIActionBar> {
        public void execute(Event<UIActionBar> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIActionBar)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
            UIDrivesArea uiDriveArea = (UIDrivesArea)uiWorkingArea.getChild(UIDrivesArea.class);
            if (uiDriveArea.isRendered()) {
                uiDriveArea.setRendered(false);
                ((UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class)).setRendered(true);
            } else {
                uiDriveArea.setRendered(true);
                ((UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class)).setRendered(false);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingArea);
        }
    }

    public static class PreferencesActionListener
    extends EventListener<UIActionBar> {
        public void execute(Event<UIActionBar> event) throws Exception {
            UIActionBar uiActionBar = (UIActionBar)((Object)event.getSource());
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)uiActionBar.getAncestorOfType(UIJCRExplorer.class);
            UIPopupContainer popupAction = (UIPopupContainer)uiJCRExplorer.getChild(UIPopupContainer.class);
            UIPreferencesForm uiPrefForm = (UIPreferencesForm)popupAction.activate(UIPreferencesForm.class, 600);
            uiPrefForm.update(uiJCRExplorer.getPreference());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupAction);
        }
    }

    public static class ChangeTabActionListener
    extends EventListener<UIActionBar> {
        public void execute(Event<UIActionBar> event) throws Exception {
            UIActionBar uiActionBar = (UIActionBar)((Object)event.getSource());
            String selectedTabName = event.getRequestContext().getRequestParameter("objectId");
            uiActionBar.setSelectedTab(selectedTabName);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiActionBar.getAncestorOfType(UIJCRExplorer.class));
        }
    }

    public static class SavedQueriesActionListener
    extends EventListener<UIActionBar> {
        public void execute(Event<UIActionBar> event) throws Exception {
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)((UIActionBar)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiJCRExplorer.getChild(UIPopupContainer.class);
            UISavedQuery uiSavedQuery = (UISavedQuery)((UIActionBar)((Object)event.getSource())).createUIComponent(UISavedQuery.class, null, null);
            uiSavedQuery.setIsQuickSearch(true);
            uiSavedQuery.updateGrid(1);
            UIPopupContainer2.activate((UIComponent)uiSavedQuery, 700, 400);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
        }
    }

    public static class BackToActionListener
    extends EventListener<UIActionBar> {
        public void execute(Event<UIActionBar> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIActionBar)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
            UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
            UIDocumentFormController uiDocumentFormController = (UIDocumentFormController)uiDocumentWorkspace.getChild(UIDocumentFormController.class);
            String backLink = ((UIActionBar)((Object)event.getSource())).getBackLink();
            if (uiDocumentFormController != null) {
                UIDocumentForm uiDocument = (UIDocumentForm)uiDocumentFormController.getChild(UIDocumentForm.class);
                if (uiDocument != null) {
                    uiDocument.releaseLock();
                }
                uiDocumentWorkspace.removeChild(UIDocumentFormController.class);
            } else {
                uiExplorer.cancelAction();
            }
            RequireJS requireJS = event.getRequestContext().getJavascriptManager().getRequireJS();
            requireJS.require("SHARED/ecm-utils", "ecmutil").addScripts("ecmutil.ECMUtils.ajaxRedirect('" + backLink + "');");
        }
    }

    public static class AdvanceSearchActionListener
    extends EventListener<UIActionBar> {
        public void execute(Event<UIActionBar> event) throws Exception {
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)((UIActionBar)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiJCRExplorer.getChild(UIPopupContainer.class);
            UIECMSearch uiECMSearch = (UIECMSearch)((UIActionBar)((Object)event.getSource())).createUIComponent(UIECMSearch.class, null, null);
            UIContentNameSearch contentNameSearch = (UIContentNameSearch)uiECMSearch.findFirstComponentOfType(UIContentNameSearch.class);
            String currentNodePath = uiJCRExplorer.getCurrentNode().getPath();
            contentNameSearch.setLocation(currentNodePath);
            UISimpleSearch uiSimpleSearch = (UISimpleSearch)uiECMSearch.findFirstComponentOfType(UISimpleSearch.class);
            uiSimpleSearch.getUIFormInputInfo("nodePath").setValue((Object)currentNodePath);
            UIPopupContainer2.activate((UIComponent)uiECMSearch, 700, 500);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
        }
    }

    public static class SimpleSearchActionListener
    extends EventListener<UIActionBar> {
        public void execute(Event<UIActionBar> event) throws Exception {
            UIActionBar uiForm = (UIActionBar)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            String text = (String)uiForm.getUIStringInput(UIActionBar.FIELD_SIMPLE_SEARCH).getValue();
            Node currentNode = uiExplorer.getCurrentNode();
            String queryStatement = null;
            queryStatement = "/".equals(currentNode.getPath()) ? UIActionBar.ROOT_SQL_QUERY : StringUtils.replace((String)UIActionBar.SQL_QUERY, (String)"$0", (String)currentNode.getPath());
            queryStatement = StringUtils.replace((String)queryStatement, (String)"$1", (String)text.replaceAll("'", "''"));
            uiExplorer.removeChildById("ViewSearch");
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
            UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
            if (!uiDocumentWorkspace.isRendered()) {
                ((UIDrivesArea)uiWorkingArea.getChild(UIDrivesArea.class)).setRendered(false);
                ((UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class)).setRendered(true);
                uiDocumentWorkspace.setRenderedChild(UIDocumentContainer.class);
            }
            UISearchResult uiSearchResult = (UISearchResult)uiDocumentWorkspace.getChildById(UIDocumentWorkspace.SIMPLE_SEARCH_RESULT);
            long startTime = System.currentTimeMillis();
            uiSearchResult.setQuery(queryStatement, currentNode.getSession().getWorkspace().getName(), "sql", IdentityConstants.SYSTEM.equals(WCMCoreUtils.getRemoteUser()), null);
            uiSearchResult.updateGrid();
            long time = System.currentTimeMillis() - startTime;
            uiSearchResult.setSearchTime(time);
            uiDocumentWorkspace.setRenderedChild(UISearchResult.class);
        }
    }

    public static class SearchActionListener
    extends EventListener<UIActionBar> {
        public void execute(Event<UIActionBar> event) throws Exception {
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)((UIActionBar)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiJCRExplorer.getChild(UIPopupContainer.class);
            UIPopupContainer2.activate(UIECMSearch.class, 700);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
        }
    }
}

