/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application.portlet;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.exoplatform.commons.utils.PortalPrinter;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.resolver.ApplicationResourceResolver;
import org.exoplatform.resolver.PortletResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.StateManager;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.event.Event;

public class PortletApplication
extends WebuiApplication {
    protected static Log log = ExoLogger.getLogger(PortletApplication.class);
    public static final String PORTLET_EVENT_VALUE = "portletEventValue";
    private PortletConfig portletConfig_;
    private String applicationId_;

    public PortletApplication(PortletConfig config) {
        this.portletConfig_ = config;
        PortletContext pcontext = config.getPortletContext();
        String contextName = pcontext.getPortletContextName();
        this.applicationId_ = contextName + "/" + config.getPortletName();
        ApplicationResourceResolver resolver = new ApplicationResourceResolver();
        resolver.addResourceResolver((ResourceResolver)new PortletResourceResolver(pcontext, "app:"));
        resolver.addResourceResolver((ResourceResolver)new PortletResourceResolver(pcontext, "par:"));
        this.setResourceResolver(resolver);
    }

    public String getApplicationId() {
        return this.applicationId_;
    }

    public String getApplicationName() {
        return this.portletConfig_.getPortletName();
    }

    public String getApplicationGroup() {
        return this.portletConfig_.getPortletContext().getPortletContextName();
    }

    public String getApplicationType() {
        return "jsr168Application";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.portletConfig_.getResourceBundle(locale);
    }

    public ResourceBundle getOwnerResourceBundle(String username, Locale locale) {
        return null;
    }

    public String getApplicationInitParam(String name) {
        return this.portletConfig_.getInitParameter(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionRequest req, ActionResponse res) throws Exception {
        WebuiRequestContext parentAppRequestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequestContext context = this.createRequestContext((PortletRequest)req, (PortletResponse)res, parentAppRequestContext);
        WebuiRequestContext.setCurrentInstance((RequestContext)context);
        try {
            for (ApplicationLifecycle lifecycle : this.getApplicationLifecycle()) {
                lifecycle.onStartRequest((Application)this, (RequestContext)context);
            }
            StateManager sm = this.getStateManager();
            UIApplication uiApp = sm.restoreUIRootComponent((WebuiRequestContext)context);
            context.setUIApplication(uiApp);
            uiApp.processDecode((WebuiRequestContext)context);
            if (!context.isResponseComplete() && !context.getProcessRender()) {
                uiApp.processAction((WebuiRequestContext)context);
            }
            sm.storeUIRootComponent((WebuiRequestContext)context);
        }
        finally {
            context.setProcessAction(true);
            WebuiRequestContext.setCurrentInstance((RequestContext)parentAppRequestContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventRequest req, EventResponse res) throws Exception {
        WebuiRequestContext parentAppRequestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequestContext context = this.createRequestContext((PortletRequest)req, (PortletResponse)res, parentAppRequestContext);
        WebuiRequestContext.setCurrentInstance((RequestContext)context);
        try {
            for (ApplicationLifecycle lifecycle : this.getApplicationLifecycle()) {
                lifecycle.onStartRequest((Application)this, (RequestContext)context);
            }
            StateManager sm = this.getStateManager();
            UIApplication uiApp = sm.restoreUIRootComponent((WebuiRequestContext)context);
            context.setUIApplication(uiApp);
            javax.portlet.Event portletEvent = req.getEvent();
            context.setAttribute(PORTLET_EVENT_VALUE, portletEvent.getValue());
            Event uiEvent = uiApp.createEvent(portletEvent.getName(), Event.Phase.PROCESS, (WebuiRequestContext)context);
            uiEvent.broadcast();
            sm.storeUIRootComponent((WebuiRequestContext)context);
        }
        finally {
            WebuiRequestContext.setCurrentInstance((RequestContext)parentAppRequestContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveResource(ResourceRequest req, ResourceResponse res) throws Exception {
        WebuiRequestContext parentAppRequestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequestContext context = this.createRequestContext((PortletRequest)req, (PortletResponse)res, parentAppRequestContext);
        WebuiRequestContext.setCurrentInstance((RequestContext)context);
        try {
            for (ApplicationLifecycle lifecycle : this.getApplicationLifecycle()) {
                lifecycle.onStartRequest((Application)this, (RequestContext)context);
            }
            StateManager sm = this.getStateManager();
            UIApplication uiApp = sm.restoreUIRootComponent((WebuiRequestContext)context);
            context.setUIApplication(uiApp);
            if (uiApp instanceof UIPortletApplication) {
                ((UIPortletApplication)uiApp).serveResource(context);
            }
            sm.storeUIRootComponent((WebuiRequestContext)context);
        }
        finally {
            WebuiRequestContext.setCurrentInstance((RequestContext)parentAppRequestContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RenderRequest req, RenderResponse res) throws Exception {
        WebuiRequestContext parentAppRequestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequestContext context = this.createRequestContext((PortletRequest)req, (PortletResponse)res, parentAppRequestContext);
        WebuiRequestContext.setCurrentInstance((RequestContext)context);
        try {
            if (!context.hasProcessAction()) {
                for (ApplicationLifecycle lifecycle : this.getApplicationLifecycle()) {
                    lifecycle.onStartRequest((Application)this, (RequestContext)context);
                }
            }
            StateManager sm = this.getStateManager();
            UIApplication uiApp = sm.restoreUIRootComponent((WebuiRequestContext)context);
            context.setUIApplication(uiApp);
            if (!context.isResponseComplete()) {
                UIPortletApplication uiPortletApp = (UIPortletApplication)uiApp;
                uiPortletApp.processRender(this, context);
            }
            uiApp.setLastAccessApplication(System.currentTimeMillis());
            sm.storeUIRootComponent((WebuiRequestContext)context);
        }
        finally {
            Safe.close((Closeable)context.getWriter());
            try {
                for (ApplicationLifecycle lifecycle : this.getApplicationLifecycle()) {
                    lifecycle.onEndRequest((Application)this, (RequestContext)context);
                }
            }
            catch (Exception exception) {
                log.error((Object)"Error while trying to call onEndRequest of the portlet ApplicationLifecycle", (Throwable)exception);
            }
            WebuiRequestContext.setCurrentInstance((RequestContext)parentAppRequestContext);
        }
    }

    private PortletRequestContext createRequestContext(PortletRequest req, PortletResponse res, WebuiRequestContext parentAppRequestContext) throws IOException {
        String attributeName = this.getApplicationId() + "$PortletRequest";
        PortletRequestContext context = (PortletRequestContext)((Object)parentAppRequestContext.getAttribute(attributeName));
        PortalPrinter w = null;
        if (res instanceof RenderResponse) {
            RenderResponse renderRes = (RenderResponse)res;
            renderRes.setContentType("text/html; charset=UTF-8");
            w = new PortalPrinter(renderRes.getPortletOutputStream(), true, 0);
        }
        if (context != null) {
            context.init((Writer)w, req, res);
        } else {
            context = new PortletRequestContext((RequestContext)parentAppRequestContext, this, (Writer)w, req, res);
            parentAppRequestContext.setAttribute(attributeName, (Object)context);
        }
        return context;
    }
}

