/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application.portlet;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.PortletConfigRegistry;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.Application;
import org.exoplatform.webui.application.portlet.PortletApplication;
import org.exoplatform.webui.application.portlet.PortletApplicationFactory;

public class PortletApplicationController
extends GenericPortlet {
    protected static Log log;
    private static PortletApplicationFactory appProvider;
    private String applicationId_;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext pcontext = config.getPortletContext();
        String contextName = pcontext.getPortletContextName();
        this.applicationId_ = contextName + "/" + config.getPortletName();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortletConfigRegistry registry = (PortletConfigRegistry)container.getComponentInstanceOfType(PortletConfigRegistry.class);
        registry.putPortletConfig(config.getPortletName(), config);
    }

    public void processAction(ActionRequest req, ActionResponse res) throws PortletException, IOException {
        try {
            this.getPortletApplication().processAction(req, res);
        }
        catch (Exception ex) {
            log.error((Object)"Error while processing action in the porlet", (Throwable)ex);
        }
    }

    public void processEvent(EventRequest req, EventResponse res) {
        try {
            this.getPortletApplication().processEvent(req, res);
        }
        catch (Exception ex) {
            log.error((Object)"Error while processing event in the porlet", (Throwable)ex);
        }
    }

    public void serveResource(ResourceRequest req, ResourceResponse res) throws PortletException, IOException {
        try {
            this.getPortletApplication().serveResource(req, res);
        }
        catch (Exception ex) {
            log.error((Object)"Error while serving resource in the porlet", (Throwable)ex);
        }
    }

    public void render(RenderRequest req, RenderResponse res) throws PortletException, IOException {
        try {
            res.setTitle(this.getTitle(req));
            this.getPortletApplication().render(req, res);
        }
        catch (Exception ex) {
            log.error((Object)"Error while rendering the porlet", (Throwable)ex);
        }
    }

    private PortletApplication getPortletApplication() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        WebAppController controller = (WebAppController)container.getComponentInstanceOfType(WebAppController.class);
        PortletApplication application = (PortletApplication)controller.getApplication(this.applicationId_);
        if (application == null) {
            application = appProvider != null ? (PortletApplication)appProvider.createApplication(this.getPortletConfig()) : new PortletApplication(this.getPortletConfig());
            application.onInit();
            application = (PortletApplication)controller.addApplication((Application)application);
        }
        return application;
    }

    public void destroy() {
        ExoContainer rootContainer = ExoContainerContext.getTopContainer();
        List containers = rootContainer.getComponentInstancesOfType(ExoContainer.class);
        containers.add(rootContainer);
        try {
            for (ExoContainer container : containers) {
                PortletApplication application;
                ExoContainerContext.setCurrentContainer((ExoContainer)container);
                WebAppController controller = (WebAppController)container.getComponentInstanceOfType(WebAppController.class);
                if (controller == null || (application = (PortletApplication)controller.getApplication(this.applicationId_)) == null) continue;
                application.onDestroy();
                controller.removeApplication(this.applicationId_);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error while destroying the porlet", (Throwable)ex);
        }
    }

    static {
        block0: {
            PortletApplicationFactory factory;
            log = ExoLogger.getLogger(PortletApplicationController.class);
            ServiceLoader<PortletApplicationFactory> loader = ServiceLoader.load(PortletApplicationFactory.class);
            Iterator<PortletApplicationFactory> i$ = loader.iterator();
            if (!i$.hasNext()) break block0;
            appProvider = factory = i$.next();
        }
    }
}

