/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.MeasurementType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;

@MBean(objectName="CacheLoader", description="Component that handles loading entries from a CacheStore into memory.")
public class CacheLoaderInterceptor
extends JmxStatsCommandInterceptor {
    private final AtomicLong cacheLoads = new AtomicLong(0L);
    private final AtomicLong cacheMisses = new AtomicLong(0L);
    protected CacheLoaderManager clm;
    protected CacheNotifier notifier;
    protected CacheLoader loader;
    private EntryFactory entryFactory;
    private static final Log log = LogFactory.getLog(CacheLoaderInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    protected void injectDependencies(CacheLoaderManager clm, EntryFactory entryFactory, CacheNotifier notifier) {
        this.clm = clm;
        this.notifier = notifier;
        this.entryFactory = entryFactory;
    }

    @Start(priority=15)
    protected void startInterceptor() {
        this.loader = this.clm.getCacheLoader();
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object key = command.getKey();
        if (key != null) {
            this.loadIfNeeded(ctx, key, false, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object key = command.getKey();
        if (key != null) {
            this.loadIfNeededAndUpdateStats(ctx, key, true, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        Object[] keys = command.getKeys();
        if (keys != null && keys.length > 0) {
            for (Object key : command.getKeys()) {
                this.loadIfNeeded(ctx, key, false, command);
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object key = command.getKey();
        if (key != null) {
            this.loadIfNeededAndUpdateStats(ctx, key, false, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object key = command.getKey();
        if (key != null) {
            this.loadIfNeededAndUpdateStats(ctx, key, false, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    protected boolean forceLoad(Object key, Set<Flag> flags) {
        return false;
    }

    private boolean loadIfNeeded(InvocationContext ctx, Object key, boolean isRetrieval, FlagAffectedCommand cmd) throws Throwable {
        if (cmd.hasFlag(Flag.SKIP_CACHE_STORE) || cmd.hasFlag(Flag.SKIP_CACHE_LOAD)) {
            return false;
        }
        if (!(isRetrieval || ctx.isOriginLocal() || this.forceLoad(key, cmd.getFlags()))) {
            return false;
        }
        CacheEntry e = ctx.lookupEntry(key);
        if (e == null || e.isNull() || e.getValue() == null) {
            InternalCacheEntry loaded = this.loader.load(key);
            if (loaded != null) {
                MVCCEntry mvccEntry = this.entryFactory.wrapEntryForPut(ctx, key, loaded, false);
                this.recordLoadedEntry(ctx, key, mvccEntry, loaded);
                return true;
            }
            return false;
        }
        return true;
    }

    private MVCCEntry recordLoadedEntry(InvocationContext ctx, Object key, MVCCEntry entry, InternalCacheEntry loadedEntry) throws Exception {
        boolean entryExists;
        boolean bl = entryExists = loadedEntry != null;
        if (log.isTraceEnabled()) {
            log.trace("Entry exists in loader? " + entryExists);
        }
        if (this.getStatisticsEnabled()) {
            if (entryExists) {
                this.cacheLoads.incrementAndGet();
            } else {
                this.cacheMisses.incrementAndGet();
            }
        }
        if (entryExists) {
            Object value = loadedEntry.getValue();
            this.sendNotification(key, value, true, ctx);
            entry.setValue(value);
            entry.setLifespan(loadedEntry.getLifespan());
            entry.setMaxIdle(loadedEntry.getMaxIdle());
            entry.setValid(true);
            this.sendNotification(key, value, false, ctx);
        }
        return entry;
    }

    protected void sendNotification(Object key, Object value, boolean pre, InvocationContext ctx) {
        this.notifier.notifyCacheEntryLoaded(key, value, pre, ctx);
    }

    private void loadIfNeededAndUpdateStats(InvocationContext ctx, Object key, boolean isRetrieval, FlagAffectedCommand cmd) throws Throwable {
        boolean found = this.loadIfNeeded(ctx, key, isRetrieval, cmd);
        if (!found && this.getStatisticsEnabled()) {
            this.cacheMisses.incrementAndGet();
        }
    }

    @ManagedAttribute(description="Number of entries loaded from cache store")
    @Metric(displayName="Number of cache store loads", measurementType=MeasurementType.TRENDSUP)
    public long getCacheLoaderLoads() {
        return this.cacheLoads.get();
    }

    @ManagedAttribute(description="Number of entries that did not exist in cache store")
    @Metric(displayName="Number of cache store load misses", measurementType=MeasurementType.TRENDSUP)
    public long getCacheLoaderMisses() {
        return this.cacheMisses.get();
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component")
    @Operation(displayName="Reset Statistics")
    public void resetStatistics() {
        this.cacheLoads.set(0L);
        this.cacheMisses.set(0L);
    }
}

