/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.impl;

import java.util.Stack;
import org.xwiki.rendering.wikimodel.IWemListener;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;
import org.xwiki.rendering.wikimodel.WikiStyle;
import org.xwiki.rendering.wikimodel.impl.IWikiScannerContext;
import org.xwiki.rendering.wikimodel.impl.InlineState;
import org.xwiki.rendering.wikimodel.impl.InternalWikiScannerContext;
import org.xwiki.rendering.wikimodel.util.ISectionListener;
import org.xwiki.rendering.wikimodel.util.SectionBuilder;
import org.xwiki.rendering.wikimodel.util.SectionListener;

public class WikiScannerContext
implements IWikiScannerContext {
    protected final IWemListener fListener;
    protected SectionBuilder<WikiParameters> fSectionBuilder;
    protected final Stack<IWikiScannerContext> fStack = new Stack();

    public WikiScannerContext(IWemListener listener) {
        this.fListener = listener;
        this.fSectionBuilder = new SectionBuilder<WikiParameters>(new SectionListener<WikiParameters>(){

            @Override
            public void beginDocument(ISectionListener.IPos<WikiParameters> pos) {
                WikiParameters params = pos.getData();
                WikiScannerContext.this.fListener.beginDocument(params);
                this.beginSection(pos);
                this.beginSectionContent(pos);
            }

            @Override
            public void beginSection(ISectionListener.IPos<WikiParameters> pos) {
                WikiParameters params = pos.getData();
                int docLevel = pos.getDocumentLevel();
                int headerLevel = pos.getHeaderLevel();
                WikiScannerContext.this.fListener.beginSection(docLevel, headerLevel, params);
            }

            @Override
            public void beginSectionContent(ISectionListener.IPos<WikiParameters> pos) {
                WikiScannerContext.this.fListener.beginSectionContent(pos.getDocumentLevel(), pos.getHeaderLevel(), pos.getData());
            }

            @Override
            public void beginSectionHeader(ISectionListener.IPos<WikiParameters> pos) {
                WikiScannerContext.this.fListener.beginHeader(pos.getHeaderLevel(), pos.getData());
            }

            @Override
            public void endDocument(ISectionListener.IPos<WikiParameters> pos) {
                this.endSectionContent(pos);
                this.endSection(pos);
                WikiParameters params = pos.getData();
                WikiScannerContext.this.fListener.endDocument(params);
            }

            @Override
            public void endSection(ISectionListener.IPos<WikiParameters> pos) {
                WikiParameters params = pos.getData();
                int docLevel = pos.getDocumentLevel();
                int headerLevel = pos.getHeaderLevel();
                WikiScannerContext.this.fListener.endSection(docLevel, headerLevel, params);
            }

            @Override
            public void endSectionContent(ISectionListener.IPos<WikiParameters> pos) {
                WikiScannerContext.this.fListener.endSectionContent(pos.getDocumentLevel(), pos.getHeaderLevel(), pos.getData());
            }

            @Override
            public void endSectionHeader(ISectionListener.IPos<WikiParameters> pos) {
                WikiScannerContext.this.fListener.endHeader(pos.getHeaderLevel(), pos.getData());
            }
        });
    }

    public IWemListener getfListener() {
        return this.fListener;
    }

    @Override
    public void beginDocument() {
        InternalWikiScannerContext context = this.pushContext();
        context.beginDocument();
    }

    @Override
    public void beginDocument(WikiParameters params) {
        InternalWikiScannerContext context = this.pushContext();
        context.beginDocument(params);
    }

    @Override
    public void beginFormat(WikiParameters params) {
        this.getContext().beginFormat(params);
    }

    @Override
    public void beginFormat(WikiStyle wikiStyle) {
        this.getContext().beginFormat(wikiStyle);
    }

    @Override
    public void beginHeader(int level) {
        this.getContext().beginHeader(level);
    }

    @Override
    public void beginHeader(int level, WikiParameters params) {
        this.getContext().beginHeader(level, params);
    }

    @Override
    public void beginInfo(String type, WikiParameters params) {
        this.getContext().beginInfo(type, params);
    }

    @Override
    public void beginList() {
        this.getContext().beginList();
    }

    @Override
    public void beginList(WikiParameters params) {
        this.getContext().beginList(params);
    }

    @Override
    public void beginListItem(String item) {
        this.getContext().beginListItem(item);
    }

    @Override
    public void beginListItem(String item, WikiParameters params) {
        this.getContext().beginListItem(item, params);
    }

    @Override
    public void beginParagraph() {
        this.getContext().beginParagraph();
    }

    @Override
    public void beginParagraph(WikiParameters params) {
        this.getContext().beginParagraph(params);
    }

    @Override
    public void beginPropertyBlock(String property, boolean doc) {
        this.getContext().beginPropertyBlock(property, doc);
    }

    @Override
    public void beginPropertyInline(String str) {
        this.getContext().beginPropertyInline(str);
    }

    @Override
    public void beginQuot() {
        this.getContext().beginQuot();
    }

    @Override
    public void beginQuot(WikiParameters params) {
        this.getContext().beginQuot(params);
    }

    @Override
    public void beginQuotLine(int depth) {
        this.getContext().beginQuotLine(depth);
    }

    @Override
    public void beginTable() {
        this.getContext().beginTable();
    }

    @Override
    public void beginTable(WikiParameters params) {
        this.getContext().beginTable(params);
    }

    @Override
    public void beginTableCell(boolean headCell) {
        this.getContext().beginTableCell(headCell);
    }

    @Override
    public void beginTableCell(boolean headCell, WikiParameters params) {
        this.getContext().beginTableCell(headCell, params);
    }

    @Override
    public void beginTableRow(boolean headCell) {
        this.getContext().beginTableRow(headCell);
    }

    @Override
    public void beginTableRow(boolean head, WikiParameters rowParams, WikiParameters cellParams) {
        this.getContext().beginTableRow(head, rowParams, cellParams);
    }

    @Override
    public void beginTableRow(WikiParameters rowParams) {
        this.getContext().beginTableRow(rowParams);
    }

    @Override
    public boolean canApplyDefintionSplitter() {
        return this.getContext().canApplyDefintionSplitter();
    }

    @Override
    public boolean checkFormatStyle(WikiStyle style) {
        return this.getContext().checkFormatStyle(style);
    }

    @Override
    public void closeBlock() {
        this.getContext().closeBlock();
    }

    @Override
    public void endDocument() {
        this.getContext().endDocument();
        this.fStack.pop();
    }

    @Override
    public void endFormat(WikiParameters params) {
        this.getContext().endFormat(params);
    }

    @Override
    public void endFormat(WikiStyle wikiStyle) {
        this.getContext().endFormat(wikiStyle);
    }

    @Override
    public void endHeader() {
        this.getContext().endHeader();
    }

    @Override
    public void endInfo() {
        this.getContext().endInfo();
    }

    @Override
    public void endList() {
        this.getContext().endList();
    }

    @Override
    public void endListItem() {
        this.getContext().endListItem();
    }

    @Override
    public void endParagraph() {
        this.getContext().endParagraph();
    }

    @Override
    public void endPropertyBlock() {
        this.getContext().endPropertyBlock();
    }

    @Override
    public void endPropertyInline() {
        this.getContext().endPropertyInline();
    }

    @Override
    public void endQuot() {
        this.getContext().endQuot();
    }

    @Override
    public void endQuotLine() {
        this.getContext().endQuotLine();
    }

    @Override
    public void endTable() {
        this.getContext().endTable();
    }

    @Override
    public void endTableCell() {
        this.getContext().endTableCell();
    }

    @Override
    public void endTableExplicit() {
        this.getContext().endTableExplicit();
    }

    @Override
    public void endTableRow() {
        this.getContext().endTableRow();
    }

    public IWikiScannerContext getContext() {
        if (!this.fStack.isEmpty()) {
            return this.fStack.peek();
        }
        InternalWikiScannerContext context = this.newInternalContext();
        this.fStack.push(context);
        return context;
    }

    @Override
    public InlineState getInlineState() {
        return this.getContext().getInlineState();
    }

    @Override
    public int getTableCellCounter() {
        return this.getContext().getTableCellCounter();
    }

    @Override
    public int getTableRowCounter() {
        return this.getContext().getTableRowCounter();
    }

    @Override
    public boolean isInDefinitionList() {
        return this.getContext().isInDefinitionList();
    }

    @Override
    public boolean isInDefinitionTerm() {
        return this.getContext().isInDefinitionTerm();
    }

    @Override
    public boolean isInHeader() {
        return this.getContext().isInHeader();
    }

    @Override
    public boolean isInInlineProperty() {
        return this.getContext().isInInlineProperty();
    }

    @Override
    public boolean isInList() {
        return this.getContext().isInList();
    }

    @Override
    public boolean isInTable() {
        return this.getContext().isInTable();
    }

    @Override
    public boolean isInTableCell() {
        return this.getContext().isInTableCell();
    }

    @Override
    public boolean isInTableRow() {
        return this.getContext().isInTableRow();
    }

    protected InternalWikiScannerContext newInternalContext() {
        InternalWikiScannerContext context = new InternalWikiScannerContext(this.fSectionBuilder, this.fListener);
        return context;
    }

    @Override
    public void onDefinitionListItemSplit() {
        this.getContext().onDefinitionListItemSplit();
    }

    @Override
    public void onEmptyLines(int count) {
        this.getContext().onEmptyLines(count);
    }

    @Override
    public void onEscape(String str) {
        this.getContext().onEscape(str);
    }

    @Override
    public void onExtensionBlock(String extensionName, WikiParameters params) {
        this.getContext().onExtensionBlock(extensionName, params);
    }

    @Override
    public void onExtensionInline(String extensionName, WikiParameters params) {
        this.getContext().onExtensionInline(extensionName, params);
    }

    @Override
    public void onFormat(WikiParameters params) {
        this.getContext().onFormat(params);
    }

    @Override
    public void onFormat(WikiStyle wikiStyle) {
        this.getContext().onFormat(wikiStyle);
    }

    @Override
    public void onFormat(WikiStyle wikiStyle, boolean forceClose) {
        this.getContext().onFormat(wikiStyle, forceClose);
    }

    @Override
    public void onHorizontalLine() {
        this.getContext().onHorizontalLine();
    }

    @Override
    public void onHorizontalLine(WikiParameters params) {
        this.getContext().onHorizontalLine(params);
    }

    @Override
    public void onImage(String ref) {
        this.getContext().onImage(ref);
    }

    @Override
    public void onImage(WikiReference ref) {
        this.getContext().onImage(ref);
    }

    @Override
    public void onLineBreak() {
        this.getContext().onLineBreak();
    }

    @Override
    public void onMacro(String name, WikiParameters params, String content) {
        this.getContext().onMacro(name, params, content);
    }

    @Override
    public void onMacro(String macroName, WikiParameters params, String content, boolean inline) {
        if (inline) {
            this.onMacroInline(macroName, params, content);
        } else {
            this.onMacroBlock(macroName, params, content);
        }
    }

    @Override
    public void onMacroBlock(String macroName, WikiParameters params, String content) {
        this.getContext().onMacroBlock(macroName, params, content);
    }

    @Override
    public void onMacroInline(String macroName, WikiParameters params, String content) {
        this.getContext().onMacroInline(macroName, params, content);
    }

    @Override
    public void onNewLine() {
        this.getContext().onNewLine();
    }

    @Override
    public void onQuotLine(int depth) {
        this.getContext().onQuotLine(depth);
    }

    @Override
    public void onReference(String ref) {
        this.getContext().onReference(ref);
    }

    @Override
    public void onReference(WikiReference ref) {
        this.getContext().onReference(ref);
    }

    @Override
    public void onSpace(String str) {
        this.getContext().onSpace(str);
    }

    @Override
    public void onSpecialSymbol(String str) {
        this.getContext().onSpecialSymbol(str);
    }

    @Override
    public void onTableCaption(String str) {
        this.getContext().onTableCaption(str);
    }

    @Override
    public void onTableCell(boolean headCell) {
        this.getContext().onTableCell(headCell);
    }

    @Override
    public void onTableCell(boolean head, WikiParameters cellParams) {
        this.getContext().onTableCell(head, cellParams);
    }

    @Override
    public void onTableRow(WikiParameters params) {
        this.getContext().onTableRow(params);
    }

    @Override
    public void onVerbatim(String str, boolean inline) {
        this.getContext().onVerbatim(str, inline);
    }

    @Override
    public void onVerbatim(String str, boolean inline, WikiParameters params) {
        this.getContext().onVerbatim(str, inline, params);
    }

    @Override
    public void onVerbatim(String str, WikiParameters params) {
        this.getContext().onVerbatim(str, params);
    }

    @Override
    public void onWord(String str) {
        this.getContext().onWord(str);
    }

    private InternalWikiScannerContext pushContext() {
        InternalWikiScannerContext context = (InternalWikiScannerContext)this.getContext();
        if (context != null) {
            context.checkBlockContainer();
            context.closeFormat();
        }
        context = this.newInternalContext();
        this.fStack.push(context);
        return context;
    }
}

