/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiStore;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.mow.core.api.wiki.GroupWikiContainer;
import org.exoplatform.wiki.mow.core.api.wiki.HelpPage;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PortalWikiContainer;
import org.exoplatform.wiki.mow.core.api.wiki.UserWikiContainer;
import org.exoplatform.wiki.mow.core.api.wiki.WikiContainer;

@PrimaryType(name="wiki:store")
public abstract class WikiStoreImpl
implements WikiStore {
    private ChromatticSession session;

    @Override
    public void setSession(ChromatticSession chromatticSession) {
        this.session = chromatticSession;
    }

    @Override
    public ChromatticSession getSession() {
        return this.session;
    }

    @Override
    public void addWiki(WikiType wikiType, String name) {
        this.getWikiContainer(wikiType).addWiki(name);
    }

    @Override
    public Wiki getWiki(WikiType wikiType, String name) {
        return this.getWikiContainer(wikiType).getWiki(name, true);
    }

    @Override
    public Collection<Wiki> getWikis() {
        CopyOnWriteArraySet<Wiki> col = new CopyOnWriteArraySet<Wiki>();
        col.addAll(this.getPortalWikiContainer().getAllWikis());
        col.addAll(this.getGroupWikiContainer().getAllWikis());
        col.addAll(this.getUserWikiContainer().getAllWikis());
        return col;
    }

    @Override
    public <W extends Wiki> WikiContainer<W> getWikiContainer(WikiType wikiType) {
        if (wikiType == WikiType.PORTAL) {
            return this.getPortalWikiContainer();
        }
        if (wikiType == WikiType.GROUP) {
            return this.getGroupWikiContainer();
        }
        if (wikiType == WikiType.USER) {
            return this.getUserWikiContainer();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Create
    public abstract PageImpl createPage();

    @Create
    public abstract HelpPage createHelpPage();

    public HelpPage getHelpPagesContainer() {
        HelpPage page = this.getHelpPageByChromattic();
        if (page == null) {
            page = this.createHelpPage();
            this.setHelpPageByChromattic(page);
        }
        return page;
    }

    @Override
    public PageImpl getDraftNewPagesContainer() {
        PageImpl page = this.getDraftNewPagesContainerByChromattic();
        if (page == null) {
            page = this.createPage();
            this.setDraftNewPagesContainerByChromattic(page);
        }
        return page;
    }

    @OneToOne
    @Owner
    @MappedBy(value="EmotionIconsPage")
    public abstract PageImpl getEmotionIconsPage();

    @OneToOne
    @Owner
    @MappedBy(value="portalwikis")
    protected abstract PortalWikiContainer getPortalWikiContainerByChromattic();

    protected abstract void setPortalWikiContainerByChromattic(PortalWikiContainer var1);

    @Create
    protected abstract PortalWikiContainer createPortalWikiContainer();

    @OneToOne
    @Owner
    @MappedBy(value="groupwikis")
    protected abstract GroupWikiContainer getGroupWikiContainerByChromattic();

    protected abstract void setGroupWikiContainerByChromattic(GroupWikiContainer var1);

    @Create
    protected abstract GroupWikiContainer createGroupWikiContainer();

    @OneToOne
    @Owner
    @MappedBy(value="userwikis")
    protected abstract UserWikiContainer getUserWikiContainerByChromattic();

    protected abstract void setUserWikiContainerByChromattic(UserWikiContainer var1);

    @Create
    protected abstract UserWikiContainer createUserWikiContainer();

    @OneToOne
    @Owner
    @MappedBy(value="helppages")
    protected abstract HelpPage getHelpPageByChromattic();

    protected abstract void setHelpPageByChromattic(HelpPage var1);

    @OneToOne
    @Owner
    @MappedBy(value="draftNewPages")
    protected abstract PageImpl getDraftNewPagesContainerByChromattic();

    protected abstract void setDraftNewPagesContainerByChromattic(PageImpl var1);

    private PortalWikiContainer getPortalWikiContainer() {
        PortalWikiContainer portalWikiContainer = this.getPortalWikiContainerByChromattic();
        if (portalWikiContainer == null) {
            portalWikiContainer = this.createPortalWikiContainer();
            this.setPortalWikiContainerByChromattic(portalWikiContainer);
        }
        return portalWikiContainer;
    }

    private GroupWikiContainer getGroupWikiContainer() {
        GroupWikiContainer groupWikiContainer = this.getGroupWikiContainerByChromattic();
        if (groupWikiContainer == null) {
            groupWikiContainer = this.createGroupWikiContainer();
            this.setGroupWikiContainerByChromattic(groupWikiContainer);
        }
        return groupWikiContainer;
    }

    private UserWikiContainer getUserWikiContainer() {
        UserWikiContainer userWikiContainer = this.getUserWikiContainerByChromattic();
        if (userWikiContainer == null) {
            userWikiContainer = this.createUserWikiContainer();
            this.setUserWikiContainerByChromattic(userWikiContainer);
        }
        return userWikiContainer;
    }
}

