/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.List;

final class ClosureOptimizePrimitives
implements CompilerPass {
    private final AbstractCompiler compiler;

    ClosureOptimizePrimitives(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        FindObjectCreateCalls pass = new FindObjectCreateCalls();
        NodeTraversal.traverse(this.compiler, root, pass);
        this.processObjectCreateCalls(pass.callNodes);
    }

    private void processObjectCreateCalls(List<Node> callNodes) {
        for (Node callNode : callNodes) {
            Node curParam = callNode.getFirstChild().getNext();
            if (!this.canOptimizeObjectCreate(curParam)) continue;
            Node objNode = new Node(64).copyInformationFrom(callNode);
            while (curParam != null) {
                Node keyNode = curParam;
                Node valueNode = curParam.getNext();
                curParam = valueNode.getNext();
                callNode.removeChild(keyNode);
                callNode.removeChild(valueNode);
                if (keyNode.getType() != 40) {
                    keyNode = Node.newString(NodeUtil.getStringValue(keyNode)).copyInformationFrom(keyNode);
                }
                keyNode.setQuotedString();
                keyNode.addChildToBack(valueNode);
                objNode.addChildToBack(keyNode);
            }
            callNode.getParent().replaceChild(callNode, objNode);
            this.compiler.reportCodeChange();
        }
    }

    private boolean canOptimizeObjectCreate(Node firstParam) {
        for (Node curParam = firstParam; curParam != null; curParam = curParam.getNext()) {
            if (curParam.getType() != 40 && curParam.getType() != 39) {
                return false;
            }
            if ((curParam = curParam.getNext()) != null) continue;
            return false;
        }
        return true;
    }

    private class FindObjectCreateCalls
    extends NodeTraversal.AbstractPostOrderCallback {
        List<Node> callNodes = Lists.newArrayList();

        private FindObjectCreateCalls() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            String fnName;
            if (n.isCall() && ("goog$object$create".equals(fnName = n.getFirstChild().getQualifiedName()) || "goog.object.create".equals(fnName))) {
                this.callNodes.add(n);
            }
        }
    }
}

