/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.mozilla.rhino.json;

import com.google.javascript.jscomp.mozilla.rhino.Kit;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonLexer {
    private Token currentToken;
    private int offset;
    private int beginLexeme;
    private int endLexeme;
    private char[] input;
    private CharSequence seq;
    public static final Token[] VALUE_START_TOKENS = new Token[]{Token.NULL, Token.BOOLEAN, Token.NUMBER, Token.STRING, Token.OPEN_BRACKET, Token.OPEN_BRACE};

    public JsonLexer(String input) {
        this.reset(input);
    }

    public void reset(String input) {
        this.seq = input;
        this.input = input.toCharArray();
        this.beginLexeme = 0;
        this.endLexeme = 0;
        this.offset = 0;
        this.currentToken = null;
    }

    public boolean moveNext() {
        this.eatWhitespace();
        CharSequence rest = this.seq.subSequence(this.offset, this.seq.length());
        return this.eatToken(Token.OPEN_BRACE, rest) || this.eatToken(Token.CLOSE_BRACE, rest) || this.eatToken(Token.OPEN_BRACKET, rest) || this.eatToken(Token.CLOSE_BRACKET, rest) || this.eatToken(Token.COMMA, rest) || this.eatToken(Token.COLON, rest) || this.eatToken(Token.NULL, rest) || this.eatToken(Token.BOOLEAN, rest) || this.eatToken(Token.NUMBER, rest) || this.eatToken(Token.STRING, rest);
    }

    public String getLexeme() {
        return new String(this.input, this.beginLexeme, this.endLexeme - this.beginLexeme).trim();
    }

    public Token getToken() {
        return this.currentToken;
    }

    public long getOffset() {
        return this.offset;
    }

    private static Number toNumber(String lexeme) {
        try {
            return Integer.parseInt(lexeme);
        }
        catch (NumberFormatException exi) {
            try {
                return Long.parseLong(lexeme);
            }
            catch (NumberFormatException exl) {
                BigDecimal decimal = new BigDecimal(lexeme);
                double doubleValue = decimal.doubleValue();
                if (doubleValue == Double.POSITIVE_INFINITY || doubleValue == Double.NEGATIVE_INFINITY || new BigDecimal(doubleValue).compareTo(decimal) != 0) {
                    return decimal;
                }
                return doubleValue;
            }
        }
    }

    private static String unescape(String lexeme) {
        char[] escaped = lexeme.toCharArray();
        int start = 0;
        int end = escaped.length - 1;
        while (escaped[start] != '\"') {
            ++start;
        }
        while (escaped[end] != '\"') {
            --end;
        }
        StringBuffer buffer = new StringBuffer(end - ++start);
        boolean escaping = false;
        for (int i = start; i < end; ++i) {
            char c = escaped[i];
            if (escaping) {
                switch (c) {
                    case '\"': {
                        buffer.append('\"');
                        break;
                    }
                    case '\\': {
                        buffer.append('\\');
                        break;
                    }
                    case '/': {
                        buffer.append('/');
                        break;
                    }
                    case 'b': {
                        buffer.append('\b');
                        break;
                    }
                    case 'f': {
                        buffer.append('\f');
                        break;
                    }
                    case 'n': {
                        buffer.append('\n');
                        break;
                    }
                    case 'r': {
                        buffer.append('\r');
                        break;
                    }
                    case 't': {
                        buffer.append('\t');
                        break;
                    }
                    case 'u': {
                        int codePoint = Integer.parseInt(new String(escaped, i + 1, 4), 16);
                        buffer.appendCodePoint(codePoint);
                        i += 4;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal escape sequence: '\\" + c + "'");
                    }
                }
                escaping = false;
                continue;
            }
            if (c == '\\') {
                escaping = true;
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private boolean eatToken(Token token, CharSequence rest) {
        this.beginLexeme();
        int eaten = token.eat(rest);
        if (eaten == 0) {
            return false;
        }
        this.offset += eaten;
        this.endLexeme(token);
        return true;
    }

    private void eatWhitespace() {
        char c;
        while (!(this.finished() || (c = this.input[this.offset]) != ' ' && c != '\t' && c != '\r' && c != '\n')) {
            ++this.offset;
        }
    }

    private void beginLexeme() {
        this.beginLexeme = this.offset;
        this.endLexeme = this.offset;
    }

    private void endLexeme(Token token) {
        this.endLexeme = this.offset;
        this.currentToken = token;
    }

    public boolean finished() {
        return this.offset >= this.input.length;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Token {
        NULL("null"),
        BOOLEAN("true|false"){

            public Boolean evaluate(String lexeme) {
                return Boolean.valueOf(lexeme);
            }
        }
        ,
        NUMBER("-?(0|[1-9]\\d*)(\\.\\d+)?([eE][-+]?\\d+)?"){

            public Number evaluate(String lexeme) {
                return JsonLexer.toNumber(lexeme);
            }
        }
        ,
        STRING("\"([^\\\\\"\\x00-\\x1F]|\\\\([\"/\\\\bfnrt]|u[a-fA-F0-9]{4}))*\""){

            public String evaluate(String lexeme) {
                return JsonLexer.unescape(lexeme);
            }
        }
        ,
        OPEN_BRACKET("\\["),
        CLOSE_BRACKET("]"),
        OPEN_BRACE("\\{"),
        CLOSE_BRACE("}"),
        COMMA(","),
        COLON(":");

        private Pattern pattern;

        private Token(String patternString) {
            this.pattern = Pattern.compile(patternString);
        }

        public final int eat(CharSequence rest) {
            Matcher matcher = this.pattern.matcher(rest);
            return matcher.lookingAt() ? matcher.end() : 0;
        }

        public <T> T evaluate(String lexeme) {
            throw Kit.codeBug(this.toString() + " tokens to not represent a complete JSON value");
        }
    }
}

