/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api.workspace;

import java.util.HashMap;
import java.util.Map;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.gatein.mop.api.content.CustomizationContext;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.WorkspaceObject;
import org.gatein.mop.core.api.AttributesImpl;
import org.gatein.mop.core.api.ModelImpl;
import org.gatein.mop.core.api.workspace.PageImpl;
import org.gatein.mop.core.api.workspace.SiteImpl;
import org.gatein.mop.core.api.workspace.UIWindowImpl;
import org.gatein.mop.core.api.workspace.WorkspaceCustomizationContextImpl;
import org.gatein.mop.core.api.workspace.WorkspaceImpl;
import org.gatein.mop.spi.AdapterLifeCycle;

@NamingPrefix(value="mop")
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@PrimaryType(name="mop:workspaceobject")
public abstract class WorkspaceObjectImpl
implements WorkspaceObject {
    public ModelImpl model;
    private Map<Class<?>, Object> adapters;

    @Name
    public abstract String getNodeName();

    public abstract void setNodeName(String var1);

    @Id
    public abstract String getObjectId();

    @OneToOne
    @MappedBy(value="mop:attributes")
    @Owner
    public abstract AttributesImpl getAttributes();

    public final <A> A adapt(Class<A> adapterType) {
        Object adapter;
        if (this.adapters != null && (adapter = this.adapters.get(adapterType)) != null) {
            return (A)adapter;
        }
        if (this.model.isAdaptable(adapterType)) {
            AdapterLifeCycle<Object, A> lifeCycle = this.model.getAdapter(this, adapterType);
            if (lifeCycle != null) {
                if (this.adapters == null) {
                    this.adapters = new HashMap();
                }
                adapter = lifeCycle.create((Object)this, adapterType);
                this.adapters.put(adapterType, adapter);
            } else {
                adapter = null;
            }
        } else {
            adapter = this.getMixin(adapterType, true);
        }
        return (A)adapter;
    }

    public final <A> boolean isAdapted(Class<A> adapterType) {
        if (this.adapters != null && this.adapters.containsKey(adapterType)) {
            return true;
        }
        if (this.model.isAdaptable(adapterType)) {
            return false;
        }
        return this.getMixin(adapterType, false) != null;
    }

    public <A> void removeAdapter(Class<A> adapterType) {
        if (this.model.isAdaptable(adapterType)) {
            Object adapter;
            if (this.adapters != null && (adapter = this.adapters.remove(adapterType)) != null) {
                AdapterLifeCycle<Object, A> lifeCycle = this.model.getAdapter(this, adapterType);
                lifeCycle.destroy(adapter, (Object)this, adapterType);
            }
        } else {
            this.removeMixin(adapterType);
        }
    }

    private <A> A getMixin(Class<A> type, boolean create) {
        ChromatticSession session = this.model.getSession();
        Object a = session.getEmbedded((Object)this, type);
        if (a == null && create) {
            a = session.create(type);
            session.setEmbedded((Object)this, type, a);
        }
        return (A)a;
    }

    private <A> void removeMixin(Class<A> type) {
        ChromatticSession session = this.model.getSession();
        session.setEmbedded((Object)this, type, null);
    }

    public String getName() {
        return this.getNodeName();
    }

    public String toString() {
        ObjectType objectType = this.getObjectType();
        Class javaType = objectType.getJavaType();
        String typeName = javaType.getSimpleName();
        String name = this.getNodeName();
        String id = this.getObjectId();
        return typeName + "[name=" + name + ",id=" + id + "]";
    }

    static boolean contains(CustomizationContext container, CustomizationContext contained) {
        return WorkspaceObjectImpl.contains(((WorkspaceCustomizationContextImpl)container).getOwner(), contained);
    }

    private static boolean contains(WorkspaceObjectImpl container, CustomizationContext contained) {
        if (container == null) {
            throw new NullPointerException("No null container accepted");
        }
        if (contained == null) {
            throw new NullPointerException("No null contained accepted");
        }
        if (container == contained) {
            return true;
        }
        if (container instanceof WorkspaceImpl) {
            if (contained instanceof SiteImpl) {
                SiteImpl site = (SiteImpl)contained;
                return WorkspaceObjectImpl.contains(container, (CustomizationContext)site.getWorkspace().getCustomizationContext());
            }
            if (contained instanceof PageImpl) {
                PageImpl page = (PageImpl)contained;
                return WorkspaceObjectImpl.contains(container, (CustomizationContext)page.getSite().getCustomizationContext());
            }
            if (contained instanceof UIWindowImpl) {
                UIWindowImpl window = (UIWindowImpl)contained;
                return WorkspaceObjectImpl.contains(container, (CustomizationContext)window.getPage().getCustomizationContext());
            }
        }
        if (container instanceof SiteImpl) {
            if (contained instanceof PageImpl) {
                PageImpl page = (PageImpl)contained;
                return WorkspaceObjectImpl.contains(container, (CustomizationContext)page.getSite().getCustomizationContext());
            }
            if (contained instanceof UIWindowImpl) {
                UIWindowImpl window = (UIWindowImpl)contained;
                return WorkspaceObjectImpl.contains(container, (CustomizationContext)window.getPage().getCustomizationContext());
            }
        }
        if (container instanceof PageImpl && contained instanceof UIWindowImpl) {
            UIWindowImpl window = (UIWindowImpl)contained;
            return WorkspaceObjectImpl.contains(container, (CustomizationContext)window.getPage().getCustomizationContext());
        }
        return false;
    }
}

