/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.SpoolConfig;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;

public abstract class StreamValueData
extends AbstractValueData {
    protected InputStream stream;
    protected SpoolFile spoolFile;
    protected final SpoolConfig spoolConfig;
    protected byte[] data;
    protected FileChannel channel;

    protected StreamValueData(int orderNumber, InputStream stream, SpoolFile spoolFile, SpoolConfig spoolConfig) throws IOException {
        super(orderNumber);
        this.stream = stream;
        this.spoolFile = spoolFile;
        this.spoolConfig = spoolConfig;
        if (spoolFile != null) {
            spoolFile.acquire(this);
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }
    }

    public byte[] getAsByteArray() throws IOException {
        if (this.isByteArrayAfterSpool()) {
            return this.data;
        }
        return this.fileToByteArray(this.spoolFile);
    }

    public InputStream getAsStream() throws IOException {
        if (this.isByteArrayAfterSpool()) {
            return new ByteArrayInputStream(this.data);
        }
        if (this.spoolFile != null) {
            return PrivilegedFileHelper.fileInputStream((File)this.spoolFile);
        }
        throw new IllegalArgumentException("Stream already consumed");
    }

    public long getLength() {
        if (this.isByteArrayAfterSpool()) {
            return this.data.length;
        }
        return PrivilegedFileHelper.length((File)this.spoolFile);
    }

    public boolean isByteArray() {
        return this.data != null;
    }

    public long read(OutputStream stream, long length, long position) throws IOException {
        if (this.isByteArrayAfterSpool()) {
            return this.readFromByteArray(stream, length, position);
        }
        return this.readFromFile(stream, this.spoolFile, length, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long readFromFile(OutputStream stream, File file, long length, long position) throws IOException {
        long l;
        block5: {
            FileInputStream in = null;
            try {
                if (this.channel == null || !this.channel.isOpen()) {
                    in = PrivilegedFileHelper.fileInputStream((File)file);
                    this.channel = in.getChannel();
                }
                length = this.validateAndAdjustLenght(length, position, this.channel.size());
                MappedByteBuffer bb = this.channel.map(FileChannel.MapMode.READ_ONLY, position, length);
                WritableByteChannel ch = Channels.newChannel(stream);
                ch.write(bb);
                ch.close();
                l = length;
                Object var13_9 = null;
                if (in == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var13_10 = null;
                    if (in == null) break block6;
                    in.close();
                    if (this.channel != null) {
                        this.channel.close();
                    }
                }
                throw throwable;
            }
            in.close();
            if (this.channel != null) {
                this.channel.close();
            }
        }
        return l;
    }

    protected void finalize() throws Throwable {
        if (this.channel != null) {
            this.channel.close();
        }
        this.removeSpoolFile();
        super.finalize();
    }

    private boolean isByteArrayAfterSpool() {
        if (this.data != null) {
            return true;
        }
        this.spoolInputStream();
        return this.data != null;
    }

    /*
     * Loose catch block
     */
    protected void spoolInputStream() {
        block18: {
            OutputStream sfout;
            SpoolFile sf;
            block17: {
                if (this.spoolFile != null || this.data != null) {
                    return;
                }
                byte[] buffer = new byte[]{};
                byte[] tmpBuff = new byte[2048];
                int read = 0;
                int len = 0;
                sf = null;
                sfout = null;
                while ((read = this.stream.read(tmpBuff)) >= 0) {
                    if (sfout != null) {
                        sfout.write(tmpBuff, 0, read);
                        len += read;
                        continue;
                    }
                    if (len + read > this.spoolConfig.maxBufferSize) {
                        sf = SpoolFile.createTempFile("jcrvd", null, this.spoolConfig.tempDirectory);
                        sf.acquire(this);
                        sfout = PrivilegedFileHelper.fileOutputStream((File)sf);
                        sfout.write(buffer, 0, len);
                        sfout.write(tmpBuff, 0, read);
                        buffer = null;
                        len += read;
                        continue;
                    }
                    byte[] newBuffer = new byte[len + read];
                    System.arraycopy(buffer, 0, newBuffer, 0, len);
                    System.arraycopy(tmpBuff, 0, newBuffer, len, read);
                    buffer = newBuffer;
                    len += read;
                }
                if (sf != null) {
                    this.spoolFile = sf;
                    this.data = null;
                    break block17;
                }
                this.spoolFile = null;
                this.data = buffer;
            }
            Object var10_9 = null;
            try {
                if (sfout != null) {
                    sfout.close();
                }
                break block18;
            }
            catch (IOException e) {
                LOG.error((Object)"Error of spool output close.", (Throwable)e);
            }
            {
                break block18;
                catch (IOException e) {
                    block19: {
                        if (sf != null) {
                            try {
                                sf.release(this);
                                this.spoolConfig.fileCleaner.addFile(sf);
                            }
                            catch (FileNotFoundException ex) {
                                if (!LOG.isDebugEnabled()) break block19;
                                LOG.debug((Object)("Could not remove temporary file : " + sf.getAbsolutePath()));
                            }
                        }
                    }
                    throw new IllegalStateException("Error of spooling to temp file from " + this.stream, e);
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                try {
                    if (sfout != null) {
                        sfout.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"Error of spool output close.", (Throwable)e);
                }
                this.stream = null;
                throw throwable;
            }
        }
        this.stream = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] fileToByteArray(File file) throws IOException {
        byte[] byArray;
        block9: {
            ByteBuffer bb;
            FileInputStream in;
            block7: {
                byte[] byArray2;
                block8: {
                    in = null;
                    try {
                        if (this.channel == null || !this.channel.isOpen()) {
                            in = PrivilegedFileHelper.fileInputStream((File)file);
                            this.channel = in.getChannel();
                        }
                        bb = ByteBuffer.allocate((int)this.channel.size());
                        this.channel.read(bb);
                        if (!bb.hasArray()) break block7;
                        byArray2 = bb.array();
                        Object var7_6 = null;
                        if (in == null) break block8;
                    }
                    catch (Throwable throwable) {
                        block10: {
                            Object var7_8 = null;
                            if (in == null) break block10;
                            in.close();
                            if (this.channel != null) {
                                this.channel.close();
                            }
                        }
                        throw throwable;
                    }
                    in.close();
                    if (this.channel != null) {
                        this.channel.close();
                    }
                }
                return byArray2;
            }
            byte[] tmpb = new byte[bb.capacity()];
            bb.get(tmpb);
            byArray = tmpb;
            Object var7_7 = null;
            if (in == null) break block9;
            in.close();
            if (this.channel != null) {
                this.channel.close();
            }
        }
        return byArray;
    }

    private void removeSpoolFile() throws IOException {
        if (this.spoolFile != null) {
            if (this.spoolFile instanceof SpoolFile) {
                this.spoolFile.release(this);
            }
            if (PrivilegedFileHelper.exists((File)this.spoolFile) && !PrivilegedFileHelper.delete((File)this.spoolFile)) {
                this.spoolConfig.fileCleaner.addFile(this.spoolFile);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Could not remove file. Add to fileCleaner " + PrivilegedFileHelper.getAbsolutePath((File)this.spoolFile)));
                }
            }
        }
    }

    protected byte[] spoolInternalValue() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    protected boolean internalEquals(ValueData another) {
        if (another instanceof StreamValueData) {
            StreamValueData streamValue = (StreamValueData)another;
            if (this.isByteArray()) {
                return another.isByteArray() && Arrays.equals(streamValue.data, this.data);
            }
            if (this.stream != null && this.stream == streamValue.stream) {
                return true;
            }
            if (this.spoolFile != null && this.spoolFile.equals(streamValue.spoolFile)) {
                return true;
            }
        }
        return false;
    }

    public PersistedValueData createPersistedCopy(int orderNumber) throws IOException {
        if (this.isByteArray()) {
            return new ByteArrayPersistedValueData(orderNumber, this.data);
        }
        if (this.spoolFile != null) {
            return new StreamPersistedValueData(orderNumber, this.spoolFile, null, this.spoolConfig);
        }
        return new StreamPersistedValueData(orderNumber, this.stream, null, this.spoolConfig);
    }

    public TransientValueData createTransientCopy(int orderNumber) throws IOException {
        return new TransientValueData(this.getOrderNumber(), this.getAsStream(), this.spoolConfig);
    }

    protected Long getLong() throws ValueFormatException {
        return Long.valueOf(this.getString());
    }

    protected Boolean getBoolean() throws ValueFormatException {
        return Boolean.valueOf(this.getString());
    }

    protected Double getDouble() throws ValueFormatException {
        return Double.valueOf(this.getString());
    }

    protected String getString() throws ValueFormatException {
        try {
            return new String(this.getAsByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ValueFormatException("Unsupported encoding UTF-8", (Throwable)e);
        }
        catch (IOException e) {
            throw new ValueFormatException("Can't represents data as array of bytes", (Throwable)e);
        }
    }

    protected Calendar getDate() throws ValueFormatException {
        return JCRDateFormat.parse(this.getString());
    }

    protected InputStream getStream() throws IOException {
        return this.getAsStream();
    }

    protected InternalQName getName() throws ValueFormatException, IllegalNameException {
        return InternalQName.parse(this.getString());
    }

    protected QPath getPath() throws ValueFormatException, IllegalPathException {
        return QPath.parse(this.getString());
    }

    protected String getReference() throws ValueFormatException {
        return this.getString();
    }

    protected AccessControlEntry getPermission() throws ValueFormatException {
        return AccessControlEntry.parse(this.getString());
    }
}

