/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MultiDbJDBCConnection;

public class MSSQLMultiDbJDBCConnection
extends MultiDbJDBCConnection {
    public String FIND_NODES_AND_PROPERTIES_TEMPLATE;

    public MSSQLMultiDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_NODES_AND_PROPERTIES_TEMPLATE = "select J.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from " + this.JCR_VALUE + " V WITH (INDEX (" + this.JCR_IDX_VALUE_PROPERTY + ")), " + this.JCR_ITEM + " P" + " join (select TOP ${TOP} I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM from " + this.JCR_ITEM + " I" + " WITH (INDEX (" + this.JCR_PK_ITEM + ")) where I.I_CLASS=1 AND I.ID > ? order by I.ID) J on P.PARENT_ID = J.ID" + " where P.I_CLASS=2 and V.PROPERTY_ID=P.ID order by J.ID";
    }

    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        if (this.findNodesAndProperties != null) {
            this.findNodesAndProperties.close();
        }
        this.findNodesAndProperties = this.dbConnection.prepareStatement(this.FIND_NODES_AND_PROPERTIES_TEMPLATE.replace("${TOP}", new Integer(offset + limit).toString()));
        this.findNodesAndProperties.setString(1, this.getInternalId(lastNodeId));
        return this.findNodesAndProperties.executeQuery();
    }

    protected boolean needToSkipOffsetNodes() {
        return true;
    }

    protected String escapeSpecialChars(String pattern) {
        char[] chars = pattern.toCharArray();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '*': {
                    sb.append('%');
                    continue block4;
                }
                case '%': 
                case '[': 
                case ']': 
                case '_': {
                    sb.append(this.getWildcardEscapeSymbol());
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }
}

