/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.chromattic.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.exoplatform.social.core.chromattic.entity.ActivityRef;
import org.exoplatform.social.core.chromattic.entity.ActivityRefDayEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityRefListEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityRefMonthEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityRefYearEntity;
import org.exoplatform.social.core.chromattic.entity.IndexNumber;
import org.exoplatform.social.core.chromattic.entity.NamedEntity;

public class ActivityRefIterator
implements Iterator<ActivityRef> {
    private final ActivityRefListEntity listEntity;
    private Iterator<ActivityRefYearEntity> yearIterator;
    private Iterator<ActivityRefMonthEntity> monthIterator;
    private Iterator<ActivityRefDayEntity> dayIterator;
    private Iterator<ActivityRef> entityIterator;

    ActivityRefIterator(ActivityRefListEntity listEntity) {
        this.listEntity = listEntity;
        this.yearIterator = listEntity.getYears().values().iterator();
        if (this.yearIterator.hasNext()) {
            this.monthIterator = this.yearIterator.next().getMonths().values().iterator();
            if (this.monthIterator.hasNext()) {
                this.dayIterator = this.monthIterator.next().getDays().values().iterator();
                if (this.dayIterator.hasNext()) {
                    this.entityIterator = this.orderRefs();
                }
            }
        }
    }

    private Iterator<ActivityRef> orderRefs() {
        ArrayList<ActivityRef> got = new ArrayList<ActivityRef>(this.dayIterator.next().getActivityRefList());
        Collections.reverse(got);
        return got.iterator();
    }

    @Override
    public boolean hasNext() {
        boolean nothing = true;
        if (this.entityIterator != null && this.entityIterator.hasNext()) {
            return true;
        }
        if (this.dayIterator != null && this.dayIterator.hasNext()) {
            this.entityIterator = this.orderRefs();
            nothing = false;
            if (this.entityIterator.hasNext()) {
                return true;
            }
        } else if (this.monthIterator != null && this.monthIterator.hasNext()) {
            this.dayIterator = this.monthIterator.next().getDays().values().iterator();
            nothing = false;
            if (this.dayIterator.hasNext()) {
                this.entityIterator = this.dayIterator.next().getActivityRefs().values().iterator();
                if (this.entityIterator.hasNext()) {
                    return true;
                }
            }
        } else if (this.yearIterator != null && this.yearIterator.hasNext()) {
            this.monthIterator = this.yearIterator.next().getMonths().values().iterator();
            nothing = false;
            if (this.monthIterator.hasNext()) {
                this.dayIterator = this.monthIterator.next().getDays().values().iterator();
                if (this.dayIterator.hasNext()) {
                    this.entityIterator = this.orderRefs();
                    if (this.entityIterator.hasNext()) {
                        return true;
                    }
                }
            }
        }
        if (nothing) {
            return false;
        }
        return this.hasNext();
    }

    public int moveTo(ActivityRef activityRef) {
        ActivityRefDayEntity day = activityRef.getDay();
        ActivityRefMonthEntity month = day.getMonth();
        ActivityRefYearEntity year = month.getYear();
        int nb = 0;
        nb += this.moveIterator(this.yearIterator, year.getName());
        nb += this.moveIterator(this.monthIterator, month.getName());
        nb += this.moveIterator(this.dayIterator, day.getName());
        return nb += this.moveIterator(this.entityIterator, activityRef.getName());
    }

    @Override
    public ActivityRef next() {
        if (this.hasNext()) {
            return this.entityIterator.next();
        }
        throw new RuntimeException();
    }

    @Override
    public void remove() {
        throw new RuntimeException();
    }

    private int moveIterator(Iterator<? extends NamedEntity> it, String name) {
        int nb = 0;
        while (it.hasNext()) {
            NamedEntity got = it.next();
            if (got.getName().equals(name)) {
                return nb;
            }
            if (got instanceof IndexNumber) {
                nb += ((IndexNumber)((Object)got)).getNumber().intValue();
                continue;
            }
            ++nb;
        }
        return nb;
    }
}

