/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.chromattic.api.query.Ordering;
import org.chromattic.api.query.QueryBuilder;
import org.exoplatform.social.common.jcr.filter.FilterLiteral;
import org.exoplatform.social.core.activity.filter.ActivityFilter;
import org.exoplatform.social.core.chromattic.entity.ActivityEntity;
import org.exoplatform.social.core.chromattic.entity.HidableEntity;
import org.exoplatform.social.core.chromattic.filter.JCRFilterLiteral;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.query.BuilderWhereExpression;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.PropertyLiteralExpression;
import org.exoplatform.social.core.storage.query.WhereExpression;

public abstract class ActivityBuilderWhere
implements BuilderWhereExpression<JCRFilterLiteral, QueryBuilder<ActivityEntity>> {
    final WhereExpression where = new WhereExpression();
    Identity poster;
    Identity mentioner;
    Identity liker;
    Identity commenter;
    ThreadLocal<List<Identity>> identitiesLocal = new ThreadLocal();
    ThreadLocal<List<Identity>> postersLocal = new ThreadLocal();
    private Object lock = new Object();
    String[] activityIds = new String[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String build(JCRFilterLiteral filter) {
        String result = "";
        Object object = this.lock;
        synchronized (object) {
            this.init();
            result = this.make(filter);
            this.destroy(filter);
        }
        return result;
    }

    @Override
    public void orderBy(QueryBuilder<ActivityEntity> orderByBuilder, JCRFilterLiteral filter) {
        Iterator it = filter.getOrders();
        FilterLiteral.OrderByOption orderBy = null;
        while (it.hasNext()) {
            orderBy = (FilterLiteral.OrderByOption)it.next();
            orderByBuilder.orderBy(((PropertyLiteralExpression)orderBy.getLiteral()).getName(), orderBy.getDirection() == FilterLiteral.DIRECTION.ASC ? Ordering.ASC : Ordering.DESC);
        }
    }

    public String make(JCRFilterLiteral filter) {
        return this.where.toString();
    }

    private void init() {
        this.where.getStringBuilder();
    }

    private void destroy(JCRFilterLiteral filter) {
        this.where.destroy();
        filter.destroy();
        this.activityIds = new String[0];
        this.poster = null;
        this.mentioner = null;
        this.liker = null;
        this.commenter = null;
        this.identitiesLocal.remove();
        this.postersLocal.remove();
    }

    public ActivityBuilderWhere poster(Identity poster) {
        this.poster = poster;
        return this;
    }

    public ActivityBuilderWhere posters(List<Identity> posters) {
        List<Identity> posterList = this.postersLocal.get();
        if (posterList == null) {
            posterList = new ArrayList<Identity>();
        }
        posterList.addAll(posters);
        this.postersLocal.set(posterList);
        return this;
    }

    public ActivityBuilderWhere mentioner(Identity mentioner) {
        this.mentioner = mentioner;
        return this;
    }

    public ActivityBuilderWhere liker(Identity liker) {
        this.liker = liker;
        return this;
    }

    public ActivityBuilderWhere commenter(Identity commenter) {
        this.commenter = commenter;
        return this;
    }

    public ActivityBuilderWhere owners(List<Identity> identities) {
        List<Identity> identityList = this.identitiesLocal.get();
        if (identityList == null) {
            identityList = new ArrayList<Identity>();
        }
        identityList.addAll(identities);
        this.identitiesLocal.set(identityList);
        return this;
    }

    public ActivityBuilderWhere owners(Identity ... identity) {
        return this.owners(Arrays.asList(identity));
    }

    public List<Identity> getOwners() {
        return this.identitiesLocal.get() == null ? new ArrayList() : new CopyOnWriteArrayList(this.identitiesLocal.get());
    }

    public List<Identity> getPosters() {
        return this.postersLocal.get() == null ? new ArrayList() : new CopyOnWriteArrayList(this.postersLocal.get());
    }

    public ActivityBuilderWhere excludedActivities(String ... activityIds) {
        this.activityIds = activityIds;
        return this;
    }

    public String[] excludedActivityIds() {
        return this.activityIds;
    }

    public static ActivityBuilderWhere space() {
        return new ActivityBuilderWhere(){

            @Override
            public String make(JCRFilterLiteral filter) {
                List<Identity> identities = this.getOwners();
                if (identities != null && identities.size() > 0) {
                    boolean first = true;
                    this.where.startGroup();
                    for (Identity currentIdentity : identities) {
                        if (first) {
                            first = false;
                        } else {
                            this.where.or();
                        }
                        this.where.equals(ActivityEntity.identity, currentIdentity.getId());
                    }
                    if (this.mentioner != null) {
                        this.where.or();
                        this.where.contains(ActivityEntity.mentioners, this.mentioner.getId());
                    }
                    this.where.endGroup();
                }
                this.where.and().equals(ActivityEntity.isComment, Boolean.FALSE);
                this.where.and();
                this.where.startGroup();
                this.where.equals(HidableEntity.isHidden, Boolean.FALSE);
                this.where.or().isNull(HidableEntity.isHidden);
                this.where.endGroup();
                Object objFilter = filter.get(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).getValue();
                if (objFilter != null) {
                    ActivityStorage.TimestampType type = null;
                    if (objFilter instanceof ActivityStorage.TimestampType && (type = (ActivityStorage.TimestampType)((Object)objFilter)) != null) {
                        switch (type) {
                            case NEWER: {
                                this.where.and().greater(ActivityEntity.lastUpdated, type.get());
                                break;
                            }
                            case OLDER: {
                                this.where.and().lesser(ActivityEntity.lastUpdated, type.get());
                            }
                        }
                    }
                }
                return this.where.toString();
            }
        };
    }

    public static ActivityBuilderWhere updated() {
        return new ActivityBuilderWhere(){

            @Override
            public String make(JCRFilterLiteral filter) {
                String[] excludedActivityIds;
                List<Identity> identities = this.getOwners();
                boolean hasIndentitiesCondition = identities != null && identities.size() > 0 ? identities.size() > 0 : false;
                boolean first = true;
                this.where.startGroup();
                if (hasIndentitiesCondition) {
                    for (Identity currentIdentity : identities) {
                        if (first) {
                            first = false;
                        } else {
                            this.where.or();
                        }
                        this.where.equals(ActivityEntity.identity, currentIdentity.getId());
                    }
                }
                if (this.mentioner != null) {
                    if (first) {
                        first = false;
                    } else {
                        this.where.or();
                    }
                    this.where.contains(ActivityEntity.mentioners, this.mentioner.getId());
                }
                if (this.mentioner != null) {
                    List<Identity> posters = this.getPosters();
                    for (Identity currentIdentity : posters) {
                        if (first) {
                            first = false;
                        } else {
                            this.where.or();
                        }
                        this.where.startGroup();
                        this.where.equals(ActivityEntity.identity, this.mentioner.getId());
                        this.where.and().equals(ActivityEntity.poster, currentIdentity.getId());
                        this.where.and().equals(ActivityEntity.isComment, true);
                        this.where.endGroup();
                    }
                }
                this.where.endGroup();
                Object objFilter = filter.get(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).getValue();
                if (objFilter != null) {
                    ActivityStorage.TimestampType type = null;
                    if (objFilter instanceof ActivityStorage.TimestampType && (type = (ActivityStorage.TimestampType)((Object)objFilter)) != null) {
                        switch (type) {
                            case NEWER: {
                                this.where.and().greater(ActivityEntity.lastUpdated, type.get());
                                break;
                            }
                            case OLDER: {
                                this.where.and().lesser(ActivityEntity.lastUpdated, type.get());
                            }
                        }
                    }
                }
                for (String id : excludedActivityIds = this.activityIds) {
                    this.where.and().not().equals(JCRProperties.id, id);
                }
                return this.where.toString();
            }
        };
    }

    public static ActivityBuilderWhere viewedRange() {
        return new ActivityBuilderWhere(){

            @Override
            public String make(JCRFilterLiteral filter) {
                boolean hasIndentitiesCondition;
                List<Identity> identities = this.getOwners();
                boolean bl = identities != null && identities.size() > 0 ? identities.size() > 0 : (hasIndentitiesCondition = false);
                if (hasIndentitiesCondition) {
                    boolean first = true;
                    this.where.startGroup();
                    for (Identity currentIdentity : identities) {
                        if (currentIdentity == null) continue;
                        if (first) {
                            first = false;
                        } else {
                            this.where.or();
                        }
                        this.where.equals(ActivityEntity.identity, currentIdentity.getId());
                    }
                    if (this.mentioner != null) {
                        this.where.or();
                        this.where.contains(ActivityEntity.mentioners, this.mentioner.getId());
                    }
                    this.where.endGroup();
                } else if (this.mentioner != null) {
                    this.where.contains(ActivityEntity.mentioners, this.mentioner.getId());
                }
                Object fromFilter = null;
                FilterLiteral.FilterOption frFilter = filter.get(ActivityFilter.ACTIVITY_FROM_UPDATED_POINT_FIELD);
                if (frFilter != null) {
                    fromFilter = frFilter.getValue();
                }
                if (fromFilter != null) {
                    ActivityStorage.TimestampType type = null;
                    if (fromFilter instanceof ActivityStorage.TimestampType && (type = (ActivityStorage.TimestampType)((Object)fromFilter)) != null) {
                        switch (type) {
                            case NEWER: {
                                this.where.and().greater(ActivityEntity.lastUpdated, type.get());
                                break;
                            }
                            case OLDER: {
                                this.where.and().lesser(ActivityEntity.lastUpdated, type.get());
                            }
                        }
                    }
                }
                Object toFilter = null;
                FilterLiteral.FilterOption tFilter = filter.get(ActivityFilter.ACTIVITY_TO_UPDATED_POINT_FIELD);
                if (tFilter != null) {
                    toFilter = tFilter.getValue();
                }
                if (toFilter != null) {
                    ActivityStorage.TimestampType type = null;
                    if (toFilter instanceof ActivityStorage.TimestampType && (type = (ActivityStorage.TimestampType)((Object)toFilter)) != null) {
                        switch (type) {
                            case NEWER: {
                                this.where.and().greater(ActivityEntity.lastUpdated, type.get());
                                break;
                            }
                            case OLDER: {
                                this.where.and().lesser(ActivityEntity.lastUpdated, type.get());
                            }
                        }
                    }
                }
                return this.where.toString();
            }
        };
    }

    public static ActivityBuilderWhere simple() {
        return new ActivityBuilderWhere(){

            @Override
            public String make(JCRFilterLiteral filter) {
                List<Identity> identities = this.getOwners();
                boolean first = true;
                if (identities != null && identities.size() > 0) {
                    this.where.startGroup();
                    for (Identity currentIdentity : identities) {
                        if (first) {
                            first = false;
                        } else {
                            this.where.or();
                        }
                        this.where.equals(ActivityEntity.identity, currentIdentity.getId());
                    }
                    if (this.poster != null) {
                        this.where.or();
                        this.where.equals(ActivityEntity.poster, this.poster.getId());
                    }
                    if (this.mentioner != null) {
                        this.where.or();
                        this.where.contains(ActivityEntity.mentioners, this.mentioner.getId());
                    }
                    if (this.commenter != null) {
                        this.where.or();
                        this.where.contains(ActivityEntity.commenters, this.commenter.getId());
                    }
                    if (this.liker != null) {
                        this.where.or();
                        this.where.contains(ActivityEntity.likes, this.liker.getId());
                    }
                    this.where.endGroup();
                }
                if (!first) {
                    this.where.and();
                }
                this.where.equals(ActivityEntity.isComment, Boolean.FALSE);
                this.where.and();
                this.where.startGroup();
                this.where.equals(HidableEntity.isHidden, Boolean.FALSE);
                this.where.or().isNull(HidableEntity.isHidden);
                this.where.endGroup();
                Object objFilter = filter.get(ActivityFilter.ACTIVITY_UPDATED_POINT_FIELD).getValue();
                if (objFilter != null) {
                    ActivityStorage.TimestampType type = null;
                    if (objFilter instanceof ActivityStorage.TimestampType && (type = (ActivityStorage.TimestampType)((Object)objFilter)) != null) {
                        switch (type) {
                            case NEWER: {
                                this.where.and().greater(ActivityEntity.lastUpdated, type.get());
                                break;
                            }
                            case OLDER: {
                                this.where.and().lesser(ActivityEntity.lastUpdated, type.get());
                            }
                        }
                    }
                }
                return this.where.toString();
            }
        };
    }

    public static ActivityBuilderWhere owner() {
        return new ActivityBuilderWhere(){

            @Override
            public String make(JCRFilterLiteral filter) {
                List<Identity> identities = this.getOwners();
                if (identities != null && identities.size() > 0) {
                    boolean first = true;
                    this.where.startGroup();
                    for (Identity currentIdentity : identities) {
                        if (first) {
                            first = false;
                        } else {
                            this.where.or();
                        }
                        this.where.equals(ActivityEntity.identity, currentIdentity.getId());
                    }
                    if (this.mentioner != null) {
                        if (first) {
                            first = false;
                        } else {
                            this.where.or();
                        }
                        this.where.contains(ActivityEntity.mentioners, this.mentioner.getId());
                    }
                    if (this.poster != null) {
                        this.where.or();
                        this.where.startGroup();
                        this.where.equals(ActivityEntity.poster, this.poster.getId());
                        this.where.and().equals(ActivityEntity.isComment, true);
                        this.where.endGroup();
                    }
                    this.where.endGroup();
                }
                return this.where.toString();
            }
        };
    }
}

