/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.util.Locale;

final class CurrencyServiceShim
extends Currency.ServiceShim {
    static final ICULocaleService service = new CFService();

    CurrencyServiceShim() {
    }

    Locale[] getAvailableLocales() {
        if (service.isDefault()) {
            return ICUResourceBundle.getAvailableLocales("com/ibm/icu/impl/data/icudt38b");
        }
        return service.getAvailableLocales();
    }

    ULocale[] getAvailableULocales() {
        if (service.isDefault()) {
            return ICUResourceBundle.getAvailableULocales("com/ibm/icu/impl/data/icudt38b");
        }
        return service.getAvailableULocales();
    }

    Currency createInstance(ULocale loc) {
        if (service.isDefault()) {
            return Currency.createCurrency(loc);
        }
        ULocale[] actualLoc = new ULocale[1];
        Currency curr = (Currency)service.get(loc, actualLoc);
        ULocale uloc = actualLoc[0];
        curr.setLocale(uloc, uloc);
        return curr;
    }

    Object registerInstance(Currency currency, ULocale locale) {
        return service.registerObject((Object)currency, locale);
    }

    boolean unregister(Object registryKey) {
        return service.unregisterFactory((ICUService.Factory)registryKey);
    }

    private static class CFService
    extends ICULocaleService {
        CFService() {
            super("Currency");
            class CurrencyFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                CurrencyFactory() {
                }

                protected Object handleCreate(ULocale loc, int kind, ICUService service) {
                    return Currency.createCurrency(loc);
                }
            }
            this.registerFactory(new CurrencyFactory());
            this.markDefault();
        }
    }
}

