/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AudienceRestrictionType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;

public class SAMLConditionsParser
implements ParserNamespaceSupport {
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        Attribute notAfterAttribute;
        StartElement conditionsElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(conditionsElement, JBossSAMLConstants.CONDITIONS.get());
        ConditionsType conditions = new ConditionsType();
        String assertionNS = JBossSAMLURIConstants.ASSERTION_NSURI.get();
        QName notBeforeQName = new QName("", JBossSAMLConstants.NOT_BEFORE.get());
        QName notBeforeQNameWithNS = new QName(assertionNS, JBossSAMLConstants.NOT_BEFORE.get());
        QName notAfterQName = new QName("", JBossSAMLConstants.NOT_ON_OR_AFTER.get());
        QName notAfterQNameWithNS = new QName(assertionNS, JBossSAMLConstants.NOT_ON_OR_AFTER.get());
        Attribute notBeforeAttribute = conditionsElement.getAttributeByName(notBeforeQName);
        if (notBeforeAttribute == null) {
            notBeforeAttribute = conditionsElement.getAttributeByName(notBeforeQNameWithNS);
        }
        if ((notAfterAttribute = conditionsElement.getAttributeByName(notAfterQName)) == null) {
            notAfterAttribute = conditionsElement.getAttributeByName(notAfterQNameWithNS);
        }
        if (notBeforeAttribute != null) {
            String notBeforeValue = StaxParserUtil.getAttributeValue(notBeforeAttribute);
            conditions.setNotBefore(XMLTimeUtil.parse(notBeforeValue));
        }
        if (notAfterAttribute != null) {
            String notAfterValue = StaxParserUtil.getAttributeValue(notAfterAttribute);
            conditions.setNotOnOrAfter(XMLTimeUtil.parse(notAfterValue));
        }
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement nextEndElement = (EndElement)xmlEvent;
                if (StaxParserUtil.matches(nextEndElement, JBossSAMLConstants.CONDITIONS.get())) {
                    nextEndElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    break;
                }
                throw new RuntimeException("PL00061: Parser: Unknown End Element:" + StaxParserUtil.getEndElementName(nextEndElement));
            }
            String tag = null;
            if (xmlEvent instanceof StartElement) {
                StartElement peekedElement = (StartElement)xmlEvent;
                tag = StaxParserUtil.getStartElementName(peekedElement);
            }
            if (JBossSAMLConstants.AUDIENCE_RESTRICTION.get().equals(tag)) {
                AudienceRestrictionType audienceRestriction = this.getAudienceRestriction(xmlEventReader);
                conditions.addCondition(audienceRestriction);
                continue;
            }
            throw new RuntimeException("PL00062: Parser : Unknown tag:" + tag + "::location=" + xmlEvent.getLocation());
        }
        return conditions;
    }

    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return nsURI.equals(JBossSAMLURIConstants.ASSERTION_NSURI.get()) && localPart.equals(JBossSAMLConstants.CONDITIONS.get());
    }

    private AudienceRestrictionType getAudienceRestriction(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement audienceElement;
        StartElement audienceRestElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.matches(audienceRestElement, JBossSAMLConstants.AUDIENCE_RESTRICTION.get());
        AudienceRestrictionType audience = new AudienceRestrictionType();
        while (xmlEventReader.hasNext() && StaxParserUtil.matches(audienceElement = StaxParserUtil.getNextStartElement(xmlEventReader), JBossSAMLConstants.AUDIENCE.get())) {
            if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                throw new ParsingException("PL00066: Parser : Expected start tag:audienceValue");
            }
            String audienceValue = StaxParserUtil.getElementText(xmlEventReader);
            audience.addAudience(URI.create(audienceValue));
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (!(xmlEvent instanceof EndElement)) continue;
            EndElement endElement = (EndElement)xmlEvent;
            if (StaxParserUtil.matches(endElement, JBossSAMLConstants.AUDIENCE_RESTRICTION.get())) {
                StaxParserUtil.getNextEvent(xmlEventReader);
                break;
            }
            throw new RuntimeException("PL00061: Parser: Unknown End Element:" + StaxParserUtil.getEndElementName(endElement));
        }
        return audience;
    }
}

