/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.servlets.saml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;
import org.jboss.security.xacml.core.JBossPDP;
import org.jboss.security.xacml.interfaces.PolicyDecisionPoint;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.SOAPSAMLXACMLUtil;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLResponseWriter;
import org.picketlink.identity.federation.core.util.SOAPUtil;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.XACMLAuthzDecisionQueryType;
import org.picketlink.identity.federation.web.servlets.saml.SecurityActions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPSAMLXACMLServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(SOAPSAMLXACMLServlet.class);
    private final boolean trace = log.isTraceEnabled();
    private static final long serialVersionUID = 1L;
    private String policyConfigFileName = null;
    private String issuerId = null;
    private String issuer = null;
    boolean debug = false;
    private transient PolicyDecisionPoint pdp = null;
    private String soapVersion = "1.1";

    public void init(ServletConfig config) throws ServletException {
        String soap;
        this.issuerId = config.getInitParameter("issuerID");
        if (this.issuerId == null) {
            this.issuerId = "issue-id:1";
        }
        this.issuer = config.getInitParameter("issuer");
        if (this.issuer == null) {
            this.issuer = "urn:jboss-identity";
        }
        this.policyConfigFileName = config.getInitParameter("policyConfigFileName");
        if (this.policyConfigFileName == null) {
            this.policyConfigFileName = "policyConfig.xml";
        }
        if ((soap = config.getInitParameter("soapVersion")) != null) {
            this.soapVersion = soap;
        }
        String debugStr = config.getInitParameter("debug");
        try {
            this.debug = Boolean.parseBoolean(debugStr);
        }
        catch (Exception ignore) {
            this.debug = false;
        }
        if (this.trace) {
            log.trace((Object)("Issuer=" + this.issuer + " :: issuerID=" + this.issuerId));
            log.trace((Object)("PolicyConfig File:" + this.policyConfigFileName));
            log.trace((Object)("Debug=" + this.debug));
        }
        if (this.debug) {
            SecurityActions.setSystemProperty("jaxb.debug", "true");
        }
        try {
            this.pdp = this.getPDP();
        }
        catch (IOException e) {
            this.log("Exception loading PDP::", e);
            throw new ServletException("PL00102: Processing Exception:Unable to load PDP");
        }
        super.init(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block24: {
            XACMLAuthzDecisionQueryType xacmlRequest = null;
            SOAPMessage returnSOAPMessage = null;
            try {
                try {
                    SOAPMessage soapMessage = null;
                    soapMessage = this.soapVersion.equals("1.2") ? SOAPUtil.getSOAP12Message((InputStream)req.getInputStream()) : SOAPUtil.getSOAPMessage((InputStream)req.getInputStream());
                    SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
                    SOAPBody soapBody = soapEnvelope.getBody();
                    NodeList nl = soapBody.getChildNodes();
                    Node node = null;
                    int length = nl != null ? nl.getLength() : 0;
                    for (int i = 0; i < length; ++i) {
                        Node n = nl.item(i);
                        String localName = n.getLocalName();
                        if (localName != null && localName.equals("MessageBody")) {
                            n = this.getFirstElement(n);
                            localName = n.getLocalName();
                        }
                        if (localName == null || !localName.contains(JBossSAMLConstants.XACML_AUTHZ_DECISION_QUERY.get()) && !localName.contains(JBossSAMLConstants.REQUEST_ABSTRACT.get())) continue;
                        node = n;
                        break;
                    }
                    if (node == null) {
                        throw new ServletException("PL00092: Null Value:Did not find XACML query nodes");
                    }
                    xacmlRequest = SOAPSAMLXACMLUtil.getXACMLQueryType(node);
                }
                catch (SOAPException e) {
                    e.printStackTrace();
                    throw new ServletException((Throwable)e);
                }
                catch (ParsingException e) {
                    throw new ServletException((Throwable)e);
                }
                catch (ConfigurationException e) {
                    throw new ServletException((Throwable)e);
                }
                catch (ProcessingException e) {
                    throw new ServletException((Throwable)e);
                }
                if (xacmlRequest == null) {
                    throw new IOException("PL00092: Null Value:XACML Request not parsed");
                }
                ResponseType samlResponseType = SOAPSAMLXACMLUtil.handleXACMLQuery(this.pdp, this.issuer, xacmlRequest);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLStreamWriter xmlStreamWriter = StaxUtil.getXMLStreamWriter(baos);
                SAMLResponseWriter samlResponseWriter = new SAMLResponseWriter(xmlStreamWriter);
                samlResponseWriter.write(samlResponseType);
                Document responseDocument = DocumentUtil.getDocument(new ByteArrayInputStream(baos.toByteArray()));
                returnSOAPMessage = this.soapVersion.equals("1.2") ? SOAPUtil.createSOAP12() : SOAPUtil.create();
                SOAPBody returnSOAPBody = returnSOAPMessage.getSOAPBody();
                returnSOAPBody.addDocument(responseDocument);
            }
            catch (Exception e) {
                e.printStackTrace();
                String id = IDGenerator.create();
                log.error((Object)(id + "::Exception:"), (Throwable)e);
                try {
                    if (this.soapVersion.equals("1.2")) {
                        returnSOAPMessage = SOAPUtil.createFault12("Server Error");
                        break block24;
                    }
                    returnSOAPMessage = SOAPUtil.createFault("Server Error");
                }
                catch (SOAPException e1) {
                    // empty catch block
                }
            }
            finally {
                resp.setContentType("text/xml;charset=utf-8");
                ServletOutputStream os = resp.getOutputStream();
                try {
                    if (returnSOAPMessage == null) {
                        throw new RuntimeException("PL00092: Null Value:SOAPMessage for return is null");
                    }
                    returnSOAPMessage.writeTo((OutputStream)os);
                }
                catch (Exception e) {
                    this.log("marshalling exception", e);
                }
            }
        }
    }

    private PolicyDecisionPoint getPDP() throws IOException {
        InputStream is = SecurityActions.loadResource(((Object)((Object)this)).getClass(), this.policyConfigFileName).openStream();
        if (is == null) {
            throw new IllegalStateException("PL00018: Resource not found:" + this.policyConfigFileName + " could not be located");
        }
        return new JBossPDP(is);
    }

    private Node getFirstElement(Node node) throws Exception {
        NodeList nodeList = node.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nodeList.item(i);
            if (!(n instanceof Element)) continue;
            return n;
        }
        return null;
    }
}

