/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstProperty
extends AstNode {
    protected final AstNode prefix;
    protected final boolean lvalue;
    protected final boolean strict;

    public AstProperty(AstNode prefix, boolean lvalue, boolean strict) {
        this.prefix = prefix;
        this.lvalue = lvalue;
        this.strict = strict;
    }

    protected abstract Object getProperty(Bindings var1, ELContext var2) throws ELException;

    protected AstNode getPrefix() {
        return this.prefix;
    }

    @Override
    public ValueReference getValueReference(Bindings bindings, ELContext context) {
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", "null", base));
        }
        return new ValueReference(base, property);
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            return null;
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            return null;
        }
        context.setPropertyResolved(false);
        Object result = context.getELResolver().getValue(context, base, property);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", property, base));
        }
        return result;
    }

    @Override
    public final boolean isLiteralText() {
        return false;
    }

    @Override
    public final boolean isLeftValue() {
        return this.lvalue;
    }

    @Override
    public boolean isMethodInvocation() {
        return false;
    }

    @Override
    public Class<?> getType(Bindings bindings, ELContext context) {
        if (!this.lvalue) {
            return null;
        }
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", "null", base));
        }
        context.setPropertyResolved(false);
        Class result = context.getELResolver().getType(context, base, property);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", property, base));
        }
        return result;
    }

    @Override
    public boolean isReadOnly(Bindings bindings, ELContext context) throws ELException {
        if (!this.lvalue) {
            return true;
        }
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", "null", base));
        }
        context.setPropertyResolved(false);
        boolean result = context.getELResolver().isReadOnly(context, base, property);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", property, base));
        }
        return result;
    }

    @Override
    public void setValue(Bindings bindings, ELContext context, Object value) throws ELException {
        if (!this.lvalue) {
            throw new ELException(LocalMessages.get("error.value.set.rvalue", this.getStructuralId(bindings)));
        }
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", "null", base));
        }
        context.setPropertyResolved(false);
        context.getELResolver().setValue(context, base, property, value);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.property.notfound", property, base));
        }
    }

    protected Method findMethod(String name, Class<?> clazz, Class<?> returnType, Class<?>[] paramTypes) {
        Method method = null;
        try {
            method = clazz.getMethod(name, paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", name, clazz));
        }
        method = this.findAccessibleMethod(method);
        if (method == null) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", name, clazz));
        }
        if (returnType != null && !returnType.isAssignableFrom(method.getReturnType())) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", name, clazz));
        }
        return method;
    }

    @Override
    public MethodInfo getMethodInfo(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes) {
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.method.notfound", "null", base));
        }
        String name = bindings.convert(property, String.class);
        Method method = this.findMethod(name, base.getClass(), returnType, paramTypes);
        return new MethodInfo(method.getName(), method.getReturnType(), (Class[])paramTypes);
    }

    @Override
    public Object invoke(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes, Object[] paramValues) {
        Object base = this.prefix.eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", this.prefix));
        }
        Object property = this.getProperty(bindings, context);
        if (property == null && this.strict) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.method.notfound", "null", base));
        }
        String name = bindings.convert(property, String.class);
        Method method = this.findMethod(name, base.getClass(), returnType, paramTypes);
        try {
            return method.invoke(base, paramValues);
        }
        catch (IllegalAccessException e) {
            throw new ELException(LocalMessages.get("error.property.method.access", name, base.getClass()));
        }
        catch (IllegalArgumentException e) {
            throw new ELException(LocalMessages.get("error.property.method.invocation", name, base.getClass()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(LocalMessages.get("error.property.method.invocation", name, base.getClass()), e.getCause());
        }
    }

    @Override
    public AstNode getChild(int i) {
        return i == 0 ? this.prefix : null;
    }
}

