/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.common.service.ExecutorServiceManager;
import org.exoplatform.social.common.service.LifecycleService;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.common.service.SocialServiceContext;
import org.exoplatform.social.common.service.SocialServiceExecutor;
import org.exoplatform.social.common.service.TraceFactory;
import org.exoplatform.social.common.service.impl.ExecutorServiceManagerImpl;
import org.exoplatform.social.common.service.impl.ProcessorContextImpl;
import org.exoplatform.social.common.service.impl.SocialServiceExecutorImpl;
import org.exoplatform.social.common.service.thread.ThreadPoolConfig;
import org.exoplatform.social.common.service.utils.TraceList;

public class SocialServiceContextImpl
implements SocialServiceContext {
    private static ExecutorServiceManager executorServiceManager = new ExecutorServiceManagerImpl();
    private final SocialServiceExecutor serviceExecutor;
    private List<LifecycleService> lifecycleServices = new ArrayList<LifecycleService>();
    private static SocialServiceContext instance;
    private final TraceFactory traceFactory;
    private TraceList traceList;
    private SocialServiceContext.ProcessType isAsyn = SocialServiceContext.ProcessType.SYNC;

    private SocialServiceContextImpl() {
        this.traceFactory = TraceFactory.defaultFactory;
        Object obj = PortalContainer.getInstance().getComponentInstanceOfType(ThreadPoolConfig.class);
        if (obj != null) {
            ThreadPoolConfig config = (ThreadPoolConfig)obj;
            boolean async = config.isAsyncMode();
            this.isAsyn = async ? SocialServiceContext.ProcessType.ASYNC : SocialServiceContext.ProcessType.SYNC;
            this.serviceExecutor = new SocialServiceExecutorImpl(executorServiceManager.newThreadPool("Social", config));
        } else {
            this.serviceExecutor = new SocialServiceExecutorImpl(executorServiceManager.newDefaultThreadPool("Social"));
        }
    }

    public static SocialServiceContext getInstance() {
        if (instance == null) {
            instance = new SocialServiceContextImpl();
        }
        return instance;
    }

    public static ProcessContext createProcessContext() {
        return new ProcessorContextImpl(SocialServiceContextImpl.getInstance());
    }

    @Override
    public List<LifecycleService> getLifecycleServices() {
        return null;
    }

    @Override
    public void addLifecycleService(LifecycleService lifecycleService) {
        this.lifecycleServices.add(lifecycleService);
    }

    @Override
    public SocialServiceExecutor getServiceExecutor() {
        return this.serviceExecutor;
    }

    @Override
    public ExecutorServiceManager getExecutorServiceManager() {
        return executorServiceManager;
    }

    @Override
    public TraceList getTraceList() {
        if (this.traceList == null) {
            this.traceList = this.traceFactory.make();
        }
        return this.traceList;
    }

    @Override
    public boolean isTraced() {
        return false;
    }

    @Override
    public boolean isAsync() {
        return this.isAsyn == SocialServiceContext.ProcessType.ASYNC;
    }
}

