/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputContainer;
import org.exoplatform.webui.form.validator.Validator;

@ComponentConfig(events={@EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE)})
public class UIFormMultiValueInputSet
extends UIFormInputContainer<List> {
    protected List<Validator> validators;
    private Class<? extends UIFormInputBase> clazz_;
    private Constructor constructor_ = null;
    private Object[] constructorParams_;
    protected boolean enable_ = true;
    protected boolean readonly_ = false;

    public UIFormMultiValueInputSet() {
        super(null, null);
    }

    public UIFormMultiValueInputSet(String name, String bindingField) {
        super(name, bindingField);
        this.setComponentConfig(this.getClass(), null);
    }

    @Override
    public Class<List> getTypeValue() {
        return List.class;
    }

    public void setType(Class<? extends UIFormInputBase> clazz) {
        this.clazz_ = clazz;
        Constructor<?>[] constructors = this.clazz_.getConstructors();
        if (constructors.length > 0) {
            this.constructor_ = constructors[0];
        }
    }

    public void setConstructorParameterTypes(Class<?> ... constructorParameterTypes) throws SecurityException, NoSuchMethodException {
        Constructor<? extends UIFormInputBase> constructor = this.clazz_.getConstructor(constructorParameterTypes);
        if (constructor != null) {
            this.constructor_ = constructor;
        }
    }

    public void setConstructorParameterValues(Object[] values) throws SecurityException {
        this.constructorParams_ = values;
    }

    public Class<? extends UIFormInputBase> getUIFormInputBase() {
        return this.clazz_;
    }

    @Override
    public List<?> getValue() {
        ArrayList values = new ArrayList();
        for (UIComponent child : this.getChildren()) {
            UIFormInputBase uiInput = (UIFormInputBase)child;
            if (uiInput.getValue() == null) continue;
            values.add(uiInput.getValue());
        }
        return values;
    }

    @Override
    public UIFormInput setValue(List<?> values) throws Exception {
        this.getChildren().clear();
        for (int i = 0; i < values.size(); ++i) {
            UIFormInputBase uiInput = this.createUIFormInput(i);
            uiInput.setValue(values.get(i));
        }
        return this;
    }

    public boolean isEnable() {
        return this.enable_;
    }

    public UIFormMultiValueInputSet setEnable(boolean enable) {
        this.enable_ = enable;
        return this;
    }

    public boolean isEditable() {
        return !this.readonly_;
    }

    public UIFormMultiValueInputSet setEditable(boolean editable) {
        this.readonly_ = !editable;
        return this;
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        super.processDecode(context);
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String action = uiForm.getSubmitAction();
        Event event = this.createEvent(action, Event.Phase.DECODE, context);
        if (event == null) {
            return;
        }
        event.broadcast();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        JavascriptManager jsMan = context.getJavascriptManager();
        jsMan.require("SHARED/jquery", "$").require("SHARED/bts_tooltip").addScripts("$('.multiValueContainer *[rel=\"tooltip\"]').tooltip();");
        if (this.getChildren() == null || this.getChildren().size() < 1) {
            this.createUIFormInput(0);
        }
        Writer writer = context.getWriter();
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        int size = this.getChildren().size();
        ResourceBundle res = context.getApplicationResourceBundle();
        String addItem = res.getString("UIFormMultiValueInputSet.label.add");
        String removeItem = res.getString("UIFormMultiValueInputSet.label.remove");
        writer.append("<ul class=\"multiValueContainer\">");
        for (int i = 0; i < size; ++i) {
            UIFormInputBase uiInput = (UIFormInputBase)this.getChild(i);
            writer.append("<li>");
            uiInput.setReadOnly(this.readonly_);
            uiInput.setDisabled(!this.enable_);
            uiInput.processRender(context);
            if (size >= 2 || size == 1 && uiInput.getValue() != null) {
                writer.append("<a class=\"actionIcon\" onclick=\"");
                writer.append(uiForm.event("Remove", uiInput.getId())).append("\" data-placement=\"bottom\" rel=\"tooltip\" title=\"" + removeItem + "\">");
                writer.append("<i class=\"uiIconTrash uiIconLightGray\"></i></a>");
            }
            if (i == size - 1) {
                writer.append("<a class=\"actionIcon\" onclick=\"");
                writer.append(uiForm.event("Add", this.getId())).append("\" data-placement=\"bottom\" rel=\"tooltip\" title=\"" + addItem + "\">");
                writer.append("<i class=\"uiIconPlus uiIconLightGray\"></i></a>");
            }
            writer.append("</li>");
        }
        writer.append("</ul>");
    }

    public UIFormInputBase createUIFormInput(int idx) throws Exception {
        UIFormInputBase inputBase;
        if (this.constructor_ == null) {
            return null;
        }
        Class<?>[] classes = this.constructor_.getParameterTypes();
        String compName = this.getId() + String.valueOf(idx);
        if (classes.length > 0) {
            if (this.constructorParams_ == null) {
                Object[] params = new Object[classes.length];
                for (int i = 0; i < classes.length; ++i) {
                    if (!classes[i].isPrimitive()) continue;
                    params[i] = classes[i] == Boolean.TYPE ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0);
                }
                params[0] = compName;
                inputBase = (UIFormInputBase)this.constructor_.newInstance(params);
            } else {
                inputBase = (UIFormInputBase)this.constructor_.newInstance(this.constructorParams_);
            }
        } else {
            inputBase = (UIFormInputBase)this.constructor_.newInstance(new Object[0]);
        }
        inputBase.setName(compName);
        inputBase.setId(compName);
        List<Validator> validators = this.getValidators();
        if (validators != null) {
            for (Validator validator : validators) {
                inputBase.addValidator(validator.getClass(), new Object[0]);
            }
        }
        this.addChild((UIComponent)inputBase);
        return inputBase;
    }

    public static class RemoveActionListener
    extends EventListener<UIFormMultiValueInputSet> {
        public void execute(Event<UIFormMultiValueInputSet> event) throws Exception {
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)event.getSource();
            String id = event.getRequestContext().getRequestParameter("objectId");
            uiSet.removeChildById(id);
        }
    }

    public static class AddActionListener
    extends EventListener<UIFormMultiValueInputSet> {
        public void execute(Event<UIFormMultiValueInputSet> event) throws Exception {
            List children;
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)event.getSource();
            String id = event.getRequestContext().getRequestParameter("objectId");
            if (uiSet.getId().equals(id) && (children = uiSet.getChildren()).size() > 0) {
                UIFormInputBase uiInput = (UIFormInputBase)children.get(children.size() - 1);
                String index = uiInput.getId();
                int maxIndex = Integer.parseInt(index.replaceAll(id, ""));
                uiSet.createUIFormInput(maxIndex + 1);
            }
        }
    }
}

