/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import javax.imageio.ImageIO;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentNodeList;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeExplorer;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeNodePageIterator;
import org.exoplatform.ecm.webui.presentation.AbstractActionComponent;
import org.exoplatform.ecm.webui.presentation.UIBaseNodePresentation;
import org.exoplatform.ecm.webui.presentation.removeattach.RemoveAttachmentComponent;
import org.exoplatform.ecm.webui.presentation.removecomment.RemoveCommentComponent;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.documents.DocumentTypeService;
import org.exoplatform.services.cms.documents.FavoriteService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.link.NodeLinkAware;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.thumbnail.ThumbnailPlugin;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.cms.timeline.TimelineService;
import org.exoplatform.services.cms.voting.VotingService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.audit.AuditHistory;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.ext.UIExtensionManager;

@ComponentConfig(events={@EventConfig(listeners={ChangeNodeActionListener.class}), @EventConfig(listeners={ViewNodeActionListener.class}), @EventConfig(listeners={SortActionListener.class}), @EventConfig(listeners={VoteActionListener.class}), @EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={DownloadActionListener.class}), @EventConfig(listeners={StarClickActionListener.class}), @EventConfig(listeners={ShowPageActionListener.class}), @EventConfig(listeners={SortTimelineASCActionListener.class}), @EventConfig(listeners={SortTimelineDESCActionListener.class}), @EventConfig(listeners={ExpandTimelineCatergoryActionListener.class}), @EventConfig(listeners={CollapseTimelineCatergoryActionListener.class}), @EventConfig(listeners={SwitchToAudioDescriptionActionListener.class}), @EventConfig(listeners={SwitchToOriginalActionListener.class})})
public class UIDocumentInfo
extends UIBaseNodePresentation {
    protected static final String NO = "NO";
    protected static final String YES = "YES";
    protected static final String COMMENT_COMPONENT = "Comment";
    protected static final String Contents_Document_Type = "Content";
    protected static final String CATEGORY_ALL = "All";
    protected static final String CATEGORY_TODAY = "UIDocumentInfo.label.Today";
    protected static final String CATEGORY_YESTERDAY = "UIDocumentInfo.label.Yesterday";
    protected static final String CATEGORY_WEEK = "UIDocumentInfo.label.EarlierThisWeek";
    protected static final String CATEGORY_MONTH = "UIDocumentInfo.label.EarlierThisMonth";
    protected static final String CATEGORY_YEAR = "UIDocumentInfo.label.EarlierThisYear";
    protected static final String CONTENT_PAGE_ITERATOR_ID = "ContentPageIterator";
    protected static final String CONTENT_TODAY_PAGE_ITERATOR_ID = "ContentTodayPageIterator";
    protected static final String CONTENT_YESTERDAY_PAGE_ITERATOR_ID = "ContentYesterdayPageIterator";
    protected static final String CONTENT_WEEK_PAGE_ITERATOR_ID = "ContentWeekPageIterator";
    protected static final String CONTENT_MONTH_PAGE_ITERATOR_ID = "ContentMonthPageIterator";
    protected static final String CONTENT_YEAR_PAGE_ITERATOR_ID = "ContentYearPageIterator";
    protected UIDocumentNodeList documentNodeList_;
    private static final Log LOG = ExoLogger.getLogger((String)UIDocumentInfo.class.getName());
    private String typeSort_ = "Type";
    private String sortOrder_ = "Up";
    private String displayCategory_;
    private int itemsPerTimeline;
    private NodeLocation currentNode_;
    private UIPageIterator pageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "ContentPageIterator");
    private UIPageIterator todayPageIterator_;
    private UIPageIterator yesterdayPageIterator_;
    private UIPageIterator earlierThisWeekPageIterator_;
    private UIPageIterator earlierThisMonthPageIterator_;
    private UIPageIterator earlierThisYearPageIterator_;
    private String timeLineSortByFavourite = "";
    private String timeLineSortByName = "";
    private String timeLineSortByDate = "Up";
    private FavoriteService favoriteService;
    private DocumentTypeService documentTypeService;
    private TemplateService templateService;
    private HashMap<String, String> isExpanded_;
    private boolean updateTimeLineData_ = false;
    private Set<String> expandedFolders_;

    public UIDocumentInfo() throws Exception {
        this.documentNodeList_ = (UIDocumentNodeList)this.addChild(UIDocumentNodeList.class, null, null);
        this.documentNodeList_.setShowMoreButton(false);
        this.todayPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, CONTENT_TODAY_PAGE_ITERATOR_ID);
        this.yesterdayPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, CONTENT_YESTERDAY_PAGE_ITERATOR_ID);
        this.earlierThisWeekPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, CONTENT_WEEK_PAGE_ITERATOR_ID);
        this.earlierThisMonthPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, CONTENT_MONTH_PAGE_ITERATOR_ID);
        this.earlierThisYearPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, CONTENT_YEAR_PAGE_ITERATOR_ID);
        this.favoriteService = (FavoriteService)this.getApplicationComponent(FavoriteService.class);
        this.documentTypeService = (DocumentTypeService)this.getApplicationComponent(DocumentTypeService.class);
        this.templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        this.displayCategory_ = CATEGORY_ALL;
        this.isExpanded_ = new HashMap();
        this.expandedFolders_ = new HashSet<String>();
    }

    public void checkTimelineUpdate() throws Exception {
        if (this.updateTimeLineData_) {
            this.updateNodeLists();
            this.updateTimeLineData_ = false;
        }
    }

    public String getTimeLineSortByFavourite() {
        return this.timeLineSortByFavourite;
    }

    public void setTimeLineSortByFavourite(String timeLineSortByFavourite) {
        this.timeLineSortByFavourite = timeLineSortByFavourite;
    }

    public String getTimeLineSortByName() {
        return this.timeLineSortByName;
    }

    public void setTimeLineSortByName(String timeLineSortByName) {
        this.timeLineSortByName = timeLineSortByName;
    }

    public String getTimeLineSortByDate() {
        return this.timeLineSortByDate;
    }

    public void setTimeLineSortByDate(String timeLineSortByDate) {
        this.timeLineSortByDate = timeLineSortByDate;
    }

    public void updateNodeLists() throws Exception {
        int nodesPerPage;
        TimelineService timelineService = (TimelineService)this.getApplicationComponent(TimelineService.class);
        this.itemsPerTimeline = timelineService.getItemPerTimeline();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        SessionProvider sessionProvider = uiExplorer.getSessionProvider();
        Session session = uiExplorer.getSession();
        String workspace = this.getWorkspaceName();
        String userName = session.getUserID();
        String nodePath = uiExplorer.getCurrentPath();
        String tagPath = uiExplorer.getTagPath();
        boolean isViewTag = uiExplorer.isViewTag();
        boolean isLimit = false;
        List<NodeLocation> todayNodes = new ArrayList();
        List<NodeLocation> yesterdayNodes = new ArrayList();
        List<NodeLocation> earlierThisWeekNodes = new ArrayList();
        List<Object> earlierThisMonthNodes = new ArrayList();
        List<Object> earlierThisYearNodes = new ArrayList();
        this.isExpanded_ = new HashMap();
        if (CATEGORY_ALL.equalsIgnoreCase(this.displayCategory_)) {
            nodesPerPage = Integer.MAX_VALUE;
            todayNodes = NodeLocation.getLocationsByNodeList((List)timelineService.getDocumentsOfToday(nodePath, workspace, sessionProvider, userName, false, isLimit));
            if (todayNodes.size() > this.getItemsPerTimeline()) {
                this.isExpanded_.put(CATEGORY_TODAY, YES);
                todayNodes = todayNodes.subList(0, this.getItemsPerTimeline());
            } else {
                this.isExpanded_.put(CATEGORY_TODAY, NO);
            }
            yesterdayNodes = NodeLocation.getLocationsByNodeList((List)timelineService.getDocumentsOfYesterday(nodePath, workspace, sessionProvider, userName, false, isLimit));
            if (yesterdayNodes.size() > this.getItemsPerTimeline()) {
                this.isExpanded_.put(CATEGORY_YESTERDAY, YES);
                yesterdayNodes = yesterdayNodes.subList(0, this.getItemsPerTimeline());
            } else {
                this.isExpanded_.put(CATEGORY_YESTERDAY, NO);
            }
            earlierThisWeekNodes = NodeLocation.getLocationsByNodeList((List)timelineService.getDocumentsOfEarlierThisWeek(nodePath, workspace, sessionProvider, userName, false, isLimit));
            if (earlierThisWeekNodes.size() > this.getItemsPerTimeline()) {
                this.isExpanded_.put(CATEGORY_WEEK, YES);
                earlierThisWeekNodes = earlierThisWeekNodes.subList(0, this.getItemsPerTimeline());
            } else {
                this.isExpanded_.put(CATEGORY_WEEK, NO);
            }
            earlierThisMonthNodes = NodeLocation.getLocationsByNodeList((List)timelineService.getDocumentsOfEarlierThisMonth(nodePath, workspace, sessionProvider, userName, false, isLimit));
            if (earlierThisMonthNodes.size() > this.getItemsPerTimeline()) {
                this.isExpanded_.put(CATEGORY_MONTH, YES);
                earlierThisMonthNodes = earlierThisMonthNodes.subList(0, this.getItemsPerTimeline());
            } else {
                this.isExpanded_.put(CATEGORY_MONTH, NO);
            }
            earlierThisYearNodes = NodeLocation.getLocationsByNodeList((List)timelineService.getDocumentsOfEarlierThisYear(nodePath, workspace, sessionProvider, userName, false, isLimit));
            if (earlierThisYearNodes.size() > this.getItemsPerTimeline()) {
                this.isExpanded_.put(CATEGORY_YEAR, YES);
                earlierThisYearNodes = earlierThisYearNodes.subList(0, this.getItemsPerTimeline());
            } else {
                this.isExpanded_.put(CATEGORY_YEAR, NO);
            }
        } else {
            nodesPerPage = uiExplorer.getPreference().getNodesPerPage();
            if (CATEGORY_TODAY.equalsIgnoreCase(this.displayCategory_)) {
                todayNodes = NodeLocation.getLocationsByNodeList((List)timelineService.getDocumentsOfToday(nodePath, workspace, sessionProvider, userName, false, isLimit));
            } else if (CATEGORY_YESTERDAY.equalsIgnoreCase(this.displayCategory_)) {
                yesterdayNodes = NodeLocation.getLocationsByNodeList((List)timelineService.getDocumentsOfYesterday(nodePath, workspace, sessionProvider, userName, false, isLimit));
            } else if (CATEGORY_WEEK.equalsIgnoreCase(this.displayCategory_)) {
                earlierThisWeekNodes = NodeLocation.getLocationsByNodeList((List)timelineService.getDocumentsOfEarlierThisWeek(nodePath, workspace, sessionProvider, userName, false, isLimit));
            } else if (CATEGORY_MONTH.equalsIgnoreCase(this.displayCategory_)) {
                earlierThisMonthNodes = NodeLocation.getLocationsByNodeList((List)timelineService.getDocumentsOfEarlierThisMonth(nodePath, workspace, sessionProvider, userName, false, isLimit));
            } else if (CATEGORY_YEAR.equalsIgnoreCase(this.displayCategory_)) {
                earlierThisYearNodes = NodeLocation.getLocationsByNodeList((List)timelineService.getDocumentsOfEarlierThisYear(nodePath, workspace, sessionProvider, userName, false, isLimit));
            }
        }
        if (isViewTag && tagPath != null) {
            if (todayNodes.size() > 0) {
                todayNodes = this.filterDocumentsByTag(todayNodes, tagPath);
            }
            if (yesterdayNodes.size() > 0) {
                yesterdayNodes = this.filterDocumentsByTag(yesterdayNodes, tagPath);
            }
            if (earlierThisWeekNodes.size() > 0) {
                earlierThisWeekNodes = this.filterDocumentsByTag(earlierThisWeekNodes, tagPath);
            }
            if (earlierThisMonthNodes.size() > 0) {
                earlierThisMonthNodes = this.filterDocumentsByTag(earlierThisMonthNodes, tagPath);
            }
            if (earlierThisYearNodes.size() > 0) {
                earlierThisYearNodes = this.filterDocumentsByTag(earlierThisYearNodes, tagPath);
            }
        }
        Collections.sort(todayNodes, new SearchComparator());
        Collections.sort(yesterdayNodes, new SearchComparator());
        Collections.sort(earlierThisWeekNodes, new SearchComparator());
        Collections.sort(earlierThisMonthNodes, new SearchComparator());
        Collections.sort(earlierThisYearNodes, new SearchComparator());
        ListAccessImpl todayNodesList = new ListAccessImpl(NodeLocation.class, todayNodes);
        this.todayPageIterator_.setPageList((PageList)new LazyPageList((ListAccess)todayNodesList, nodesPerPage));
        ListAccessImpl yesterdayNodesList = new ListAccessImpl(NodeLocation.class, yesterdayNodes);
        this.yesterdayPageIterator_.setPageList((PageList)new LazyPageList((ListAccess)yesterdayNodesList, nodesPerPage));
        ListAccessImpl earlierThisWeekList = new ListAccessImpl(NodeLocation.class, earlierThisWeekNodes);
        this.earlierThisWeekPageIterator_.setPageList((PageList)new LazyPageList((ListAccess)earlierThisWeekList, nodesPerPage));
        ListAccessImpl earlierThisMonthList = new ListAccessImpl(NodeLocation.class, earlierThisMonthNodes);
        this.earlierThisMonthPageIterator_.setPageList((PageList)new LazyPageList((ListAccess)earlierThisMonthList, nodesPerPage));
        ListAccessImpl earlierThisYearList = new ListAccessImpl(NodeLocation.class, earlierThisYearNodes);
        this.earlierThisYearPageIterator_.setPageList((PageList)new LazyPageList((ListAccess)earlierThisYearList, nodesPerPage));
    }

    public List<NodeLocation> filterDocumentsByTag(List<NodeLocation> nodes, String path) throws Exception {
        ArrayList<Node> documents = new ArrayList<Node>();
        Session session = null;
        Node node = null;
        QueryManager queryManager = null;
        QueryResult queryResult = null;
        Query query = null;
        NodeIterator nodeIterator = null;
        for (int i = 0; i < nodes.size(); ++i) {
            node = NodeLocation.getNodeByLocation((NodeLocation)nodes.get(i));
            if (!node.isNodeType("mix:referenceable")) continue;
            session = node.getSession();
            String queryString = "SELECT * FROM exo:symlink where jcr:path like '" + path + "/%' and exo:uuid = '" + node.getUUID() + "' and exo:workspace='" + node.getSession().getWorkspace().getName() + "'";
            queryManager = session.getWorkspace().getQueryManager();
            query = queryManager.createQuery(queryString, "sql");
            queryResult = query.execute();
            nodeIterator = queryResult.getNodes();
            if (nodeIterator.getSize() <= 0L) continue;
            documents.add(node);
        }
        return NodeLocation.getLocationsByNodeList(documents);
    }

    public String getDisplayCategory() {
        if (this.displayCategory_ == null || this.displayCategory_.trim().length() == 0) {
            return CATEGORY_ALL;
        }
        return this.displayCategory_;
    }

    public UIPageIterator getContentPageIterator() {
        return this.pageIterator_;
    }

    public UIPageIterator getTodayPageIterator() {
        return this.todayPageIterator_;
    }

    public UIPageIterator getYesterdayPageIterator() {
        return this.yesterdayPageIterator_;
    }

    public UIPageIterator getWeekPageIterator() {
        return this.earlierThisWeekPageIterator_;
    }

    public UIPageIterator getMonthPageIterator() {
        return this.earlierThisMonthPageIterator_;
    }

    public UIPageIterator getYearPageIterator() {
        return this.earlierThisYearPageIterator_;
    }

    public UIComponent getUIComponent(String mimeType) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getUIComponent((String)mimeType, (UIContainer)this);
    }

    public String getTemplate() {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (uiExplorer.getPreference().isJcrEnable()) {
            return uiExplorer.getDocumentInfoTemplate();
        }
        try {
            Node node = uiExplorer.getCurrentNode();
            String template = this.templateService.getTemplatePath(node, false);
            if (template != null) {
                return template;
            }
        }
        catch (AccessDeniedException ace) {
            try {
                uiExplorer.setSelectRootNode();
                Object[] args = new Object[]{uiExplorer.getCurrentNode().getName()};
                throw new MessageException(new ApplicationMessage("UIDocumentInfo.msg.access-denied", args, 1));
            }
            catch (Exception exc) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)exc.getMessage());
                }
            }
        }
        catch (Exception e) {
            return uiExplorer.getDocumentInfoTemplate();
        }
        return uiExplorer.getDocumentInfoTemplate();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public UIRightClickPopupMenu getContextMenu() {
        return (UIRightClickPopupMenu)((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getChild(UIRightClickPopupMenu.class);
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        String[] workspaces;
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
        for (String ws : workspaces = manageRepo.getWorkspaceNames()) {
            try {
                return WCMCoreUtils.getSystemSessionProvider().getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public String getCapacityOfFile(Node file) throws Exception {
        Node contentNode = file.getNode("jcr:content");
        long size = contentNode.getProperty("jcr:data").getLength();
        long capacity = size / 1024L;
        String strCapacity = Long.toString(capacity);
        if (strCapacity.indexOf(".") > -1) {
            return strCapacity.substring(0, strCapacity.lastIndexOf("."));
        }
        return strCapacity;
    }

    public List<String> getMultiValues(Node node, String name) throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getMultiValues(node, name);
    }

    public boolean isSystemWorkspace() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        ManageableRepository manaRepoService = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
        String systemWsName = manaRepoService.getConfiguration().getSystemWorkspaceName();
        return systemWsName.equals(uiExplorer.getCurrentWorkspace());
    }

    public boolean isSupportedThumbnailImage(Node node) throws Exception {
        if (node.isNodeType("nt:file")) {
            Node contentNode = node.getNode("jcr:content");
            ThumbnailService thumbnailService = (ThumbnailService)this.getApplicationComponent(ThumbnailService.class);
            for (ComponentPlugin plugin : thumbnailService.getComponentPlugins()) {
                ThumbnailPlugin thumbnailPlugin;
                if (!(plugin instanceof ThumbnailPlugin) || !(thumbnailPlugin = (ThumbnailPlugin)plugin).getMimeTypes().contains(contentNode.getProperty("jcr:mimeType").getString())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isImageType(Node node) throws Exception {
        Node contentNode;
        return node.isNodeType("nt:file") && (contentNode = node.getNode("jcr:content")).getProperty("jcr:mimeType").getString().startsWith("image");
    }

    public String getThumbnailImage(Node node) throws Exception {
        node = node instanceof NodeLinkAware ? ((NodeLinkAware)node).getTargetNode().getRealNode() : node;
        return org.exoplatform.ecm.webui.utils.Utils.getThumbnailImage((Node)node, (String)"exo:mediumSize");
    }

    public Node getThumbnailNode(Node node) throws Exception {
        ThumbnailService thumbnailService = (ThumbnailService)this.getApplicationComponent(ThumbnailService.class);
        LinkManager linkManager = (LinkManager)this.getApplicationComponent(LinkManager.class);
        if (!linkManager.isLink((Item)node) || linkManager.isTargetReachable(node)) {
            node = node instanceof NodeLinkAware ? ((NodeLinkAware)node).getTargetNode().getRealNode() : node;
        }
        return thumbnailService.getThumbnailNode(node);
    }

    public String getDownloadLink(Node node) throws Exception {
        return Utils.getDownloadLink((Node)node);
    }

    public String getImage(Node node) throws Exception {
        return this.getImage(node, "exo:image");
    }

    public String getImage(Node node, String nodeTypeName) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode(nodeTypeName);
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getImage(InputStream input, String nodeName) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(nodeName);
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName();
        int serverPort = portletRequestContext.getRequest().getServerPort();
        if (serverPort != 80) {
            prefixWebDAV = prefixWebDAV + ":" + String.format("%s", serverPort);
        }
        return prefixWebDAV;
    }

    public Node getViewNode(String nodeType) throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode().getNode(nodeType);
    }

    public Node getNodeByPath(String nodePath, String workspace) throws Exception {
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
        Session session = WCMCoreUtils.getUserSessionProvider().getSession(workspace, manageRepo);
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getNodeByPath(nodePath, session);
    }

    public String getActionsList(Node node) throws Exception {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getActionsExtensionList(node);
    }

    public List<Node> getCustomActions(Node node) throws Exception {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getCustomActions(node);
    }

    public boolean isPreferenceNode(Node node) throws Exception {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).isPreferenceNode(node);
    }

    public boolean isReadAuthorized(ExtendedNode node) throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).isReadAuthorized(node);
    }

    public Object getComponentInstanceOfType(String className) {
        Object service;
        block2: {
            service = null;
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = loader.loadClass(className);
                service = this.getApplicationComponent(clazz);
            }
            catch (ClassNotFoundException ex) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"Unexpected error", (Throwable)ex);
            }
        }
        return service;
    }

    public String getNodeOwner(Node node) throws RepositoryException {
        if (node.hasProperty("exo:owner")) {
            return node.getProperty("exo:owner").getString();
        }
        return IdentityConstants.ANONIM;
    }

    public Date getDateCreated(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            return node.getProperty("exo:dateCreated").getDate().getTime();
        }
        return new GregorianCalendar().getTime();
    }

    public Date getDateModified(Node node) throws Exception {
        if (node.hasProperty("exo:dateModified")) {
            return node.getProperty("exo:dateModified").getDate().getTime();
        }
        return new GregorianCalendar().getTime();
    }

    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        Node currentNode = this.getCurrentNode();
        if (currentNode.hasProperty("exo:relation")) {
            Value[] vals = currentNode.getProperty("exo:relation").getValues();
            for (int i = 0; i < vals.length; ++i) {
                String uuid = vals[i].getString();
                Node node = this.getNodeByUUID(uuid);
                if (node == null) continue;
                relations.add(node);
            }
        }
        return relations;
    }

    public List<Node> getAttachments() throws Exception {
        ArrayList<Node> attachments = new ArrayList<Node>();
        Node currentNode = this.getCurrentNode();
        NodeIterator childrenIterator = currentNode.getNodes();
        int attachData = 0;
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            String nodeType = childNode.getPrimaryNodeType().getName();
            List listCanCreateNodeType = org.exoplatform.ecm.webui.utils.Utils.getListAllowedFileType((Node)currentNode, (TemplateService)this.templateService);
            if (!listCanCreateNodeType.contains(nodeType)) continue;
            if (childNode.hasProperty("jcr:data")) {
                attachData = childNode.getProperty("jcr:data").getStream().available();
                if (attachData <= 0) continue;
                attachments.add(childNode);
                continue;
            }
            attachments.add(childNode);
        }
        return attachments;
    }

    public String getViewableLink(Node attNode, Parameter[] params) throws Exception {
        return this.event("ChangeNode", org.exoplatform.ecm.webui.utils.Utils.formatNodeName((String)attNode.getPath()), params);
    }

    public boolean isNodeTypeSupported(String nodeTypeName) {
        try {
            return this.templateService.isManagedNodeType(nodeTypeName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getNodeType() throws Exception {
        return null;
    }

    public List<String> getSupportedLocalise() throws Exception {
        MultiLanguageService multiLanguageService = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
        return multiLanguageService.getSupportedLanguages(this.getCurrentNode());
    }

    public String getTemplatePath() throws Exception {
        return null;
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public String getVersionName(Node node) throws Exception {
        return node.getBaseVersion().getName();
    }

    public boolean hasAuditHistory(Node node) throws Exception {
        AuditService auServ = (AuditService)WCMCoreUtils.getService(AuditService.class);
        node = node instanceof NodeLinkAware ? ((NodeLinkAware)node).getTargetNode().getRealNode() : node;
        return auServ.hasHistory(node);
    }

    public int getNumAuditHistory(Node node) throws Exception {
        AuditService auServ = (AuditService)WCMCoreUtils.getService(AuditService.class);
        Node node2 = node = node instanceof NodeLinkAware ? ((NodeLinkAware)node).getTargetNode().getRealNode() : node;
        if (auServ.hasHistory(node)) {
            AuditHistory auHistory = auServ.getHistory(node);
            return auHistory.getAuditRecords().size();
        }
        return 0;
    }

    public void setNode(Node node) {
        this.currentNode_ = NodeLocation.getNodeLocationByNode((Node)node);
    }

    public boolean isRssLink() {
        return false;
    }

    public String getRssLink() {
        return null;
    }

    public String getPortalName() {
        return WCMCoreUtils.getPortalName();
    }

    public String getRepository() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
    }

    public String getWorkspaceName() throws Exception {
        if (this.currentNode_ == null) {
            return this.getOriginalNode().getSession().getWorkspace().getName();
        }
        return this.getCurrentNode().getSession().getWorkspace().getName();
    }

    public Node getDisplayNode() throws Exception {
        Node currentNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        this.currentNode_ = NodeLocation.getNodeLocationByNode((Node)currentNode);
        if (currentNode.hasProperty("exo:language")) {
            String defaultLang = currentNode.getProperty("exo:language").getString();
            if (this.getLanguage() == null) {
                this.setLanguage(defaultLang);
            }
            if (!this.getLanguage().equals(defaultLang)) {
                MultiLanguageService multiServ = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
                Node curNode = multiServ.getLanguage(currentNode, this.getLanguage());
                if (currentNode.isNodeType("nt:folder") || currentNode.isNodeType("nt:unstructured")) {
                    try {
                        return curNode.getNode(currentNode.getName());
                    }
                    catch (Exception e) {
                        return curNode;
                    }
                }
                return curNode;
            }
        }
        return currentNode;
    }

    public Node getNode() throws Exception {
        Node audioDescription;
        Node ret = this.getDisplayNode();
        if ("DISPLAY".equals(this.getMediaState()) && ret.isNodeType("exo:accessibleMedia") && (audioDescription = org.exoplatform.services.cms.impl.Utils.getChildOfType((Node)ret, (String)"exo:audioDescription")) != null) {
            return audioDescription;
        }
        return ret;
    }

    public Node getCurrentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentNode_);
    }

    public Node getOriginalNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    public String getIcons(Node node, String size) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getNodeTypeIcon((Node)node, (String)size);
    }

    public List<Node> getComments() throws Exception {
        return ((CommentsService)this.getApplicationComponent(CommentsService.class)).getComments(this.getCurrentNode(), this.getLanguage());
    }

    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getTemplatePath(false, nodeTypeName, templateName);
    }

    public String getTemplateSkin(String nodeTypeName, String skinName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getSkinPath(nodeTypeName, skinName, this.getLanguage());
    }

    public String getLanguage() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getLanguage();
    }

    public void setLanguage(String language) {
        ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).setLanguage(language);
    }

    public boolean isCanPaste() {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return uiExplorer.getAllClipBoard().size() > 0;
    }

    public void updatePageListData() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        String currentPath = uiExplorer.getCurrentPath();
        LazyPageList<Object> pageList = this.getPageList(currentPath);
        this.pageIterator_.setPageList(pageList);
        if (this.documentNodeList_ != null) {
            this.documentNodeList_.removeChild(UIDocumentNodeList.class);
            this.documentNodeList_.setPageList((PageList)pageList);
        }
        this.updateTimeLineData_ = true;
    }

    public LazyPageList<Object> getPageList(String path) throws Exception {
        Set<String> allItemByTypeFilterMap;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Preference pref = uiExplorer.getPreference();
        int nodesPerPage = pref.getNodesPerPage();
        List<Object> nodeList = new ArrayList();
        nodeList = !uiExplorer.isViewTag() ? ((allItemByTypeFilterMap = uiExplorer.getAllItemByTypeFilterMap()).size() > 0 ? this.filterNodeList(uiExplorer.getChildrenList(path, !pref.isShowPreferenceDocuments())) : this.filterNodeList(uiExplorer.getChildrenList(path, pref.isShowPreferenceDocuments()))) : uiExplorer.getDocumentByTag();
        ListAccessImpl nodeAccList = new ListAccessImpl(Object.class, NodeLocation.getLocationsByNodeList(nodeList));
        return new LazyPageList((ListAccess)nodeAccList, nodesPerPage);
    }

    public List<Node> getChildrenList() throws Exception {
        return NodeLocation.getNodeListByLocationList((List)this.pageIterator_.getCurrentPageData());
    }

    public String getTypeSort() {
        return this.typeSort_;
    }

    public void setTypeSort(String typeSort) {
        this.typeSort_ = typeSort;
    }

    public String getSortOrder() {
        return this.sortOrder_;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder_ = sortOrder;
    }

    public String encodeHTML(String text) {
        return org.exoplatform.ecm.webui.utils.Utils.encodeHTML((String)text);
    }

    public UIComponent getCommentComponent() {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIActionBar uiActionBar = (UIActionBar)uiExplorer.findFirstComponentOfType(UIActionBar.class);
        UIComponent uicomponent = uiActionBar.getUIAction(COMMENT_COMPONENT);
        return uicomponent != null ? uicomponent : this;
    }

    public boolean isEnableThumbnail() {
        ThumbnailService thumbnailService = (ThumbnailService)this.getApplicationComponent(ThumbnailService.class);
        return thumbnailService.isEnableThumbnail();
    }

    public String getFlowImage(Node node) throws Exception {
        node = node instanceof NodeLinkAware ? ((NodeLinkAware)node).getTargetNode().getRealNode() : node;
        return org.exoplatform.ecm.webui.utils.Utils.getThumbnailImage((Node)node, (String)"exo:bigSize");
    }

    public String getThumbnailSize(Node node) throws Exception {
        node = node instanceof NodeLinkAware ? ((NodeLinkAware)node).getTargetNode().getRealNode() : node;
        String imageSize = null;
        if (node.hasProperty("exo:bigSize")) {
            BufferedImage image = ImageIO.read(node.getProperty("exo:bigSize").getStream());
            imageSize = Integer.toString(((Image)image).getWidth(null)) + "x" + Integer.toString(((Image)image).getHeight(null));
        }
        return imageSize;
    }

    public DateFormat getSimpleDateFormat() {
        Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        return SimpleDateFormat.getDateTimeInstance(3, 3, locale);
    }

    public boolean isSymLink(Node node) throws RepositoryException {
        LinkManager linkManager = (LinkManager)this.getApplicationComponent(LinkManager.class);
        return linkManager.isLink((Item)node);
    }

    public UIComponent getRemoveAttach() throws Exception {
        this.removeChild(RemoveAttachmentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveAttachmentComponent.class, null, "DocumentInfoRemoveAttach");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIDocumentContainer.class));
        return uicomponent;
    }

    public UIComponent getRemoveComment() throws Exception {
        this.removeChild(RemoveCommentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveCommentComponent.class, null, "DocumentInfoRemoveComment");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIDocumentContainer.class, UIWorkingArea.class));
        return uicomponent;
    }

    public boolean isFavouriter(Node data) throws Exception {
        return this.isFavouriteNode(WCMCoreUtils.getRemoteUser(), data);
    }

    public boolean isFavouriteNode(String userName, Node node) throws Exception {
        return ((FavoriteService)this.getApplicationComponent(FavoriteService.class)).isFavoriter(userName, node);
    }

    public boolean isMediaType(Node data) throws Exception {
        if (!data.isNodeType("nt:file")) {
            return false;
        }
        String mimeType = data.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", mimeType);
        return manager.accept("org.exoplatform.ecm.dms.FileViewer", "VideoAudio", context);
    }

    public String getPropertyNameWithoutNamespace(String propertyName) {
        if (propertyName.indexOf(":") > -1) {
            return propertyName.split(":")[1];
        }
        return propertyName;
    }

    public String getPropertyValue(Node node, String propertyName) throws Exception {
        try {
            Property property = node.getProperty(propertyName);
            if (property != null) {
                int requiredType = property.getDefinition().getRequiredType();
                switch (requiredType) {
                    case 1: {
                        return property.getString();
                    }
                    case 5: {
                        return this.getSimpleDateFormat().format(property.getDate().getTime());
                    }
                }
            }
        }
        catch (PathNotFoundException PNE) {
            return "";
        }
        return "";
    }

    public DriveData getDrive(List<DriveData> lstDrive, Node node) throws RepositoryException {
        DriveData driveData = null;
        for (DriveData drive : lstDrive) {
            if (!node.getSession().getWorkspace().getName().equals(drive.getWorkspace()) || !node.getPath().contains(drive.getHomePath()) || !drive.getHomePath().equals("/")) continue;
            driveData = drive;
            break;
        }
        return driveData;
    }

    public List<Node> filterNodeList(List<Node> sourceNodeList) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        if (!this.hasFilters()) {
            return sourceNodeList;
        }
        for (Node node : sourceNodeList) {
            try {
                if (!this.filterOk(node)) continue;
                ret.add(node);
            }
            catch (Exception ex) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)ex.getMessage());
            }
        }
        return ret;
    }

    private boolean hasFilters() {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Set<String> allItemsFilterSet = uiExplorer.getAllItemFilterMap();
        Set<String> allItemsByTypeFilterSet = uiExplorer.getAllItemByTypeFilterMap();
        return allItemsByTypeFilterSet.size() > 0 || allItemsFilterSet.size() > 0;
    }

    private boolean filterOk(Node node) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Set<String> allItemsFilterSet = uiExplorer.getAllItemFilterMap();
        Set<String> allItemsByTypeFilterSet = uiExplorer.getAllItemByTypeFilterMap();
        String userId = WCMCoreUtils.getRemoteUser();
        if (allItemsFilterSet.contains("OwnedByMe") && !userId.equals(node.getProperty("exo:owner").getString())) {
            return false;
        }
        if (allItemsFilterSet.contains("Favorites") && !this.favoriteService.isFavoriter(userId, node)) {
            return false;
        }
        if (allItemsByTypeFilterSet.isEmpty()) {
            return true;
        }
        boolean found = false;
        try {
            block2: for (String documentType : allItemsByTypeFilterSet) {
                for (String mimeType : this.documentTypeService.getMimeTypes(documentType)) {
                    if (node.getNode("jcr:content").getProperty("jcr:mimeType").getString().indexOf(mimeType) < 0) continue;
                    found = true;
                    continue block2;
                }
            }
        }
        catch (PathNotFoundException ep) {
            // empty catch block
        }
        if (!found && allItemsByTypeFilterSet.contains(Contents_Document_Type)) {
            for (String contentType : this.templateService.getAllDocumentNodeTypes()) {
                if (!node.isNodeType(contentType)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public boolean isEnableComment() {
        return true;
    }

    public boolean isEnableVote() {
        return true;
    }

    public void setEnableComment(boolean value) {
    }

    public void setEnableVote(boolean value) {
    }

    public String getInlineEditingField(Node orgNode, String propertyName, String defaultValue, String inputType, String idGenerator, String cssClass, boolean isGenericProperty, String ... arguments) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getInlineEditingField((Node)orgNode, (String)propertyName, (String)defaultValue, (String)inputType, (String)idGenerator, (String)cssClass, (boolean)isGenericProperty, (String[])arguments);
    }

    public String getInlineEditingField(Node orgNode, String propertyName) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getInlineEditingField((Node)orgNode, (String)propertyName);
    }

    public int getItemsPerTimeline() {
        if (this.itemsPerTimeline <= 0) {
            return 5;
        }
        return this.itemsPerTimeline;
    }

    public HashMap<String, String> getIsExpanded() {
        return this.isExpanded_;
    }

    public Set<String> getExpandedFolders() {
        return this.expandedFolders_;
    }

    public boolean isDisplayAlternativeText() {
        try {
            Node node = this.getNode();
            return node.isNodeType("exo:accessibleMedia") && node.hasProperty("exo:alternativeText") && StringUtils.isNotEmpty((String)node.getProperty("exo:alternativeText").getString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean playAudioDescription() {
        try {
            Node node = this.getNode();
            return node.isNodeType("exo:accessibleMedia") && org.exoplatform.services.cms.impl.Utils.hasChild((Node)node, (String)"exo:audioDescription");
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean switchBackAudioDescription() {
        try {
            Node node = this.getNode();
            Node parent = node.getParent();
            return node.isNodeType("exo:audioDescription") && parent.isNodeType("exo:accessibleMedia");
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean canAddNode() throws Exception {
        Node currentNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        return this.canAddNode(currentNode);
    }

    public boolean canAddNode(Node node) throws Exception {
        if (node == null || !PermissionUtil.canAddNode((Node)node)) {
            return false;
        }
        ArrayList<NodeDefinition> defs = new ArrayList<NodeDefinition>();
        defs.addAll(Arrays.asList(node.getPrimaryNodeType().getChildNodeDefinitions()));
        for (NodeType mix : node.getMixinNodeTypes()) {
            defs.addAll(Arrays.asList(mix.getChildNodeDefinitions()));
        }
        for (NodeDefinition def : defs) {
            for (NodeType type : def.getRequiredPrimaryTypes()) {
                if (!"nt:file".equals(type.getName()) && !"nt:base".equals(type.getName()) && !"nt:hierarchyNode".equals(type.getName()) || !"*".equals(def.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public String getDragAndDropEvents(Node node) throws Exception {
        if (this.canAddNode(node)) {
            StringBuilder dragEvents = new StringBuilder().append("ondragover='eXo.ecm.MultiUpload.enableDragItemArea(event, this)' ").append("ondragleave='eXo.ecm.MultiUpload.disableDragItemArea(this)' ").append("ondragend='eXo.ecm.MultiUpload.disableDragItemArea(this)' ").append("onmouseout='eXo.ecm.MultiUpload.disableDragItemArea(this)' ");
            dragEvents.append("ondrop='eXo.ecm.MultiUpload.doDropItemArea(event, this,\"").append(node.getPath()).append("\")' ");
            return dragEvents.toString();
        }
        return "";
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.canAddNode()) {
            context.getJavascriptManager().require("SHARED/multiUpload", "multiUpload").addScripts("multiUpload.registerEvents('" + this.getId() + "');");
        } else {
            context.getJavascriptManager().require("SHARED/multiUpload", "multiUpload").addScripts("multiUpload.unregisterEvents();");
        }
        super.processRender(context);
    }

    public boolean hasChildren(Node node) {
        return false;
    }

    public List<Node> getChildrenFromNode(Node node) {
        return null;
    }

    public static class ExpandTimelineCatergoryActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiDocumentInfo.getAncestorOfType(UIJCRExplorer.class);
            String category = event.getRequestContext().getRequestParameter("objectId");
            uiDocumentInfo.displayCategory_ = category;
            uiExplorer.updateAjax(event);
        }
    }

    public static class CollapseTimelineCatergoryActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiDocumentInfo.getAncestorOfType(UIJCRExplorer.class);
            uiDocumentInfo.displayCategory_ = UIDocumentInfo.CATEGORY_ALL;
            uiExplorer.updateAjax(event);
        }
    }

    private class SearchComparator
    implements Comparator<NodeLocation> {
        private SearchComparator() {
        }

        @Override
        public int compare(NodeLocation nodeA, NodeLocation nodeB) {
            block7: {
                try {
                    Node node1 = NodeLocation.getNodeByLocation((NodeLocation)nodeA);
                    Node node2 = NodeLocation.getNodeByLocation((NodeLocation)nodeB);
                    if (UIDocumentInfo.this.timeLineSortByFavourite.length() != 0) {
                        int factor;
                        int n = factor = UIDocumentInfo.this.timeLineSortByFavourite.equals("Down") ? 1 : -1;
                        if (UIDocumentInfo.this.isFavouriter(node1)) {
                            return -1 * factor;
                        }
                        if (UIDocumentInfo.this.isFavouriter(node2)) {
                            return 1 * factor;
                        }
                        return 0;
                    }
                    if (UIDocumentInfo.this.timeLineSortByDate.length() != 0) {
                        int factor = UIDocumentInfo.this.timeLineSortByDate.equals("Down") ? 1 : -1;
                        Calendar c1 = node1.getProperty("exo:dateModified").getValue().getDate();
                        Calendar c2 = node2.getProperty("exo:dateModified").getValue().getDate();
                        return factor * c1.compareTo(c2);
                    }
                    if (UIDocumentInfo.this.timeLineSortByName.length() != 0) {
                        int factor = UIDocumentInfo.this.timeLineSortByName.equals("Down") ? 1 : -1;
                        String s1 = org.exoplatform.ecm.webui.utils.Utils.getTitle((Node)node1).toLowerCase();
                        String s2 = org.exoplatform.ecm.webui.utils.Utils.getTitle((Node)node2).toLowerCase();
                        return factor * s1.compareTo(s2);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block7;
                    LOG.error((Object)"Cannot compare nodes", (Throwable)e);
                }
            }
            return 0;
        }
    }

    public static class ShowPageActionListener
    extends EventListener<UIPageIterator> {
        public void execute(Event<UIPageIterator> event) throws Exception {
            UIPageIterator uiPageIterator = (UIPageIterator)event.getSource();
            if (!UIDocumentInfo.CONTENT_PAGE_ITERATOR_ID.equalsIgnoreCase(uiPageIterator.getId())) {
                return;
            }
            UIApplication uiApp = (UIApplication)uiPageIterator.getAncestorOfType(UIApplication.class);
            UIJCRExplorer explorer = (UIJCRExplorer)uiPageIterator.getAncestorOfType(UIJCRExplorer.class);
            UITreeExplorer treeExplorer = (UITreeExplorer)explorer.findFirstComponentOfType(UITreeExplorer.class);
            try {
                if (treeExplorer == null) {
                    return;
                }
                String componentId = explorer.getCurrentNode().getPath();
                UITreeNodePageIterator extendedPageIterator = treeExplorer.getUIPageIterator(componentId);
                if (extendedPageIterator == null) {
                    return;
                }
                int page = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
                extendedPageIterator.setCurrentPage(page);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)explorer);
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Repository cannot be found");
                }
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    public static class SwitchToOriginalActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiDocumentInfo.getAncestorOfType(UIJCRExplorer.class);
            uiDocumentInfo.switchMediaState();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiExplorer);
        }
    }

    public static class SwitchToAudioDescriptionActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiDocumentInfo.getAncestorOfType(UIJCRExplorer.class);
            uiDocumentInfo.switchMediaState();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiExplorer);
        }
    }

    public static class SortTimelineDESCActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)((Object)event.getSource());
            String objectID = event.getRequestContext().getRequestParameter("objectId");
            if (objectID.equals("favourite")) {
                uiDocumentInfo.timeLineSortByFavourite = "Up";
                uiDocumentInfo.timeLineSortByName = "";
                uiDocumentInfo.timeLineSortByDate = "";
            } else if (objectID.equals("name")) {
                uiDocumentInfo.timeLineSortByFavourite = "";
                uiDocumentInfo.timeLineSortByName = "Up";
                uiDocumentInfo.timeLineSortByDate = "";
            } else if (objectID.equals("dateTime")) {
                uiDocumentInfo.timeLineSortByFavourite = "";
                uiDocumentInfo.timeLineSortByName = "";
                uiDocumentInfo.timeLineSortByDate = "Up";
            }
            uiDocumentInfo.updateNodeLists();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentInfo);
        }
    }

    public static class SortTimelineASCActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)((Object)event.getSource());
            String objectID = event.getRequestContext().getRequestParameter("objectId");
            if (objectID.equals("favourite")) {
                uiDocumentInfo.timeLineSortByFavourite = "Down";
                uiDocumentInfo.timeLineSortByName = "";
                uiDocumentInfo.timeLineSortByDate = "";
            } else if (objectID.equals("name")) {
                uiDocumentInfo.timeLineSortByFavourite = "";
                uiDocumentInfo.timeLineSortByName = "Down";
                uiDocumentInfo.timeLineSortByDate = "";
            } else if (objectID.equals("dateTime")) {
                uiDocumentInfo.timeLineSortByFavourite = "";
                uiDocumentInfo.timeLineSortByName = "";
                uiDocumentInfo.timeLineSortByDate = "Down";
            }
            uiDocumentInfo.updateNodeLists();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentInfo);
        }
    }

    public static class StarClickActionListener
    extends EventListener<UIDocumentInfo> {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            String srcPath = event.getRequestContext().getRequestParameter("objectId");
            UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiDocumentInfo.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiDocumentInfo.getAncestorOfType(UIApplication.class);
            FavoriteService favoriteService = (FavoriteService)uiDocumentInfo.getApplicationComponent(FavoriteService.class);
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(srcPath);
            String wsName = null;
            Node node = null;
            if (!matcher.find()) {
                throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
            }
            wsName = matcher.group(1);
            srcPath = matcher.group(2);
            Session session = null;
            try {
                session = uiExplorer.getSessionByWorkspace(wsName);
                node = uiExplorer.getNodeByPath(srcPath, session, false);
                srcPath = node.getPath();
                session = node.getSession();
                wsName = session.getWorkspace().getName();
            }
            catch (PathNotFoundException path) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                return;
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Repository cannot be found");
                }
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            try {
                uiExplorer.addLockToken(node);
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            try {
                if (favoriteService.isFavoriter(WCMCoreUtils.getRemoteUser(), node)) {
                    if (!PermissionUtil.canRemoveNode((Node)node)) throw new AccessDeniedException();
                    favoriteService.removeFavorite(node, WCMCoreUtils.getRemoteUser());
                } else {
                    if (!PermissionUtil.canSetProperty((Node)node)) throw new AccessDeniedException();
                    favoriteService.addFavorite(node, WCMCoreUtils.getRemoteUser());
                }
                uiExplorer.updateAjax(event);
                return;
            }
            catch (AccessDeniedException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Access denied! No permission for modifying property exo:favouriter of node: " + node.getPath()));
                }
                uiApp.addMessage(new ApplicationMessage("UIShowAllFavouriteResult.msg.accessDenied", null, 1));
                return;
            }
            catch (VersionException ve) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.remove-verion-exception", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (ReferentialIntegrityException ref) {
                session.refresh(false);
                uiExplorer.refreshExplorer();
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.remove-referentialIntegrityException", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (ConstraintViolationException cons) {
                session.refresh(false);
                uiExplorer.refreshExplorer();
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.constraintviolation-exception", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (LockException lockException) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked-other-person", null, 1));
                uiExplorer.updateAjax(event);
                return;
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"an unexpected error occurs while removing the node", (Throwable)e);
                }
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    public static class DownloadActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uiComp = (UIDocumentInfo)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiComp.getAncestorOfType(UIApplication.class);
            try {
                String downloadLink = uiComp.getDownloadLink(Utils.getFileLangNode((Node)uiComp.getNode()));
                RequireJS requireJS = event.getRequestContext().getJavascriptManager().getRequireJS();
                requireJS.require("SHARED/ecm-utils", "ecmutil").addScripts("ecmutil.ECMUtils.ajaxRedirect('" + downloadLink + "');");
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Repository cannot be found");
                }
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    public static class VoteActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uiComp = (UIDocumentInfo)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiComp.getAncestorOfType(UIApplication.class);
            try {
                String userName = Util.getPortalRequestContext().getRemoteUser();
                double objId = Double.parseDouble(event.getRequestContext().getRequestParameter("objectId"));
                VotingService votingService = (VotingService)uiComp.getApplicationComponent(VotingService.class);
                votingService.vote(uiComp.getCurrentNode(), objId, userName, uiComp.getLanguage());
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Repository cannot be found");
                }
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    public static class ChangeLanguageActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiDocumentInfo.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiDocumentInfo.getAncestorOfType(UIApplication.class);
            try {
                String selectedLanguage = event.getRequestContext().getRequestParameter("objectId");
                uiExplorer.setLanguage(selectedLanguage);
                uiExplorer.updateAjax(event);
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Repository cannot be found");
                }
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    public static class SortActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uicomp = (UIDocumentInfo)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uicomp.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            try {
                String sortParam = event.getRequestContext().getRequestParameter("objectId");
                String[] array = sortParam.split(";");
                String order = "Ascending".equals(array[0].trim()) || !array[1].trim().equals(uicomp.getTypeSort()) ? "Down" : "Up";
                String prefOrder = "Ascending".equals(array[0].trim()) || !array[1].trim().equals(uicomp.getTypeSort()) ? "Ascending" : "Descending";
                uicomp.setSortOrder(order);
                uicomp.setTypeSort(array[1]);
                Preference pref = uiExplorer.getPreference();
                if (array.length != 2) {
                    return;
                }
                pref.setSortType(array[1].trim());
                pref.setOrder(prefOrder);
                uiExplorer.updateAjax(event);
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Repository cannot be found");
                }
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    public static class ChangeNodeActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uicomp = (UIDocumentInfo)((Object)event.getSource());
            NodeFinder nodeFinder = (NodeFinder)uicomp.getApplicationComponent(NodeFinder.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uicomp.getAncestorOfType(UIJCRExplorer.class);
            UITreeExplorer uiTreeExplorer = (UITreeExplorer)uiExplorer.findFirstComponentOfType(UITreeExplorer.class);
            String uri = event.getRequestContext().getRequestParameter("objectId");
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            boolean findDrive = Boolean.getBoolean(event.getRequestContext().getRequestParameter("findDrive"));
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            try {
                uri = LinkUtils.evaluatePath((String)uri);
                Item item = nodeFinder.getItem(workspaceName, uri);
                if (item instanceof Node && org.exoplatform.ecm.webui.utils.Utils.isInTrash((Node)((Node)item))) {
                    return;
                }
                uiExplorer.setSelectNode(workspaceName, uri);
                if (findDrive) {
                    ManageDriveService manageDriveService = (ManageDriveService)uicomp.getApplicationComponent(ManageDriveService.class);
                    List driveList = manageDriveService.getDriveByUserRoles(Util.getPortalRequestContext().getRemoteUser(), org.exoplatform.ecm.webui.utils.Utils.getMemberships());
                    DriveData drive = uicomp.getDrive(driveList, uiExplorer.getCurrentNode());
                    String warningMSG = null;
                    if (driveList.size() == 0) {
                        warningMSG = "UIDocumentInfo.msg.access-denied";
                    } else if (drive == null) {
                        warningMSG = "UIPopupMenu.msg.path-not-found-exception";
                    }
                    if (warningMSG != null) {
                        uiApp.addMessage(new ApplicationMessage(warningMSG, null, 1));
                        return;
                    }
                    uiExplorer.setDriveData(uicomp.getDrive(driveList, uiExplorer.getCurrentNode()));
                }
                uiExplorer.updateAjax(event);
                event.getRequestContext().getJavascriptManager().require("SHARED/multiUpload", "multiUpload").addScripts("multiUpload.setLocation('" + uiExplorer.getWorkspaceName() + "','" + uiExplorer.getDriveData().getName() + "','" + uiTreeExplorer.getLabel() + "','" + uiExplorer.getCurrentPath() + "','" + org.exoplatform.services.cms.impl.Utils.getPersonalDrivePath((String)uiExplorer.getDriveData().getHomePath(), (String)ConversationState.getCurrent().getIdentity().getUserId()) + "');");
            }
            catch (ItemNotFoundException nu) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.null-exception", null, 1));
                return;
            }
            catch (PathNotFoundException pa) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.path-not-found", null, 1));
                return;
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.access-denied", null, 1));
                return;
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Repository cannot be found");
                }
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    public static class ViewNodeActionListener
    extends EventListener<UIDocumentInfo> {
        public void execute(Event<UIDocumentInfo> event) throws Exception {
            UIDocumentInfo uicomp = (UIDocumentInfo)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uicomp.getAncestorOfType(UIJCRExplorer.class);
            try {
                String uri = event.getRequestContext().getRequestParameter("objectId");
                String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
                uiExplorer.setSelectNode(workspaceName, uri);
                uiExplorer.updateAjax(event);
                event.broadcast();
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Repository cannot be found");
                }
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }
}

