/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.gadget.impl;

import java.util.Calendar;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.gadget.Source;
import org.exoplatform.application.gadget.SourceStorage;
import org.exoplatform.application.gadget.impl.GadgetData;
import org.exoplatform.application.gadget.impl.GadgetDefinition;
import org.exoplatform.application.gadget.impl.GadgetRegistry;
import org.exoplatform.application.gadget.impl.GadgetRegistryServiceImpl;
import org.exoplatform.application.gadget.impl.LocalGadgetData;

public class SourceStorageImpl
implements SourceStorage {
    private GadgetRegistryServiceImpl gadgetRegistryService;

    public SourceStorageImpl(GadgetRegistryService gadgetRegistryService) {
        this.gadgetRegistryService = (GadgetRegistryServiceImpl)gadgetRegistryService;
    }

    @Override
    public Source getSource(Gadget gadget) throws Exception {
        GadgetDefinition def = this.gadgetRegistryService.getRegistry().getGadget(gadget.getName());
        if (def == null) {
            return null;
        }
        GadgetData data = def.getData();
        if (data instanceof LocalGadgetData) {
            LocalGadgetData localData = (LocalGadgetData)data;
            String content = localData.getSource();
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTime(localData.getLastModified());
            Source source = new Source(gadget.getName());
            source.setMimeType("application/x-google-gadget");
            source.setLastModified(lastModified);
            source.setTextContent(content);
            return source;
        }
        throw new IllegalArgumentException("The provided gadget is remote");
    }

    @Override
    public void saveSource(Gadget gadget, Source source) throws Exception {
        if (gadget == null) {
            throw new NullPointerException();
        }
        if (source == null) {
            throw new NullPointerException();
        }
        GadgetRegistry registry = this.gadgetRegistryService.getRegistry();
        GadgetDefinition def = registry.getGadget(gadget.getName());
        GadgetData data = def.getData();
        if (!(data instanceof LocalGadgetData)) {
            throw new IllegalArgumentException("The provided gadget is remote");
        }
        LocalGadgetData localData = (LocalGadgetData)data;
        localData.setSource(source.getTextContent());
    }

    @Override
    public void removeSource(String sourcePath) {
    }

    public String getSourceURI(String sourcePath) {
        throw new UnsupportedOperationException("Cannot obtain URI from source " + sourcePath);
    }
}

