/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.exoplatform.portal.resource.CommentBlockHandler;

public class SkipCommentReader
extends BufferedReader {
    private final StringBuilder pushbackCache = new StringBuilder();
    private static final int EOF = -1;
    private State cursorState = State.ENCOUNTING_ORDINARY_CHARACTER;
    private CommentBlockHandler commentBlockHandler;
    private int numberOfCommingEscapes;

    public SkipCommentReader(Reader reader) {
        this(reader, null);
    }

    public SkipCommentReader(Reader reader, CommentBlockHandler handler) {
        super(reader);
        this.commentBlockHandler = handler;
    }

    public int readSingleCharacter() throws IOException {
        int readingChar = this.readLikePushbackReader();
        if (readingChar == -1) {
            return -1;
        }
        if (this.numberOfCommingEscapes > 0) {
            --this.numberOfCommingEscapes;
            return readingChar;
        }
        switch (readingChar) {
            case 47: {
                int nextCharToRead = this.read();
                if (nextCharToRead == 42) {
                    this.cursorState = State.ENCOUNTING_COMMENT_BLOCK_OPENING_TAG;
                    this.advanceToEscapeCommentBlock();
                    return this.readSingleCharacter();
                }
                this.cursorState = State.ENCOUNTING_FORWARD_SLASH;
                this.pushbackCache.append((char)nextCharToRead);
                return 47;
            }
            case 42: {
                if (this.cursorState == State.ENCOUNTING_FORWARD_SLASH) {
                    this.cursorState = State.ENCOUNTING_COMMENT_BLOCK_OPENING_TAG;
                    this.advanceToEscapeCommentBlock();
                    return this.readSingleCharacter();
                }
                this.cursorState = State.ENCOUNTING_ASTERIK;
                return 42;
            }
        }
        this.cursorState = State.ENCOUNTING_ORDINARY_CHARACTER;
        return readingChar;
    }

    private int readLikePushbackReader() throws IOException {
        if (this.pushbackCache.length() > 0) {
            char readingChar = this.pushbackCache.charAt(0);
            this.pushbackCache.deleteCharAt(0);
            return readingChar;
        }
        return this.read();
    }

    private void advanceToEscapeCommentBlock() throws IOException {
        if (this.cursorState != State.ENCOUNTING_COMMENT_BLOCK_OPENING_TAG) {
            throw new IllegalStateException("This method should be invoked only if we are entering a comment block");
        }
        int readingChar = this.read();
        StringBuilder commentBlock = new StringBuilder("/*");
        while (readingChar != -1) {
            commentBlock.append((char)readingChar);
            if (readingChar == 47) {
                if (this.cursorState == State.ENCOUNTING_ASTERIK) {
                    this.cursorState = State.ENCOUNTING_COMMENT_BLOCK_CLOSING_TAG;
                    break;
                }
                this.cursorState = State.ENCOUNTING_FORWARD_SLASH;
            } else {
                this.cursorState = readingChar == 42 ? State.ENCOUNTING_ASTERIK : State.ENCOUNTING_ORDINARY_CHARACTER;
            }
            readingChar = this.read();
        }
        if (this.commentBlockHandler != null) {
            this.commentBlockHandler.handle(commentBlock, this);
        }
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder builder = new StringBuilder();
        int nextChar = this.readSingleCharacter();
        if (nextChar == -1) {
            return null;
        }
        while (nextChar != -1 && nextChar != 10 && nextChar != 13) {
            builder.append((char)nextChar);
            nextChar = this.readSingleCharacter();
        }
        return builder.toString().trim();
    }

    public State getCursorState() {
        return this.cursorState;
    }

    public void setCommentBlockHandler(CommentBlockHandler commentBlockHandler) {
        this.commentBlockHandler = commentBlockHandler;
    }

    public void setNumberOfCommingEscapes(int numberOfCommingEscapes) {
        this.numberOfCommingEscapes = numberOfCommingEscapes;
    }

    public void pushback(CharSequence sequence) {
        this.pushbackCache.append(sequence);
    }

    public static enum State {
        ENCOUNTING_FORWARD_SLASH,
        ENCOUNTING_ASTERIK,
        ENCOUNTING_COMMENT_BLOCK_OPENING_TAG,
        ENCOUNTING_COMMENT_BLOCK_CLOSING_TAG,
        ENCOUNTING_ORDINARY_CHARACTER;

    }
}

