/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;

public class WebUIPropertiesConfigService {
    public static final String SCV_POPUP_SIZE_EDIT_PORTLET_MODE = "SCV.popup.size.in.edit.portlet.mode";
    public static final String SCV_POPUP_SIZE_QUICK_EDIT = "SCV.popup.size.in.quickdedit";
    public static final String CLV_POPUP_SIZE_EDIT_PORTLET_MODE = "CLV.popup.size.in.edit.portlet.mode";
    public static final String CLV_POPUP_SIZE_QUICK_EDIT = "CLV.popup.size.in.quickedit";
    private ConcurrentHashMap<String, Object> propertiesMap = new ConcurrentHashMap();

    public WebUIPropertiesConfigService(InitParams params) {
        Iterator iterator = params.getPropertiesParamIterator();
        while (iterator.hasNext()) {
            PopupWindowProperties properties;
            PropertiesParam propertiesParam = (PropertiesParam)iterator.next();
            if (SCV_POPUP_SIZE_EDIT_PORTLET_MODE.equalsIgnoreCase(propertiesParam.getName())) {
                properties = this.readPropertiesFromXML(propertiesParam);
                this.propertiesMap.put(SCV_POPUP_SIZE_EDIT_PORTLET_MODE, properties);
                continue;
            }
            if (SCV_POPUP_SIZE_QUICK_EDIT.equals(propertiesParam.getName())) {
                properties = this.readPropertiesFromXML(propertiesParam);
                this.propertiesMap.put(SCV_POPUP_SIZE_QUICK_EDIT, properties);
                continue;
            }
            if (CLV_POPUP_SIZE_QUICK_EDIT.equals(propertiesParam.getName())) {
                properties = this.readPropertiesFromXML(propertiesParam);
                this.propertiesMap.put(CLV_POPUP_SIZE_QUICK_EDIT, properties);
                continue;
            }
            if (!CLV_POPUP_SIZE_EDIT_PORTLET_MODE.equals(propertiesParam.getName())) continue;
            properties = this.readPropertiesFromXML(propertiesParam);
            this.propertiesMap.put(CLV_POPUP_SIZE_EDIT_PORTLET_MODE, properties);
        }
    }

    public Object getProperties(String name) {
        return this.propertiesMap.get(name);
    }

    private PopupWindowProperties readPropertiesFromXML(PropertiesParam param) {
        PopupWindowProperties properties = new PopupWindowProperties();
        String width = param.getProperty("width");
        String height = param.getProperty("height");
        if (width != null && StringUtils.isNumeric((String)width)) {
            properties.setWidth(Integer.parseInt(width));
        }
        if (height != null && StringUtils.isNumeric((String)height)) {
            properties.setHeight(Integer.parseInt(height));
        }
        return properties;
    }

    public static class PopupWindowProperties {
        public static final String WIDTH = "width";
        public static final String HEIGHT = "height";
        private int width = 500;
        private int height = 300;

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }
    }
}

