/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.impl;

import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.EventType;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.api.settings.data.SettingContext;
import org.exoplatform.commons.api.settings.data.SettingData;
import org.exoplatform.commons.api.settings.data.SettingKey;
import org.exoplatform.commons.api.settings.data.SettingScope;
import org.exoplatform.commons.api.settings.data.Tools;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.commons.event.impl.EventManagerImpl;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.Event;
import org.exoplatform.settings.chromattic.ContextEntity;
import org.exoplatform.settings.chromattic.ScopeEntity;
import org.exoplatform.settings.chromattic.SettingsRoot;
import org.exoplatform.settings.chromattic.SimpleContextEntity;
import org.exoplatform.settings.chromattic.SubContextEntity;
import org.exoplatform.settings.chromattic.SynchronizationTask;

public class SettingServiceImpl
implements SettingService {
    private static final ChromatticLifeCycle chromatticLifeCycle;
    private final EventManagerImpl<SettingServiceImpl, SettingData> eventManager;

    public SettingServiceImpl(EventManagerImpl<SettingServiceImpl, SettingData> eventManager) throws NullPointerException {
        this.eventManager = eventManager;
    }

    public void set(final Context context, final Scope scope, final String key, final SettingValue<?> value) {
        new SynchronizationTask<Object>(){

            @Override
            protected Object execute(SessionContext ctx) {
                ScopeEntity scopeEntity = SettingServiceImpl.this.getScope(context, scope);
                if (scopeEntity == null) {
                    scopeEntity = SettingServiceImpl.this.createScope(context, scope);
                }
                scopeEntity.setValue(key, value.getValue());
                ctx.getSession().save();
                return null;
            }
        }.executeWith(chromatticLifeCycle);
        SettingData data = new SettingData(EventType.SETTING_SET, (SettingContext)new SettingKey(context, scope, key), value);
        this.eventManager.broadcastEvent((Event<SettingServiceImpl, SettingData>)new Event(data.getEventType().toString(), (Object)this, (Object)data));
    }

    public SettingValue<?> get(final Context c, final Scope s, final String key) {
        Object got = new SynchronizationTask<Object>(){

            @Override
            protected Object execute(SessionContext ctx) {
                ScopeEntity scope = SettingServiceImpl.this.getScope(c, s);
                if (scope == null) {
                    return null;
                }
                return scope.getValue(key);
            }
        }.executeWith(chromatticLifeCycle);
        if (got instanceof Long) {
            return SettingValue.create((Long)((Long)got));
        }
        if (got instanceof String) {
            return SettingValue.create((String)((String)got));
        }
        if (got instanceof Double) {
            return SettingValue.create((Double)((Double)got));
        }
        if (got instanceof Boolean) {
            return SettingValue.create((Boolean)((Boolean)got));
        }
        return null;
    }

    private ScopeEntity createScope(final Context c, final Scope s) {
        return (ScopeEntity)new SynchronizationTask<ScopeEntity>(){

            @Override
            protected ScopeEntity execute(SessionContext ctx) {
                SettingsRoot settings = (SettingsRoot)ctx.getSession().findByPath(SettingsRoot.class, "settings");
                if (settings == null) {
                    settings = (SettingsRoot)ctx.getSession().insert(SettingsRoot.class, "settings");
                }
                SimpleContextEntity contextEntity = null;
                switch (c) {
                    case GLOBAL: {
                        contextEntity = (SimpleContextEntity)settings.getContext(c.name().toLowerCase());
                        if (contextEntity != null) break;
                        contextEntity = (SimpleContextEntity)ctx.getSession().insert((Object)settings, SimpleContextEntity.class, c.name().toLowerCase());
                        break;
                    }
                    case USER: {
                        SubContextEntity userContextEntity = (SubContextEntity)settings.getContext(c.name().toLowerCase());
                        if (userContextEntity == null) {
                            userContextEntity = (SubContextEntity)ctx.getSession().insert((Object)settings, SubContextEntity.class, c.name().toLowerCase());
                        }
                        if ((contextEntity = userContextEntity.getContext(c.getId())) != null) break;
                        contextEntity = (SimpleContextEntity)ctx.getSession().insert((Object)userContextEntity, SimpleContextEntity.class, c.getId());
                    }
                }
                ScopeEntity scopeEntity = contextEntity.getScope(s.name().toLowerCase());
                if (scopeEntity == null) {
                    scopeEntity = (ScopeEntity)ctx.getSession().insert((Object)contextEntity, ScopeEntity.class, s.name().toLowerCase());
                }
                if (s.getId() == null) {
                    return scopeEntity;
                }
                ScopeEntity scopeInstanceEntity = scopeEntity.getInstance(s.getId());
                if (scopeInstanceEntity == null) {
                    return (ScopeEntity)ctx.getSession().insert((Object)scopeEntity, ScopeEntity.class, s.getId());
                }
                return null;
            }
        }.executeWith(chromatticLifeCycle);
    }

    private ScopeEntity getScope(final Context c, final Scope s) {
        return (ScopeEntity)new SynchronizationTask<ScopeEntity>(){

            @Override
            protected ScopeEntity execute(SessionContext ctx) {
                return (ScopeEntity)ctx.getSession().findByPath(ScopeEntity.class, Tools.buildScopePath((Context)c, (Scope)s));
            }
        }.executeWith(chromatticLifeCycle);
    }

    private ContextEntity getContext(final Context context) {
        return (ContextEntity)new SynchronizationTask<ContextEntity>(){

            @Override
            protected ContextEntity execute(SessionContext ctx) {
                return (ContextEntity)ctx.getSession().findByPath(ContextEntity.class, Tools.buildContextPath((Context)context));
            }
        }.executeWith(chromatticLifeCycle);
    }

    public void remove(final Context c, final Scope s, final String key) {
        new SynchronizationTask<Object>(){

            @Override
            protected Object execute(SessionContext ctx) {
                ScopeEntity scope = SettingServiceImpl.this.getScope(c, s);
                if (scope == null) {
                    return null;
                }
                return scope.removeValue(key);
            }
        }.executeWith(chromatticLifeCycle);
        SettingData data = new SettingData(EventType.SETTING_REMOVE_KEY, (SettingContext)new SettingKey(c, s, key));
        this.eventManager.broadcastEvent((Event<SettingServiceImpl, SettingData>)new Event(data.getEventType().toString(), (Object)this, (Object)data));
    }

    public void remove(final Context context, final Scope scope) {
        if (Scope.GLOBAL.equals((Object)scope)) {
            throw new IllegalArgumentException("The context type or Scope Type must be not GLOBAL");
        }
        if (scope.getId() == null) {
            throw new IllegalArgumentException("The id property of your scope parameter  must be not null");
        }
        new SynchronizationTask<Object>(){

            @Override
            protected Object execute(SessionContext ctx) {
                ScopeEntity scopeEntity = SettingServiceImpl.this.getScope(context, scope);
                if (scopeEntity != null) {
                    scopeEntity.remove();
                }
                return null;
            }
        }.executeWith(chromatticLifeCycle);
        SettingData data = new SettingData(EventType.SETTING_REMOVE_SCOPE, (SettingContext)new SettingScope(context, scope));
        this.eventManager.broadcastEvent((Event<SettingServiceImpl, SettingData>)new Event(data.getEventType().toString(), (Object)this, (Object)data));
    }

    public void remove(final Context context) {
        if (Context.GLOBAL.equals((Object)context)) {
            throw new IllegalArgumentException("The context type must be not GLOBAL");
        }
        if (context.getId() == null) {
            throw new IllegalArgumentException("The id property of your context parameter must be not null");
        }
        new SynchronizationTask<Object>(){

            @Override
            protected Object execute(SessionContext ctx) {
                ContextEntity contextEntity = SettingServiceImpl.this.getContext(context);
                if (contextEntity != null) {
                    contextEntity.remove();
                }
                return null;
            }
        }.executeWith(chromatticLifeCycle);
        SettingData data = new SettingData(EventType.SETTING_REMOVE_CONTEXT, new SettingContext(context));
        this.eventManager.broadcastEvent((Event<SettingServiceImpl, SettingData>)new Event(data.getEventType().toString(), (Object)this, (Object)data));
    }

    public static boolean startSynchronization() {
        if (chromatticLifeCycle.getManager().getSynchronization() == null) {
            chromatticLifeCycle.getManager().beginRequest();
            return true;
        }
        return false;
    }

    public static void stopSynchronization(boolean requestClose) {
        if (requestClose) {
            chromatticLifeCycle.getManager().endRequest(true);
        }
    }

    static {
        PortalContainer container = PortalContainer.getInstance();
        ChromatticManager manager = (ChromatticManager)container.getComponentInstanceOfType(ChromatticManager.class);
        chromatticLifeCycle = manager.getLifeCycle("setting");
        if (chromatticLifeCycle == null) {
            throw new NullPointerException("Lifecycle Setting null");
        }
    }
}

